/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.http;

import ants.p2p.MessageWrapper;
import ants.p2p.WarriorAnt;
import ants.p2p.http.HttpRequestMessage;
import ants.p2p.http.HttpResponsePartMessage;
import ants.p2p.http.HttpTransferEndControlMessage;
import ants.p2p.security.EndpointSecurityManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;

public class HttpRequestHandler
extends Thread {
    static Logger _logger = Logger.getLogger((class$ants$p2p$http$HttpRequestHandler == null ? (class$ants$p2p$http$HttpRequestHandler = HttpRequestHandler.class$("ants.p2p.http.HttpRequestHandler")) : class$ants$p2p$http$HttpRequestHandler).getName());
    static /* synthetic */ Class class$ants$p2p$http$HttpRequestHandler;
    int currentId = 0;
    HttpRequestMessage requestMessage;
    WarriorAnt wa;

    public HttpRequestHandler(HttpRequestMessage requestMessage, WarriorAnt wa) {
        this.wa = wa;
        this.requestMessage = requestMessage;
        this.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof HttpRequestMessage) {
            return this.requestMessage.equals(o);
        }
        return this == o;
    }

    public WarriorAnt getWarriorAnt() {
        return this.wa;
    }

    /*
     * WARNING - void declaration
     */
    void handleRequest() {
        Socket s = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int n;
            s = new Socket("localhost", WarriorAnt.getHttpLocalServerPort());
            s.setSoTimeout(5000);
            os = s.getOutputStream();
            is = s.getInputStream();
            os.write(this.requestMessage.getBody());
            s.shutdownOutput();
            byte[] response = new byte[1024];
            _logger.debug("Show Browser Request:");
            String browserRequest = "";
            int x = 0;
            while (x < this.requestMessage.getBody().length) {
                browserRequest = browserRequest + (char)this.requestMessage.getBody()[x];
                ++x;
            }
            _logger.debug(browserRequest);
            _logger.debug("Waiting for Response...");
            while ((n = is.read(response)) != -1) {
                void var7_10;
                if (var7_10 < response.length) {
                    byte[] responseShorted = new byte[var7_10];
                    int x2 = 0;
                    while (x2 < var7_10) {
                        responseShorted[x2] = response[x2];
                        ++x2;
                    }
                    EndpointSecurityManager esm = this.getWarriorAnt().getInputSecureConnectionManager(this.requestMessage.getSource());
                    if (esm == null) {
                        throw new Exception("No secure connection avaiable with endpoint " + this.requestMessage.getSource());
                    }
                    HttpResponsePartMessage httpResponsePartMessage = new HttpResponsePartMessage(responseShorted, this.requestMessage, new Integer(this.currentId++));
                    httpResponsePartMessage.encrypt(esm.getCipherEnc());
                    MessageWrapper wm = this.getWarriorAnt().sendMessage(httpResponsePartMessage, this.requestMessage.getSource(), false, false);
                    while (this.getWarriorAnt().myMessages.contains(wm)) {
                        Thread.sleep(1000L);
                    }
                    if (!this.getWarriorAnt().failedMessages.contains(wm)) continue;
                    httpResponsePartMessage.decrypt(esm.getCipherDec());
                    this.getWarriorAnt().failedMessages.remove(wm);
                    _logger.debug(this.getWarriorAnt().getId() + ": Error in sending HttpResponsePartMessage" + " - Cannot send to id " + httpResponsePartMessage.getDest());
                    this.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpResponsePartError", null, this.requestMessage);
                    return;
                }
                EndpointSecurityManager esm = this.getWarriorAnt().getInputSecureConnectionManager(this.requestMessage.getSource());
                if (esm == null) {
                    throw new Exception("No secure connection avaiable with endpoint " + this.requestMessage.getSource());
                }
                HttpResponsePartMessage httpResponsePartMessage = new HttpResponsePartMessage(response, this.requestMessage, new Integer(this.currentId++));
                httpResponsePartMessage.encrypt(esm.getCipherEnc());
                MessageWrapper wm = this.getWarriorAnt().sendMessage(httpResponsePartMessage, this.requestMessage.getSource(), false, false);
                while (this.getWarriorAnt().myMessages.contains(wm)) {
                    Thread.sleep(1000L);
                }
                if (!this.getWarriorAnt().failedMessages.contains(wm)) continue;
                httpResponsePartMessage.decrypt(esm.getCipherDec());
                this.getWarriorAnt().failedMessages.remove(wm);
                _logger.debug(this.getWarriorAnt().getId() + ": Error in sending HttpResponsePartMessage" + " - Cannot send to id " + httpResponsePartMessage.getDest());
                this.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpResponsePartError", null, this.requestMessage);
                return;
            }
        }
        catch (Exception e) {
            _logger.error("Error in serving request", e);
        }
        try {
            EndpointSecurityManager esm = this.getWarriorAnt().getInputSecureConnectionManager(this.requestMessage.getSource());
            if (esm == null) {
                throw new Exception("No secure connection avaiable with endpoint " + this.requestMessage.getSource());
            }
            HttpTransferEndControlMessage httpTransferEndControlMessage = new HttpTransferEndControlMessage(new Integer(0), null, "HttpTransfer ended", this.requestMessage);
            httpTransferEndControlMessage.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.getWarriorAnt().sendMessage(httpTransferEndControlMessage, this.requestMessage.getSource(), false, false);
            while (this.getWarriorAnt().myMessages.contains(wm)) {
                Thread.sleep(1000L);
            }
            if (this.getWarriorAnt().failedMessages.contains(wm)) {
                httpTransferEndControlMessage.decrypt(esm.getCipherDec());
                this.getWarriorAnt().failedMessages.remove(wm);
                _logger.debug(this.getWarriorAnt().getId() + ": Error in sending HttpResponsePartMessage" + " - Cannot send to id " + httpTransferEndControlMessage.getDest());
                this.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpResponsePartError", null, this.requestMessage);
                return;
            }
            _logger.debug("End of Response");
            s.shutdownInput();
            s.close();
        }
        catch (Exception e) {
            _logger.error("Error in sending end of response", e);
        }
    }

    public void run() {
        this.handleRequest();
    }
}

