/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageWrapper {
    public List alreadyVisited;
    private long creationDate;
    private Message message;
    public List notToBeConsidered = Collections.synchronizedList(new ArrayList());
    private String requiredBy = null;
    private String routedTo = null;

    public MessageWrapper(Message message, String requirer) {
        this.alreadyVisited = Collections.synchronizedList(new ArrayList());
        this.message = message;
        this.creationDate = System.currentTimeMillis();
        this.requiredBy = requirer;
    }

    public void disableAutoRetransmit() {
        this.message.disableAutoRetransmit();
    }

    public boolean equals(Object o) {
        if (o instanceof MessageWrapper) {
            return ((MessageWrapper)o).message.getAck_Id().equals(this.message.getAck_Id()) && ((MessageWrapper)o).message.getType() == this.message.getType();
        }
        try {
            return ((Message)o).getAck_Id().equals(this.message.getAck_Id()) && ((Message)o).getType() == this.message.getType();
        }
        catch (ClassCastException e) {
            return o == this;
        }
    }

    public long getLifetime() {
        return System.currentTimeMillis() - this.creationDate;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getRequirer() {
        return this.requiredBy;
    }

    public int getRetrasmissions() {
        return this.message.getRetrasmissions();
    }

    public String getRoutedTo() {
        return this.routedTo;
    }

    public void retrasmitted(Ant n) {
        this.creationDate = System.currentTimeMillis();
        this.message.retrasmitted();
    }

    public void setRequirer(String requiredBy) {
        this.requiredBy = requiredBy;
    }

    public void setRoutedTo(String routedTo) {
        this.routedTo = routedTo;
    }

    public void setStoreFormat() {
        this.message = new Message(this.message);
    }
}

