/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.InnoValDates;
import innoval.mailer.SortDataItem;
import java.util.Vector;
import jclass.util.JCString;
import jclass.util.JCVector;

public class SortData {
    static final int SORT_TEXT = 0;
    static final int SORT_ADDRESS = 1;
    static final int SORT_SUBJECT = 2;
    static final int SORT_BYTES = 3;
    static final int SORT_DATE = 4;

    SortData(JCVector vector, int column, int type) {
        System.gc();
        Vector sortVector = this.setupVector(vector, column, type);
        this.heapSort(sortVector);
        this.loadVector(sortVector, vector);
        sortVector = null;
    }

    private void loadVector(Vector sortVector, JCVector vector) {
        SortDataItem item = null;
        JCVector oVector = (JCVector)vector.clone();
        for (int i = 0; i < sortVector.size(); ++i) {
            item = (SortDataItem)sortVector.elementAt(i);
            vector.setElementAt(oVector.elementAt(item.index), i);
        }
        oVector = null;
    }

    private Vector setupVector(JCVector dVector, int column, int type) {
        Vector element = null;
        Vector<SortDataItem> vector = new Vector<SortDataItem>();
        for (int i = 0; i < dVector.size(); ++i) {
            element = (Vector)dVector.elementAt(i);
            vector.addElement(this.scrubData(element.elementAt(column), type, i));
        }
        return vector;
    }

    private SortDataItem scrubData(Object obj, int type, int index) {
        SortDataItem item = null;
        String str = "";
        if (obj instanceof String) {
            str = (String)obj;
        } else if (obj instanceof JCString) {
            str = ((JCString)obj).toString2();
        }
        switch (type) {
            case 0: {
                item = new SortDataItem(str, index);
                break;
            }
            case 1: {
                item = new SortDataItem(SortData.cleanAddress(str), index);
                break;
            }
            case 2: {
                item = new SortDataItem(SortData.cleanSubject(str), index);
                break;
            }
            case 3: {
                item = new SortDataItem(this.getLongValue(str), index);
                break;
            }
            case 4: {
                item = new SortDataItem(InnoValDates.dateToLong(str), index);
            }
        }
        return item;
    }

    private long getLongValue(String str) {
        int mult = 1;
        if ((str = new String(str.toUpperCase())).endsWith("K")) {
            str = new String(str.substring(0, str.length() - 1));
            mult = 1024;
        } else if (str.endsWith("MEG")) {
            str = new String(str.substring(0, str.length() - 3));
            mult = 0x100000;
        }
        long val = 0L;
        try {
            val = Long.valueOf(str) * (long)mult;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public void quickSort(Vector vector) {
        Vector vector2;
        Vector vector1;
        boolean chk = false;
        if (vector.size() > 1) {
            int i;
            vector1 = new Vector();
            vector2 = new Vector();
            Object obj1 = vector.elementAt(vector.size() - 1);
            vector.removeElementAt(vector.size() - 1);
            vector2.addElement(obj1);
            for (i = 0; i < vector.size(); ++i) {
                Object obj2 = vector.elementAt(i);
                chk = this.compare((SortDataItem)obj1, (SortDataItem)obj2);
                if (!chk) {
                    vector2.addElement(obj2);
                    continue;
                }
                vector1.addElement(obj2);
            }
            vector.removeAllElements();
            this.quickSort(vector2);
            this.quickSort(vector1);
            for (i = 0; i < vector1.size(); ++i) {
                obj1 = vector1.elementAt(i);
                vector.addElement(obj1);
            }
            for (i = 0; i < vector2.size(); ++i) {
                obj1 = vector2.elementAt(i);
                vector.addElement(obj1);
            }
        }
        vector1 = null;
        vector2 = null;
    }

    private boolean compare(SortDataItem obj1, SortDataItem obj2) {
        boolean ret_code = false;
        if (obj1.text != null) {
            if (obj1.text.toLowerCase().compareTo(obj2.text.toLowerCase()) >= 0) {
                ret_code = true;
            }
        } else if (obj1.value >= obj2.value) {
            ret_code = true;
        }
        return ret_code;
    }

    public static String cleanAddress(String text) {
        String ttext = new String(text.trim().toUpperCase());
        text = null;
        int spot = ttext.indexOf(60);
        if (spot >= 0) {
            ttext = new String(ttext.substring(spot + 1));
        }
        return ttext;
    }

    public static String cleanSubject(String text) {
        int spot;
        if ((text = new String(text.trim().toLowerCase())).toLowerCase().startsWith("[img=") && (spot = text.indexOf(93)) >= 0) {
            text = new String(text.substring(spot + 1));
        }
        while (text.startsWith("re:")) {
            text = new String(text.substring(3).trim());
        }
        while (text.startsWith("fwd:")) {
            text = new String(text.substring(4).trim());
        }
        while (text.startsWith("re ")) {
            text = new String(text.substring(3).trim());
        }
        return text.trim();
    }

    public void heapSort(Vector vector) {
        Object obj = null;
        if (vector.size() > 1) {
            int n = vector.size() - 1;
            for (int i = (n - 1) / 2; i >= 0; --i) {
                this.downheap(vector, i, n);
            }
            int i = n;
            while (i > 0) {
                obj = vector.elementAt(i);
                vector.setElementAt(vector.elementAt(0), i);
                vector.setElementAt(obj, 0);
                this.downheap(vector, 0, --i);
            }
        }
    }

    private void downheap(Vector vector, int first, int last) {
        int parent;
        Object temp;
        int child;
        int i = first;
        while ((child = i * 2 + 1) <= last) {
            if (child + 1 <= last && this.compare((SortDataItem)vector.elementAt(child + 1), (SortDataItem)vector.elementAt(child))) {
                ++child;
            }
            temp = vector.elementAt(i);
            vector.setElementAt(vector.elementAt(child), i);
            vector.setElementAt(temp, child);
            i = child;
        }
        while ((parent = (i - 1) / 2) >= first && parent != i && !this.compare((SortDataItem)vector.elementAt(parent), (SortDataItem)vector.elementAt(i))) {
            temp = vector.elementAt(i);
            vector.setElementAt(vector.elementAt(parent), i);
            vector.setElementAt(temp, parent);
            i = parent;
        }
    }
}

