/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.FolderCreateDecide;
import innoval.mailer.FolderItem;
import innoval.mailer.FolderList;
import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;

public class SelectFolder
extends Dialog
implements KeyListener,
ActionListener,
MouseListener {
    static final int CHECK_FOLDER = 0;
    static final int CHECK_CURRENT = 10;
    static final int CHECK_NONE = 11;
    public boolean ret_code = false;
    public boolean compose = false;
    public boolean noOutbox = false;
    private int selection = 0;
    private FolderItem folder;
    private FolderItem currentFolder;
    private FolderList folderlist;
    private jstreet parent;
    private Frame frame;
    private CheckboxGroup checkGroup;
    private String dir;
    private Checkbox currentCheck;
    private Checkbox noneCheck;
    private Checkbox selCheck;
    private Button okButton;
    private Button cancelButton;
    private Button createButton;
    private Button expandButton;
    private Button collapseButton;

    SelectFolder(Frame frame, jstreet parent, String dir, FolderItem currentFolder) {
        super(frame, "Select a Folder", true);
        this.frame = frame;
        this.parent = parent;
        this.folder = null;
        this.ret_code = false;
        this.currentFolder = currentFolder;
        this.dir = dir;
        this.initDialog();
    }

    SelectFolder(Frame frame, jstreet parent, String dir, boolean compose, boolean noOutbox) {
        super(frame, "Select a Folder", true);
        this.compose = compose;
        this.noOutbox = noOutbox;
        this.frame = frame;
        this.parent = parent;
        this.folder = null;
        this.ret_code = false;
        this.currentFolder = null;
        this.dir = dir;
        this.initDialog();
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{250, 2, 2, 2, 5, 20, 5};
        int[] columnWidths = new int[]{5, 80, 5, 80, 5, 80, 5, 80, 5, 80, 5};
        double[] rowWeights = new double[]{10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.folderlist = new FolderList(this.parent, this.dir, false);
        this.folderlist.setRmbActive(false);
        this.folderlist.setCompose(this.noOutbox);
        this.folderlist.setRootVisible(false);
        this.folderlist.setPreferredSize(60, 60);
        this.add(this.folderlist);
        this.folderlist.getViewport().addMouseListener(this);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 11;
        grid.setConstraints(this.folderlist, con);
        if (this.compose) {
            this.checkGroup = new CheckboxGroup();
            this.selCheck = new Checkbox("File message to the selected folder", true, this.checkGroup);
            this.add(this.selCheck);
            jstreet.reset(con);
            con.gridx = 1;
            con.gridy = 1;
            con.gridwidth = 9;
            grid.setConstraints(this.selCheck, con);
            this.currentCheck = new Checkbox("File message to the current month/year folder", false, this.checkGroup);
            this.add(this.currentCheck);
            jstreet.reset(con);
            con.gridx = 1;
            con.gridy = 2;
            con.gridwidth = 9;
            grid.setConstraints(this.currentCheck, con);
            this.noneCheck = new Checkbox("Do not file message", false, this.checkGroup);
            this.add(this.noneCheck);
            jstreet.reset(con);
            con.gridx = 1;
            con.gridy = 3;
            con.gridwidth = 9;
            grid.setConstraints(this.noneCheck, con);
        }
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        grid.setConstraints(this.cancelButton, con);
        this.createButton = new Button("New");
        this.createButton.addActionListener(this);
        this.createButton.addKeyListener(this);
        this.add(this.createButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        grid.setConstraints(this.createButton, con);
        this.expandButton = new Button("Expand All");
        this.expandButton.addActionListener(this);
        this.expandButton.addKeyListener(this);
        this.add(this.expandButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 5;
        grid.setConstraints(this.expandButton, con);
        this.collapseButton = new Button("Collapse All");
        this.collapseButton.addActionListener(this);
        this.collapseButton.addKeyListener(this);
        this.add(this.collapseButton);
        jstreet.reset(con);
        con.gridx = 9;
        con.gridy = 5;
        grid.setConstraints(this.collapseButton, con);
        this.setLayout(grid);
        this.pack();
        jstreet.centerDialog(this, null);
        this.enableEvents(64L);
        this.folderlist.load();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 16 && e.getClickCount() > 1) {
            ActionEvent ev = new ActionEvent(this.okButton, 1001, "");
            this.actionPerformed(ev);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            } else if (e.getSource() == this.createButton) {
                evt = this.createButton;
            } else if (e.getSource() == this.expandButton) {
                evt = this.expandButton;
            } else if (e.getSource() == this.collapseButton) {
                evt = this.collapseButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.processSelection();
        } else if (e.getSource() == this.cancelButton) {
            this.Close();
        } else if (e.getSource() == this.createButton) {
            FolderCreateDecide check = new FolderCreateDecide(this.frame);
            check.show();
            switch (check.getChoice()) {
                case 1: {
                    this.folderlist.createFolder(this.parent);
                    break;
                }
                case 2: {
                    this.folderlist.createSubFolder(this.parent);
                }
            }
        } else if (e.getSource() == this.expandButton) {
            this.folderlist.expandCollapse(true);
        } else if (e.getSource() == this.collapseButton) {
            this.folderlist.expandCollapse(false);
        }
    }

    public void processSelection() {
        if (this.compose && this.currentCheck.getState()) {
            this.selection = 10;
            this.ret_code = true;
        } else if (this.compose && this.noneCheck.getState()) {
            this.selection = 11;
            this.ret_code = true;
        } else if (this.currentFolder == null) {
            this.ret_code = true;
        } else {
            FolderItem item = (FolderItem)this.folderlist.getSelectedNode();
            String fpath = null;
            String cpath = null;
            if (item != null) {
                fpath = item.getPath().getAbsolutePath();
            }
            cpath = this.currentFolder.getPath().getAbsolutePath();
            if (fpath == null) {
                MsgBox msgBox = new MsgBox(this.parent, "No folder is currently selected.");
            } else if (fpath.compareTo(cpath) != 0) {
                this.ret_code = true;
            } else {
                MsgBox msgBox = new MsgBox(this.parent, "The currently active folder in the application is not a valid selection.");
            }
        }
        if (this.ret_code) {
            if (this.selection == 0) {
                this.folder = (FolderItem)this.folderlist.getSelectedNode();
            }
            this.Close();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void Close() {
        this.dispose();
    }

    public FolderItem getSelectedFolder() {
        return this.folder;
    }

    public int getSelection() {
        return this.selection;
    }
}

