/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AccountIndex;
import innoval.mailer.MsgBox;
import innoval.mailer.NewAccount;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class SelectAccount
extends Dialog
implements KeyListener,
ActionListener {
    public boolean ret_code;
    public boolean force;
    public boolean newaccount;
    private AccountIndex accountIndex;
    private String account;
    private String dir;
    private List list;
    private Frame parent;
    private File indexfile;
    private Button okButton;
    private Button cancelButton;
    private Button newButton;

    SelectAccount(Frame parent, AccountIndex accountIndex, File indexfile, String dir, boolean force) {
        super(parent, "Select an Account", true);
        this.setResizable(false);
        this.parent = parent;
        this.accountIndex = accountIndex;
        this.dir = dir;
        this.indexfile = indexfile;
        this.account = new String("");
        this.ret_code = false;
        this.newaccount = false;
        this.force = force;
        this.initDialog();
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{150, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 60, 30, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.list = new List();
        this.list.addActionListener(this);
        this.list.addKeyListener(this);
        this.add(this.list);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 8;
        grid.setConstraints(this.list, con);
        this.loadList(this.indexfile);
        if (this.list.getItemCount() > 0) {
            this.list.select(0);
        }
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        grid.setConstraints(this.okButton, con);
        if (!this.force) {
            this.cancelButton = new Button("Cancel");
            this.cancelButton.addActionListener(this);
            this.cancelButton.addKeyListener(this);
            this.add(this.cancelButton);
            jstreet.reset(con);
            con.gridx = 3;
            con.gridy = 2;
            grid.setConstraints(this.cancelButton, con);
        }
        this.newButton = new Button("New");
        this.newButton.addActionListener(this);
        this.newButton.addKeyListener(this);
        this.add(this.newButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        grid.setConstraints(this.newButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.parent);
        this.list.requestFocus();
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton || e.getSource() == this.list) {
            if (this.list.getSelectedIndex() >= 0) {
                this.account = this.list.getSelectedItem();
                this.ret_code = true;
                this.dispose();
            } else {
                MsgBox msgBox = new MsgBox(this.parent, "No account is selected.");
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.newButton) {
            NewAccount newAccount = new NewAccount(this.parent, this.accountIndex, this.dir);
            newAccount.show();
            if (newAccount.ret_code) {
                this.account = newAccount.getAccount();
                this.newaccount = true;
                this.ret_code = true;
                this.dispose();
            }
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            if (!this.force) {
                this.dispose();
            } else {
                MsgBox msgBox = new MsgBox(this.parent, "You must specify a new or existing account.");
            }
        } else {
            super.processWindowEvent(evt);
        }
    }

    public String getAccount() {
        return this.account;
    }

    private void loadList(File file) {
        try {
            if (file.exists()) {
                String text;
                BufferedReader in = new BufferedReader(new FileReader(file));
                do {
                    if ((text = in.readLine()) == null || text.trim().length() <= 0 || text.charAt(0) == '~' || !this.accountIndex.validAccount(text)) continue;
                    this.list.addItem(text);
                } while (text != null);
                in.close();
            }
        }
        catch (IOException e) {
            MsgBox msgBox = new MsgBox(this.parent, String.valueOf("Error").concat(String.valueOf(e)));
        }
    }
}

