/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.PictureCanvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.io.File;

class PictureWindow
extends ScrollPane {
    private File file = null;
    private PictureCanvas canvas = null;
    private int width = 0;
    private int height = 0;

    PictureWindow(File file) {
        this.loadFile(file);
    }

    PictureWindow(File file, int parm) {
        super(parm);
        this.loadFile(file);
    }

    public boolean isLoaded() {
        boolean ret_code = false;
        if (this.file != null) {
            ret_code = true;
        }
        return ret_code;
    }

    public void loadFile(File file) {
        this.setVisible(false);
        if (this.canvas != null) {
            this.remove(this.canvas);
            this.canvas = null;
        }
        this.canvas = new PictureCanvas(this.readFile(file));
        this.add(this.canvas);
        this.invalidate();
        this.validate();
        this.repaint();
        this.canvas.repaint();
        int x = this.canvas.getSize().width;
        int y = this.canvas.getSize().height;
        this.setSize(x - 20, y - 20);
        this.setSize(x, y);
        this.setPreferredSize(x, y);
        this.setVisible(true);
    }

    public void setPreferredSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public int preferredHeight() {
        return this.height;
    }

    public int preferredWidth() {
        return this.width;
    }

    public Dimension preferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Image readFile(File file) {
        Image image = null;
        if (file != null && file.exists()) {
            image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        }
        return image;
    }

    public static Frame findFrame(Container cont) {
        Container frame;
        for (frame = cont; frame != null && !(frame instanceof Frame); frame = frame.getParent()) {
        }
        if (frame == null) {
            System.out.println("No Frame Container parent could be found.");
        }
        return (Frame)frame;
    }

    public void print() {
        Frame frame = PictureWindow.findFrame(this);
        if (frame != null) {
            PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(frame, "Printing Image", null);
            if (pj != null) {
                Graphics g = pj.getGraphics();
                if (g != null) {
                    this.canvas.paint(g);
                    g.dispose();
                } else {
                    System.err.println("Could not get Graphics handle.");
                }
                pj.end();
            } else {
                System.err.println("PrintJob cancelled.");
            }
        }
    }
}

