/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.SelectAddressBook;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;

public class NewAddressBook
extends Dialog
implements KeyListener,
ActionListener {
    private jstreet parent;
    private Frame frame;
    private Button okButton;
    private Button cancelButton;
    private Button selectButton;
    private String bookName;
    private Label label1;
    private boolean ret_code = false;
    private boolean select = false;
    private boolean value = true;
    private TextField bookField;
    private CheckboxGroup checkGroup;
    private Checkbox checkPrivate;
    private Checkbox checkPublic;

    NewAddressBook(Frame frame, jstreet parent, boolean select) {
        super(frame, "Create a New Address Book", true);
        this.frame = frame;
        this.parent = parent;
        this.select = select;
        this.setupDialog();
    }

    NewAddressBook(Frame frame, jstreet parent, String title) {
        super(frame, title, true);
        this.frame = frame;
        this.parent = parent;
        this.setupDialog();
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 20, 15, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 150, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Address Book Name", 2);
        label.setForeground(Color.black);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.bookField = new TextField();
        this.bookField.addKeyListener(this);
        this.add(this.bookField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(this.bookField, con);
        this.checkGroup = new CheckboxGroup();
        this.checkPublic = new Checkbox("Store as Public (accessible by all accounts)", this.checkGroup, true);
        this.checkPublic.addKeyListener(this);
        this.add(this.checkPublic);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        con.gridwidth = 2;
        grid.setConstraints(this.checkPublic, con);
        this.checkPrivate = new Checkbox("Store as Private (accessible by this account only)", this.checkGroup, false);
        this.checkPrivate.addKeyListener(this);
        this.add(this.checkPrivate);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 4;
        con.gridwidth = 2;
        grid.setConstraints(this.checkPrivate, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 6;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 6;
        grid.setConstraints(this.cancelButton, con);
        this.selectButton = new Button("Select an Existing Book");
        this.selectButton.addActionListener(this);
        this.selectButton.addKeyListener(this);
        if (this.select) {
            this.add(this.selectButton);
            jstreet.reset(con);
            con.gridx = 5;
            con.gridy = 6;
            grid.setConstraints(this.selectButton, con);
        }
        this.setLayout(grid);
        this.pack();
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
        this.show();
    }

    public String getName() {
        return this.bookName;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        SelectAddressBook sbook;
        if (e.getSource() == this.okButton) {
            if (this.checkBook()) {
                this.bookName = new String(String.valueOf(String.valueOf(String.valueOf(File.separator).concat(String.valueOf(this.bookField.getText().trim()))).concat(String.valueOf('.'))).concat(String.valueOf(jstreet.ADDRBOOKEXT)));
                this.bookName = this.checkPublic.getState() ? new String(String.valueOf(this.parent.getSystemDir()).concat(String.valueOf(this.bookName))) : new String(String.valueOf(this.parent.getAccountDir()).concat(String.valueOf(this.bookName)));
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.selectButton && (sbook = new SelectAddressBook(this.frame, this.parent)).getName() != null) {
            this.bookName = new String(sbook.getName());
            this.ret_code = true;
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private boolean checkBook() {
        boolean ret_code = false;
        String name = this.bookField.getText().trim();
        File file = null;
        if (name.length() > 0) {
            if (jstreet.validFile(name)) {
                name = new String(String.valueOf(String.valueOf(name).concat(String.valueOf('.'))).concat(String.valueOf(jstreet.ADDRBOOKEXT)));
                file = this.checkPublic.getState() ? new File(this.parent.getSystemDir(), name) : new File(this.parent.getAccountDir(), name);
                if (!file.exists()) {
                    ret_code = true;
                } else {
                    MsgBox msgBox = new MsgBox(this.frame, "The specified address book already exists.");
                }
            } else {
                MsgBox msgBox = new MsgBox(this.frame, "The specified address book name is not valid.");
            }
        } else {
            MsgBox msgBox = new MsgBox(this.frame, "Please specify an address book name.");
        }
        return ret_code;
    }
}

