/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class LongDialog
extends Dialog
implements KeyListener,
ActionListener {
    private Frame frame;
    private Button okButton;
    private Button cancelButton;
    private boolean ret_code = true;
    private CheckboxGroup checkGroup;
    private Checkbox checkLong;
    private Checkbox checkShort;

    LongDialog(Frame frame) {
        super(frame, "Specify a File Naming Preference", true);
        this.frame = frame;
        this.setupDialog();
    }

    public void setupDialog() {
        Label label;
        int row = 0;
        String[] txt = new String[]{"Most operating systems use file systems which support practically unlimited", "filename lengths. But other operating systems can be run on the original FAT", "file system, which only supports filenames of up to 8 characters, with an", "optional extension of up to 3 characters. If you need to be able to run the J", "Street Mailer on a FAT partition, then the program needs to know that it must", "use \"short\" (8.3) names for its files and directories.", "", "You will want to choose this option if you have no partitions that don't use", "the FAT file system, or if you want to share a single J Street Mailer", "installation among operating systems whose only file system in common is FAT.", "Be aware that if you choose to use the J Street Mailer on a FAT partition,", "your account names, folder names, address book names, draft names, etc., will", "have to adhere to the 8.3-character FAT filename limitation."};
        String[] txt2 = new String[]{"If you are unsure which answer to choose, \"long file names\" is most likely the", "right answer for you. If you had a need to use \"short file names\", you would", "probably know it."};
        int num = txt.length + txt2.length + 5;
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[num];
        int[] columnWidths = new int[]{5, 60, 5, 60, 350, 5};
        double[] rowWeights = new double[num];
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        for (int i = 0; i < num; ++i) {
            rowHeights[i] = 5;
            rowWeights[i] = 0.0;
        }
        rowWeights[num - 1] = 10.0;
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        for (int i = 0; i < txt.length; ++i) {
            label = new Label(txt[i]);
            this.add(label);
            jstreet.reset(con);
            con.gridx = 1;
            con.gridy = row++;
            con.gridwidth = 4;
            grid.setConstraints(label, con);
        }
        this.checkGroup = new CheckboxGroup();
        this.checkLong = new Checkbox("Use extended file names", this.checkGroup, true);
        this.checkLong.addKeyListener(this);
        this.add(this.checkLong);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = row++;
        con.gridwidth = 3;
        grid.setConstraints(this.checkLong, con);
        this.checkShort = new Checkbox("Use short file names (limited to 8.3)", this.checkGroup, false);
        this.checkShort.addKeyListener(this);
        this.add(this.checkShort);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = row++;
        con.gridwidth = 3;
        grid.setConstraints(this.checkShort, con);
        for (int i = 0; i < txt2.length; ++i) {
            label = new Label(txt2[i]);
            this.add(label);
            jstreet.reset(con);
            con.gridx = 1;
            con.gridy = row++;
            con.gridwidth = 4;
            grid.setConstraints(label, con);
        }
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = row;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = row;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
        this.show();
    }

    public boolean getReturn() {
        return this.ret_code;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.ret_code = this.checkLong.getState();
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }
}

