/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mail.Imap4;
import innoval.mail.Imap4Exception;
import innoval.mail.Imap4Folder;
import innoval.mailer.ImapMailbox;
import innoval.mailer.MsgBox;
import innoval.mailer.PreviewImapMail;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class ImapCreateFolder
extends Dialog
implements KeyListener,
ActionListener {
    private String name;
    private Imap4Folder folder;
    private Imap4 imap;
    private ImapMailbox parent;
    private PreviewImapMail frame;
    private Button okButton;
    private Button cancelButton;
    private TextField nameField;

    ImapCreateFolder(PreviewImapMail frame, Imap4 imap, String title) {
        super(frame, title, true);
        this.frame = frame;
        this.imap = imap;
        this.name = new String("");
        this.initDialog();
    }

    ImapCreateFolder(PreviewImapMail frame, Imap4 imap, ImapMailbox parent, String title) {
        super(frame, title, true);
        this.frame = frame;
        this.imap = imap;
        this.parent = parent;
        this.name = new String("");
        this.initDialog();
    }

    private void initDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 15, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 150, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Folder Name", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.nameField = new TextField();
        this.nameField.addKeyListener(this);
        this.add(this.nameField);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.nameField, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
    }

    public Imap4Folder getFolder() {
        return this.folder;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            MsgBox msgbox = null;
            this.name = new String(this.nameField.getText().trim());
            if (this.name.length() == 0) {
                msgbox = new MsgBox(this.frame, "Please specify a folder name.");
                this.nameField.requestFocus();
            } else {
                String dir = this.frame.getFrameParent().getProfile().ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.MAILFOLDER, "");
                try {
                    if (this.parent != null) {
                        this.folder = this.parent.getFolder().createFolder(this.name);
                    } else {
                        this.folder = this.imap.createFolder(String.valueOf(dir).concat(String.valueOf(this.name)));
                        if (dir.length() > 0) {
                            this.folder.setName(this.name);
                            this.folder.setPath(dir);
                        }
                    }
                }
                catch (Imap4Exception ex) {
                    msgbox = new MsgBox(this.frame, ex.toString());
                }
            }
            if (this.folder != null) {
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }
}

