/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

class FontInfo {
    private Font defaultPropFont;
    private Font defaultFixFont;
    private Font[] fonts;
    private FontMetrics[] fontMetrics;
    private String[] types;
    private int[] styles = new int[]{0, 1, 2, 3};
    private int[] f_sizes = new int[]{170, 170, 213, 213, 256, 256, 341, 341, 427, 427, 512, 512, 597, 597};
    public static final int NORMAL = 0;
    public static final int FIXED = 1;
    static final int NUM_TYPES = 2;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    static final int NUM_STYLES = 4;
    static final int NUM_SIZES = 7;
    static final int NUM = 56;

    FontInfo() {
        this(new Font("SansSerif", 0, 12), new Font("Monospaced", 0, 12));
    }

    FontInfo(Font propFont, Font fixFont) {
        if (propFont != null) {
            this.defaultPropFont = propFont;
        }
        if (fixFont != null) {
            this.defaultFixFont = fixFont;
        }
        this.fonts = new Font[56];
        this.fontMetrics = new FontMetrics[56];
        this.types = new String[2];
        this.types[0] = this.defaultPropFont.getFamily();
        this.types[1] = this.defaultFixFont.getFamily();
    }

    synchronized Font getPropFont() {
        return this.defaultPropFont;
    }

    synchronized Font getFixFont() {
        return this.defaultFixFont;
    }

    synchronized Font getFont(int font_idx) {
        if (this.fonts[font_idx] == null) {
            this.buildFont(font_idx);
        }
        return this.fonts[font_idx];
    }

    synchronized FontMetrics getFontMetrics(int font_idx) {
        if (this.fonts[font_idx] == null) {
            this.buildFont(font_idx);
        }
        return this.fontMetrics[font_idx];
    }

    private void buildFont(int font_idx) {
        int pix_size = this.f_sizes[FontInfo.getSize(font_idx) * 2 + FontInfo.getType(font_idx)];
        pix_size = FontInfo.getType(font_idx) == 0 ? (pix_size *= this.defaultPropFont.getSize()) : (pix_size *= this.defaultFixFont.getSize());
        this.fonts[font_idx] = new Font(this.types[FontInfo.getType(font_idx)], this.styles[FontInfo.getStyle(font_idx)], pix_size /= 256);
        this.fontMetrics[font_idx] = Toolkit.getDefaultToolkit().getFontMetrics(this.fonts[font_idx]);
    }

    static int getSize(int font) {
        return font %= 7;
    }

    static int getStyle(int font) {
        font /= 7;
        return font %= 4;
    }

    static int getType(int font) {
        font /= 28;
        return font %= 2;
    }

    static int makeFontIdx(int type, int style, int size) {
        return (type * 4 + style) * 7 + size;
    }

    static int setType(int font, int type) {
        if (type < 0 || type >= 2) {
            return font;
        }
        return FontInfo.makeFontIdx(type, FontInfo.getStyle(font), FontInfo.getSize(font));
    }

    static int setStyle(int font, int style) {
        if (style < 0 || style >= 4) {
            return font;
        }
        return FontInfo.makeFontIdx(FontInfo.getType(font), style |= FontInfo.getStyle(font), FontInfo.getSize(font));
    }

    static int setSize(int font, int size) {
        if (size < 0 || size >= 7) {
            return font;
        }
        return FontInfo.makeFontIdx(FontInfo.getType(font), FontInfo.getStyle(font), size);
    }
}

