/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Browser;
import ice.htmlbrowser.BrowserContext;
import ice.htmlbrowser.Document;
import java.net.URL;
import java.util.Hashtable;

class DocFrameInfo {
    private String frameName;
    private URL frameSrc;
    private Document frameDoc;
    private String frameOutputString;
    private Hashtable docCache = new Hashtable();
    private int marginWidth = 10;
    private int marginHeight = 10;
    private int scrollType = 0;
    private boolean needLoad = true;
    private int lx;
    private int ly;
    private int lw;
    private int lh;

    DocFrameInfo() {
    }

    DocFrameInfo(URL src, String name) {
        this.frameName = name;
        this.frameSrc = src;
    }

    void setFrameSrc(URL src) {
        this.setFrameSrc(src, null);
    }

    void setFrameSrc(URL src, String outputString) {
        this.frameSrc = src;
        this.frameOutputString = outputString;
        this.needLoad = true;
    }

    URL getFrameSrc() {
        return this.frameSrc;
    }

    void doLayout(int x, int y, int w, int h) {
        this.lx = x;
        this.ly = y;
        this.lw = w;
        this.lh = h;
        if (this.frameDoc != null) {
            this.frameDoc.setBounds(x, y, w, h);
            this.frameDoc.invalidate();
        }
    }

    void doLayout() {
        if (this.frameDoc != null) {
            this.frameDoc.setBounds(this.lx, this.ly, this.lw, this.lh);
        }
    }

    void showDocument(Document parent) {
        if (!this.needLoad) {
            this.frameDoc.showDocument();
            return;
        }
        this.needLoad = false;
        if (this.frameDoc != null) {
            this.frameDoc.hideDocument();
            parent.remove(this.frameDoc);
        }
        String key = Browser.makeCacheKey(this.frameSrc);
        this.frameDoc = this.frameOutputString == null ? (Document)this.docCache.get(key) : null;
        if (this.frameDoc == null) {
            BrowserContext bc;
            this.frameDoc = new Document(this.frameSrc, this.frameOutputString, parent.getReferer(), this.scrollType);
            this.frameDoc.setMarginWidth(this.marginWidth);
            this.frameDoc.setMarginHeight(this.marginHeight);
            if (this.frameName != null) {
                this.frameDoc.setFrameName(this.frameName);
            }
            if ((bc = parent.getBrowserContext()) != null && bc.isMemoryCaching()) {
                this.docCache.put(key, this.frameDoc);
            }
            parent.add(this.frameDoc);
            this.frameOutputString = null;
        } else {
            parent.add(this.frameDoc);
            parent.validate();
            this.frameDoc.showDocument();
        }
    }

    void hideDocument() {
        if (this.frameDoc != null && this.frameDoc.isVisible()) {
            this.frameDoc.hideDocument();
        }
    }

    Document getDocument() {
        return this.frameDoc;
    }

    DocFrameInfo findDocFrame(String targetFrame) {
        if (this.frameDoc.getFrameName().equals(targetFrame)) {
            return this;
        }
        return null;
    }

    boolean goBack(String targetFrame) {
        if (this.frameDoc != null && (targetFrame == null || this.frameDoc.getFrameName().equals(targetFrame))) {
            return this.frameDoc.goBack();
        }
        return false;
    }

    boolean goForward(String targetFrame) {
        if (this.frameDoc != null && (targetFrame == null || this.frameDoc.getFrameName().equals(targetFrame))) {
            return this.frameDoc.goForward();
        }
        return false;
    }

    void setMargins(int mw, int mh) {
        this.marginWidth = mw;
        this.marginHeight = mh;
    }

    void setScrolling(int scroll) {
        this.scrollType = scroll;
    }
}

