/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.ActiveBox;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.VisDocument;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

class BoxTableCell {
    private Box boxListHead;
    private Box boxListTail;
    private int boxListCount;
    private VisDocument vis_doc = new VisDocument();
    private int width;
    private int height;
    private int cellOriginX;
    private int cellOriginY;

    BoxTableCell() {
    }

    void activeShow() {
        for (Box b = this.boxListHead; b != null; b = b.getNext()) {
            if (!(b instanceof ActiveBox)) continue;
            ((ActiveBox)((Object)b)).activeShow();
        }
    }

    void activeHide() {
        for (Box b = this.boxListHead; b != null; b = b.getNext()) {
            if (!(b instanceof ActiveBox)) continue;
            ((ActiveBox)((Object)b)).activeHide();
        }
    }

    void activeInterrupt() {
        for (Box b = this.boxListHead; b != null; b = b.getNext()) {
            if (!(b instanceof ActiveBox)) continue;
            ((ActiveBox)((Object)b)).activeInterrupt();
        }
    }

    void layout(int visWidth, int startWidth) {
        this.translate(0, 0);
        this.vis_doc.doLayout(this.boxListHead, this.boxListCount, visWidth, startWidth);
        this.width = this.vis_doc.docSize().width;
        this.height = this.vis_doc.docSize().height;
    }

    void fakeLayout() {
        this.translate(0, 0);
    }

    Dimension size() {
        return new Dimension(this.width, this.height);
    }

    void addBox(Box b) {
        if (this.boxListHead == null) {
            this.boxListHead = this.boxListTail = b;
        } else {
            this.boxListTail.setNext(b);
            this.boxListTail = b;
        }
        ++this.boxListCount;
    }

    void translate(int ox, int oy) {
        for (Box b = this.boxListHead; b != null; b = b.getNext()) {
            Point pos = b.location();
            b.move(pos.x - this.cellOriginX + ox, pos.y - this.cellOriginY + oy);
        }
        this.cellOriginX = ox;
        this.cellOriginY = oy;
    }

    void paint(Graphics g) {
        this.vis_doc.paint(g, this.cellOriginX, this.cellOriginY);
    }

    Box mouseClicked(int x, int y) {
        return this.vis_doc.mouseClicked(x + this.cellOriginX, y + this.cellOriginY, this.cellOriginY);
    }

    Box mouseMoved(int x, int y) {
        return this.vis_doc.mouseMoved(x + this.cellOriginX, y + this.cellOriginY, this.cellOriginY);
    }

    Box getAnchorBox(String anchor) {
        Box theBox = null;
        for (Box b = this.boxListHead; b != null && theBox == null; b = b.getNext()) {
            theBox = b.getAnchorBox(anchor);
        }
        return theBox;
    }
}

