/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemEditSite;
import borland.jbcl.model.ItemEditor;
import borland.jbcl.model.ItemFormatter;
import borland.jbcl.util.InvalidFormatException;
import borland.jbcl.util.Variant;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;

public class TextItemEditor
extends TextField
implements ItemEditor {
    ItemFormatter itemFormatter;
    int alignment;

    public TextItemEditor(int n, Insets insets, ItemFormatter itemFormatter) {
        this.itemFormatter = itemFormatter;
        this.alignment = n;
    }

    public TextItemEditor(int n, Insets insets) {
        this(n, insets, null);
    }

    public TextItemEditor(int n) {
        this(n, new Insets(0, 0, 0, 0));
    }

    public TextItemEditor() {
        this(1);
    }

    public void startEdit(Object object, Rectangle rectangle, ItemEditSite itemEditSite) {
        String string;
        try {
            string = this.itemFormatter != null && object instanceof Variant ? this.itemFormatter.format(object) : (object != null ? object.toString() : "");
        }
        catch (InvalidFormatException invalidFormatException) {
            string = "";
        }
        ((TextComponent)this).setText(string);
        if (itemEditSite != null) {
            ((Component)this).setBackground(itemEditSite.getBackground());
            this.setForeground(itemEditSite.getForeground());
            this.setFont(itemEditSite.getFont());
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setVisible(true);
        Point point = itemEditSite != null ? itemEditSite.getEditClickPoint() : null;
        int n = 0;
        if (point == null && string != null) {
            n = string.length();
            this.select(0, n);
        } else if (string != null) {
            int n2;
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            int[] nArray = fontMetrics.getWidths();
            int n3 = point.x - rectangle.x;
            int n4 = 0;
            for (n2 = 0; n2 < string.length(); ++n2) {
                int n5;
                int n6 = string.charAt(n2) < '\u0100' ? nArray[string.charAt(n2)] : fontMetrics.charWidth(string.charAt(n2));
                int n7 = n5 = n6 > 3 ? n6 / 3 : 1;
                if (n4 + n5 >= n3) {
                    --n2;
                    break;
                }
                if (n4 + n6 - n5 >= n3) break;
                n4 += n6;
            }
            n = n2;
            this.select(n, n);
        }
        this.requestFocus();
    }

    public void changeBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Object getValue() {
        if (this.itemFormatter != null) {
            try {
                Object object = this.itemFormatter.parse(this.getText());
                return object;
            }
            catch (InvalidFormatException invalidFormatException) {
                String string = this.getText();
                return string;
            }
        }
        return this.getText();
    }

    public Component getComponent() {
        return this;
    }

    public boolean canPost() {
        return true;
    }

    public void endEdit(boolean bl) {
    }
}

