/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tables;

import java.util.Vector;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.tables.TableElementPanel;
import sunw.hotjava.tables.TablePanel;

class TableGrid {
    Vector rows = new Vector(5);

    TableGrid() {
    }

    TableGrid(TableGrid tableGrid, TablePanel tablePanel, DocumentState documentState) {
        int n = tableGrid.rows.size();
        this.rows = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            Vector vector = (Vector)tableGrid.rows.elementAt(n2);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                TableElementPanel tableElementPanel;
                if (tableGrid.isUpperLeft(n4, n2) && (tableElementPanel = tableGrid.elementAt(n4, n2)) != null) {
                    int n5 = tableElementPanel.getColSpan();
                    int n6 = tableElementPanel.getRowSpan();
                    TableElementPanel tableElementPanel2 = new TableElementPanel(tableElementPanel, tablePanel, documentState);
                    this.addElement(tableElementPanel2, n4, n2, n5, n6);
                    tablePanel.add(tableElementPanel2);
                }
                ++n4;
            }
            ++n2;
        }
    }

    void addElement(TableElementPanel tableElementPanel, int n, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n + n3;
        int n7 = this.rows.size();
        while (n7 < n5) {
            this.rows.addElement(new Vector(n6));
            ++n7;
        }
        n7 = n2;
        while (n7 < n5) {
            Vector vector = (Vector)this.rows.elementAt(n7);
            this.padColsTo(vector, n6);
            int n8 = n;
            while (n8 < n6) {
                vector.setElementAt(tableElementPanel, n8);
                ++n8;
            }
            ++n7;
        }
    }

    void insertCaption(TableElementPanel tableElementPanel, boolean bl, int n) {
        Vector<TableElementPanel> vector = new Vector<TableElementPanel>();
        this.padColsTo(vector, n);
        int n2 = 0;
        while (n2 < n) {
            vector.setElementAt(tableElementPanel, n2);
            ++n2;
        }
        if (bl) {
            this.rows.insertElementAt(vector, 0);
            return;
        }
        this.rows.addElement(vector);
    }

    void removeColumn(int n) {
        int n2 = 0;
        while (n2 < this.rows.size()) {
            Vector vector = (Vector)this.rows.elementAt(n2);
            if (n < vector.size()) {
                vector.removeElementAt(n);
            }
            ++n2;
        }
    }

    void removeRow(int n) {
        if (n >= this.rows.size() || n < 0) {
            return;
        }
        this.rows.removeElementAt(n);
    }

    int findNextFreeCol(int n) {
        if (n >= this.rows.size()) {
            return 0;
        }
        Vector vector = (Vector)this.rows.elementAt(n);
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) == null) {
                return n2;
            }
            ++n2;
        }
        return vector.size();
    }

    TableElementPanel elementAt(int n, int n2) {
        if (n2 >= this.rows.size()) {
            return null;
        }
        Vector vector = (Vector)this.rows.elementAt(n2);
        if (n >= vector.size()) {
            return null;
        }
        return (TableElementPanel)vector.elementAt(n);
    }

    boolean isUpperLeft(int n, int n2) {
        TableElementPanel tableElementPanel = this.elementAt(n, n2);
        if (n > 0 && this.elementAt(n - 1, n2) == tableElementPanel) {
            return false;
        }
        return n2 <= 0 || this.elementAt(n, n2 - 1) != tableElementPanel;
    }

    void printDebugInfo() {
        int n = 0;
        while (n < this.rows.size()) {
            System.out.print("|");
            Vector vector = (Vector)this.rows.elementAt(n);
            if (vector == null) {
                System.out.println("Empty columns in this row");
            } else {
                int n2 = 0;
                while (n2 < vector.size()) {
                    System.out.print(this.elementAt(n2, n) == this.elementAt(n2 + 1, n) ? "  " : " |");
                    ++n2;
                }
                System.out.println();
                System.out.print("|");
                int n3 = 0;
                while (n3 < vector.size()) {
                    System.out.print(this.elementAt(n3, n) == this.elementAt(n3, n + 1) ? "  " : "--");
                    ++n3;
                }
                System.out.println();
            }
            ++n;
        }
    }

    private void padColsTo(Vector vector, int n) {
        while (vector.size() < n) {
            vector.addElement(null);
        }
    }
}

