import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.*;
import se.datadosen.util.*;
/**
 * Title:        ShadowTextFilter
 * Description:  Like TextFilter, but with a shadow effect
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */
public class ShadowTextFilter extends TextFilter {

    private java.awt.Color shadowColor = Color.black;
    private int shadowDistance = 2;

    public ShadowTextFilter() {
        setColor(Color.white);
    }

    // Implements JAFilter
    public String getName() {
        return "ShadowText filter";
    }
    // Implements JAFilter
    public String getDescription() {
        return "Like TextFilter, but with a shadow effect";
    }

    // Implements JAFilter
    public BufferedImage filter(BufferedImage bi, Map vars) {
        Color current = getColor();
        setColor(shadowColor);
        setOffset(getOffset()+shadowDistance);
        setVoffset(getVoffset()+shadowDistance);
        bi = super.filter(bi, vars);
        setOffset(getOffset()-shadowDistance);
        setVoffset(getVoffset()-shadowDistance);
        setColor(current);
        bi = super.filter(bi, vars);
        return bi;
    }

    public void setShadowColor(java.awt.Color newShadowColor) {
        shadowColor = newShadowColor;
    }

    public void setShadowColor(String htmlColor) {
        shadowColor = Colors.getHTMLColor(htmlColor);
    }

    public java.awt.Color getShadowColor() {
        return shadowColor;
    }
    public void setShadowDistance(int newShadowDistance) {
        shadowDistance = newShadowDistance;
    }
    public int getShadowDistance() {
        return shadowDistance;
    }
}
