import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.*;
import se.datadosen.util.*;
import java.awt.font.*;
import java.awt.geom.*;

import static java.lang.Math.*;


/**
 * Title:        JAlbum name tagging filter
 * Company:      JAlbum AB
 * @author David Ekholm
 * @version 1.0
 */
public class NameTagFilter implements JAFilter, Cloneable {

    private Font font = new Font("SansSerif", Font.PLAIN, 14);
    private Color color = new Color(255,255,255,255);
    private Color bgColor = new Color(0,0,0,150);
    private boolean antialias = true;

    // Implements JAFilter
    public String getName() {
        return "Name tag filter";
    }

	// Implements JAFilter
    public String getDescription() {
        return "Picks up xmp name tags and applies them below each image region";
    }

	// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, Map vars) {
		Map xmp = (Map)vars.get("xmp");
		if (xmp == null) {
			return bi;	
		}
        int iw = bi.getWidth();
        int ih = bi.getHeight();

		Graphics2D g = bi.createGraphics();
        if (antialias)
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(font);
        
        int margin = font.getSize()/4+2; // Text to rectangle margin

        FontRenderContext frc = g.getFontRenderContext();
      
		// Iterate though all named regions
		String name;
		for (int i=1; (name = (String)xmp.get("mwg-rs:Regions/mwg-rs:RegionList["+ i +"]/mwg-rs:Name")) != null; i++) {
			String areaPrefix = "mwg-rs:Regions/mwg-rs:RegionList["+ i +"]/mwg-rs:Area/";
			float x = Float.parseFloat((String)xmp.get(areaPrefix + "stArea:x")) * iw;
			float y = Float.parseFloat((String)xmp.get(areaPrefix + "stArea:y")) * ih;
			float w = Float.parseFloat((String)xmp.get(areaPrefix + "stArea:w")) * iw;
			float h = Float.parseFloat((String)xmp.get(areaPrefix + "stArea:h")) * ih;
			
			// g.drawRect((int)(x-w/2), (int)(y-h/2),(int)w, (int)h);
			
	        Rectangle2D rect = font.getStringBounds(name, frc);
	        
	        g.setColor(bgColor);
	        g.fillRoundRect((int)(x-rect.getWidth()/2)-margin, (int)(y+h/2), (int)rect.getWidth()+2*margin, (int)rect.getHeight()+2*margin, margin*2, margin*2);
	        
	        g.setColor(color);
	        g.drawString(name, (int)(x-rect.getWidth()/2-rect.getX()), (int)(y+h/2-rect.getY())+margin);	
		}

        return bi;
    }

    // Implements Cloneable
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return font;
    }

    public void setSize(int newSize) {
        font = new Font(font.getName(), font.getStyle(), newSize);
    }
    public int getSize() {
        return font.getSize();
    }
    
    public void setFontFace(String fontFace) {
        font = new Font(fontFace, font.getStyle(), font.getSize());
    }
    public String getFontFace() {
        return font.getFamily();
    }

    public void setStyle(String fontStyle) {
        int style = Font.PLAIN;
        if (fontStyle.equalsIgnoreCase("bold")) style = Font.BOLD;
        else if (fontStyle.equalsIgnoreCase("italic")) style = Font.ITALIC;
        else if (fontStyle.equalsIgnoreCase("bolditalic")) style = Font.BOLD | Font.ITALIC;
        font = new Font(font.getName(), style, font.getSize());
    }
    public String getStyle() {
        switch (font.getStyle()) {
        case Font.BOLD : return "bold";
        case Font.ITALIC : return "italic";
        case Font.BOLD|Font.ITALIC: return "bolditalic";
        default: return "plain";
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String htmlColor) {
        this.color = Colors.getHTMLColor(htmlColor);
    }

    public Color getColor() {
        return color;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public void setBgColor(String htmlColor) {
        this.bgColor = Colors.getHTMLColor(htmlColor);
    }

    public Color getBgColor() {
        return bgColor;
    }

    public void setAntialias(boolean newAntialias) {
        antialias = newAntialias;
    }
    public boolean isAntialias() {
        return antialias;
    }
}