/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

public class Stopwatch {
    private long startTime = 0L;
    private long millis = 0L;
    private boolean running = false;
    private String label = "";
    private static Stopwatch stopwatch;

    public Stopwatch() {
    }

    public Stopwatch(String label) {
        this.label = label + ": ";
    }

    public synchronized void start() {
        if (!this.isRunning()) {
            this.startTime = System.currentTimeMillis();
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.millis += System.currentTimeMillis() - this.startTime;
            this.running = false;
        }
    }

    public synchronized void reset() {
        this.startTime = System.currentTimeMillis();
        this.millis = 0L;
    }

    public synchronized long getMillis() {
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.startTime + this.millis;
        }
        return this.millis;
    }

    public static String trace() {
        if (stopwatch == null) {
            stopwatch = new Stopwatch();
            stopwatch.start();
        }
        StackTraceElement[] elem = Thread.currentThread().getStackTrace();
        StackTraceElement last = elem[2];
        String s = " at " + last.getClassName() + "." + last.getMethodName() + "(" + last.getFileName() + ":" + last.getLineNumber() + ") " + stopwatch;
        System.out.println(s);
        return s;
    }

    public synchronized String toString() {
        float secs = (float)this.getMillis() / 1000.0f;
        int mins = (int)secs / 60;
        return this.label + (mins > 0 ? mins + "m " : "") + (secs -= (float)(60 * mins)) + "s";
    }

    public void print() {
        System.out.println(this);
    }

    public synchronized boolean isRunning() {
        return this.running;
    }
}

