/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.apple.eio.FileManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import org.jdesktop.jdic.fileutil.FileUtil;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.PermissionDeniedException;
import se.datadosen.util.Platform;
import se.datadosen.util.Replacer;
import se.datadosen.util.StringCodec;

public class IO {
    private static int BUFSIZE = 262144;
    private static boolean preserveLastModified = true;
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static ExecutorService threadPool = Executors.newCachedThreadPool();
    public static final String rfc3986Reserved = "!*'();@&=+$,?%#[]";
    public static final String reserved = "!*'();@&=+$,?%#[]`\" <>";

    public static File ensureUnique(File dir, String name) {
        File target = new File(dir, name);
        int i = 1;
        while (target.exists()) {
            target = new File(dir, name + "-" + i);
            ++i;
        }
        return target;
    }

    public static String readTextFile(File file, String encoding) throws IOException {
        byte[] buf = IO.readBytes(file);
        StringCodec codec = new StringCodec();
        return codec.decode(buf, encoding);
    }

    public static boolean isPreserveLastModified() {
        return preserveLastModified;
    }

    public static void setPreserveLastModified(boolean preserveLastModified) {
        IO.preserveLastModified = preserveLastModified;
    }

    public static String readTextFile(File file) throws IOException {
        return IO.readTextFile(file, System.getProperty("jalbum.file.encoding"));
    }

    public static String readTextFile(String fileName) throws IOException {
        return IO.readTextFile(new File(fileName));
    }

    public static String readTextUrl(URL textUrl) throws IOException {
        int offset;
        URLConnection conn = textUrl.openConnection();
        int length = conn.getContentLength();
        if (length == -1) {
            throw new IOException("Couldn't connect to " + textUrl);
        }
        byte[] bytes = new byte[length];
        InputStream is = conn.getInputStream();
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read from " + textUrl);
        }
        is.close();
        StringCodec codec = new StringCodec();
        return codec.decode(bytes, System.getProperty("jalbum.file.encoding"));
    }

    public static byte[] readBytes(File f) throws IOException {
        int offset;
        byte[] buf = new byte[(int)f.length()];
        FileInputStream in = new FileInputStream(f);
        int numRead = 0;
        for (offset = 0; offset < buf.length && (numRead = in.read(buf, offset, buf.length - offset)) >= 0; offset += numRead) {
        }
        in.close();
        if (offset < buf.length) {
            throw new IOException("Could not completely read file " + f.getName());
        }
        return buf;
    }

    public static void writeBytes(byte[] buf, File f) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        ((OutputStream)out).write(buf);
        ((OutputStream)out).close();
    }

    public static void writeTextFile(String content, File file) throws IOException {
        IO.writeTextFile(content, file, System.getProperty("jalbum.file.encoding"));
    }

    public static void writeTextFile(String content, File file, String encoding) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        writer.write(content);
        writer.close();
    }

    public static boolean writeChangedTextFile(String content, File file, String encoding) throws IOException {
        try {
            byte[] inBytes = IO.readBytes(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);
            writer.write(content);
            writer.close();
            byte[] outBytes = out.toByteArray();
            if (!Arrays.equals(outBytes, inBytes)) {
                IO.writeBytes(outBytes, file);
                return true;
            }
            return false;
        }
        catch (FileNotFoundException ex) {
            IO.writeTextFile(content, file, encoding);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertyFile(File file) throws IOException {
        Properties properties;
        block2: {
            FileInputStream fis = null;
            try {
                Properties props = new Properties();
                fis = new FileInputStream(file);
                props.load(fis);
                properties = props;
                Object var5_4 = null;
                if (fis == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (fis == null) break block3;
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
        }
        return properties;
    }

    public static Map readMapFile(File file) throws IOException {
        return IO.readMap(IO.readBytes(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readMap(byte[] bytes) throws IOException {
        HashMap<String, String> hashMap;
        block4: {
            Pattern backslashPattern = Pattern.compile("\\\\\\\\", 2);
            StringCodec codec = new StringCodec();
            String s = codec.decode(bytes, System.getProperty("jalbum.file.encoding"));
            BufferedReader in = new BufferedReader(new StringReader(s));
            try {
                String line;
                HashMap<String, String> theMap = new HashMap<String, String>();
                while ((line = in.readLine()) != null) {
                    int equalsIndex;
                    if ((line = line.trim()).startsWith("#") || (equalsIndex = line.indexOf(61)) == -1) continue;
                    String key = line.substring(0, equalsIndex).trim();
                    String value = line.substring(equalsIndex + 1).trim();
                    while (IO.continueLine(line)) {
                        value = value.substring(0, value.length() - 1);
                        line = in.readLine();
                        if (line == null) break;
                        value = value + "\n" + line;
                    }
                    value = backslashPattern.matcher(value).replaceAll("\\\\");
                    theMap.put(key, value);
                }
                hashMap = theMap;
                Object var11_11 = null;
                if (in == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var11_12 = null;
                    if (in == null) break block5;
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return hashMap;
    }

    public static void writeMapFile(Map map, File f) throws IOException {
        Replacer backslashEncoder = new Replacer();
        backslashEncoder.add("\\", "\\\\");
        backslashEncoder.add("\n", "\\" + System.getProperty("line.separator"));
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        for (Map.Entry e : map.entrySet()) {
            out.println(e.getKey().toString() + "=" + backslashEncoder.replace(e.getValue().toString()));
        }
        out.close();
        String s = writer.getBuffer().toString();
        StringCodec codec = new StringCodec();
        byte[] bytes = codec.encode(s);
        if (!s.equals(codec.decode(bytes))) {
            bytes = codec.encode(s, "UTF-8");
        }
        IO.writeBytes(bytes, f);
    }

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static void copyFilesUI(JFrame parent, File[] files, File dest) throws OperationAbortedException {
    }

    public static void copyFile(File src, File dest) throws IOException {
        IO.copyFile(src, dest, true);
    }

    public static void copyFile(String name, File dest) throws IOException {
        IO.copyFile(name, dest, true);
    }

    public static void copyFile(String name, File dest, boolean forceCopy) throws IOException {
        IO.copyFile(new File(name), dest, forceCopy);
    }

    public static void copyFile(File src, File dest, boolean forceCopy) throws IOException {
        if (src.isDirectory()) {
            CachedFile[] files;
            if (!dest.isDirectory()) {
                throw new IOException("copyFile: Cannot copy directory onto single file");
            }
            for (CachedFile f : files = CachedFile.listFiles(src)) {
                if (((File)f).isDirectory()) {
                    File newDir = new File(dest, f.getName());
                    newDir.mkdir();
                    IO.copyFile(f, newDir, forceCopy);
                    continue;
                }
                IO.copyFile(f, dest, forceCopy);
            }
        } else {
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            IO.copyPlainFile(src, dest, forceCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void classicCopyFile(File src, File dest) throws IOException {
        if (dest.equals(src)) {
            return;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        try {
            int bytesRead;
            byte[] buffer = new byte[BUFSIZE];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            in.close();
            out.close();
            throw throwable;
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nioCopyFile(File src, File dest) throws IOException {
        FileChannel srcChannel = new FileInputStream(src).getChannel();
        FileChannel dstChannel = new FileOutputStream(dest).getChannel();
        try {
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            srcChannel.close();
            dstChannel.close();
            throw throwable;
        }
        srcChannel.close();
        dstChannel.close();
    }

    public static File downloadFile(URL url, File dest) throws PermissionDeniedException, IOException {
        FileOutputStream fos;
        if (dest.isDirectory()) {
            String path;
            String name = path = url.getPath();
            int slashIndex = path.lastIndexOf(47);
            if (slashIndex != -1) {
                name = path.substring(slashIndex + 1);
            }
            dest = new File(dest, name);
        }
        File tmp = new File(dest.getParentFile(), dest.getName() + ".downloading");
        try {
            fos = new FileOutputStream(tmp);
        }
        catch (IOException ex) {
            throw new PermissionDeniedException("Can't write to " + dest, ex);
        }
        try {
            IO.downloadFile(url, fos);
            fos.close();
            tmp.renameTo(dest);
            return dest;
        }
        catch (IOException ex) {
            tmp.delete();
            throw ex;
        }
    }

    public static void downloadFile(URL url, OutputStream out) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        if (conn.getResponseCode() != 200) {
            throw new IOException("Error accessing " + url + ". Server reported " + conn.getResponseCode() + " " + conn.getResponseMessage());
        }
        BufferedOutputStream bout = new BufferedOutputStream(out);
        byte[] data = new byte[BUFSIZE];
        int x = 0;
        while ((x = in.read(data, 0, data.length)) >= 0) {
            bout.write(data, 0, x);
        }
        bout.flush();
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadZipFile(final URL url, File destFolder) throws IOException {
        block9: {
            PipedInputStream pis = new PipedInputStream();
            final PipedOutputStream pos = new PipedOutputStream(pis);
            ExecutorService es = Executors.newSingleThreadExecutor();
            boolean closed = false;
            try {
                try {
                    Callable c = new Callable(){

                        public Object call() throws Exception {
                            try {
                                IO.downloadFile(url, pos);
                                pos.flush();
                                pos.close();
                                return null;
                            }
                            catch (IOException ex) {
                                pos.close();
                                throw ex;
                            }
                        }
                    };
                    Future f = es.submit(c);
                    ZipInputStream zis = new ZipInputStream(new BufferedInputStream(pis));
                    if (IO.unzip(zis, destFolder, true) > 0) {
                        zis.close();
                        closed = true;
                    }
                    Object dummy = f.get();
                }
                catch (InterruptedException ex) {
                    Object var11_13 = null;
                    es.shutdown();
                    break block9;
                }
                catch (ExecutionException ex) {
                    if (ex.getCause() instanceof IOException) {
                        if (!closed) {
                            throw (IOException)ex.getCause();
                        }
                    } else {
                        throw new RuntimeException(ex.getCause());
                    }
                    Object var11_14 = null;
                    es.shutdown();
                }
                Object var11_12 = null;
                es.shutdown();
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                es.shutdown();
                throw throwable;
            }
        }
    }

    public static String readAll(Reader in) throws IOException {
        int bytesRead;
        char[] buffer = new char[BUFSIZE];
        StringBuilder sb = new StringBuilder();
        while ((bytesRead = in.read(buffer)) != -1) {
            sb.append(buffer, 0, bytesRead);
        }
        in.close();
        return sb.toString();
    }

    public static boolean isSubdirectoryOf(File subdir, File dir) {
        File parent = subdir.getParentFile();
        if (parent == null) {
            return false;
        }
        if (parent.equals(dir)) {
            return true;
        }
        return IO.isSubdirectoryOf(parent, dir);
    }

    public static void copyDirectoryContent(String srcPath, File dest, boolean forceCopy) throws IOException {
        IO.copyDirectoryContent(new File(srcPath), dest, forceCopy);
    }

    public static void copyDirectoryContent(File srcDir, File dest, boolean forceCopy) throws IOException {
        IO.copyDirectoryContent(srcDir, dest, forceCopy, null);
    }

    public static void copyDirectoryContent(File srcDir, final File dest, final boolean forceCopy, FileFilter filter) throws IOException {
        dest.mkdir();
        if (!srcDir.isDirectory()) {
            throw new IOException("Missing directory " + srcDir.getAbsolutePath());
        }
        final File[] files = CachedFile.listFiles(srcDir, filter);
        ArrayList<2> tasks = new ArrayList<2>();
        for (int i = 0; i < files.length; ++i) {
            tasks.add(new IndexedCallable(i){

                public Object call() throws Exception {
                    File to = new File(dest, files[this.index].getName());
                    if (files[this.index].isDirectory()) {
                        IO.copyDirectoryContent(files[this.index], new File(dest, files[this.index].getName()), forceCopy);
                    } else {
                        IO.copyPlainFile(files[this.index], to, forceCopy);
                    }
                    return null;
                }
            });
        }
        try {
            List results = threadPool.invokeAll(tasks);
            for (Future result : results) {
                result.get();
            }
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
    }

    public static String baseName(String fullName) {
        int dotIndex = fullName.lastIndexOf(46);
        return dotIndex != -1 ? fullName.substring(0, dotIndex) : fullName;
    }

    public static File thumbFile(File file) {
        String base;
        File parent = file.getParentFile();
        File thumbFile = new File(parent, (base = IO.baseName(file.getName())) + ".thm");
        if (!thumbFile.exists()) {
            thumbFile = new File(parent, base + ".THM");
        }
        return thumbFile;
    }

    public static boolean isThumbFile(File file) {
        return file.getName().toLowerCase().endsWith(".thm");
    }

    public static String baseName(File file) {
        return IO.baseName(file.getName());
    }

    public static String extensionOf(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1);
    }

    public static String extensionOf(File file) {
        return IO.extensionOf(file.getName());
    }

    public static String relativePath(File file, File rel) {
        return IO.relativePath(file.getAbsolutePath(), rel.getAbsolutePath(), File.separatorChar);
    }

    public static String relativePath(String fileString, String relString) {
        return IO.relativePath(fileString, relString, '/');
    }

    private static String normalize(String s, char separator) {
        if ("".equals(s)) {
            return "";
        }
        s = s.charAt(0) == separator ? s : separator + s;
        s = s.charAt(s.length() - 1) == separator ? s : s + separator;
        return s;
    }

    public static String relativePath(String fileString, String relString, char separator) {
        StringTokenizer tokens;
        int i;
        String originalFileString = fileString;
        fileString = IO.normalize(fileString, separator);
        relString = IO.normalize(relString, separator);
        char[] filePath = fileString.toCharArray();
        char[] relPath = relString.toCharArray();
        StringBuilder result = new StringBuilder();
        for (i = 0; i < filePath.length && i < relPath.length && filePath[i] == relPath[i]; ++i) {
        }
        if (i < relPath.length && i < filePath.length || relPath.length < filePath.length && filePath[i] != separator) {
            while (i > 0 && relPath[i - 1] != separator) {
                --i;
            }
        }
        if (i != 0) {
            tokens = new StringTokenizer(relString.substring(i), "" + separator);
            while (tokens.hasMoreTokens()) {
                tokens.nextToken();
                result.append("../");
            }
        }
        if (i > fileString.length()) {
            i = fileString.length();
        }
        if ((tokens = new StringTokenizer(fileString.substring(i), "" + separator)).hasMoreTokens()) {
            result.append(tokens.nextToken());
        } else if (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
            result.deleteCharAt(result.length() - 1);
        }
        while (tokens.hasMoreTokens()) {
            result.append("/" + tokens.nextToken());
        }
        String res = result.toString();
        res = res.equals("") ? "." : res;
        return res.indexOf(58) != -1 ? originalFileString : res;
    }

    public static String urlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes = s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u007f' || reserved.contains(String.valueOf(chars[i]))) {
                sb.append('%');
                sb.append(hexDigits[(chars[i] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i] & 0xF]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String webSafe(String fileName) {
        String illegal = Config.getConfig().getIllegalCharacters();
        int length = fileName.length();
        char[] chars = null;
        for (int i = 0; i < length; ++i) {
            if (illegal.indexOf(fileName.charAt(i)) == -1) continue;
            if (chars == null) {
                chars = fileName.toCharArray();
            }
            chars[i] = 45;
        }
        return chars != null ? new String(chars) : fileName;
    }

    public static boolean isWebSafe(String fileName) {
        return fileName.equals(IO.webSafe(fileName));
    }

    public static File webSafe(File f) {
        String webSafeName = IO.webSafe(f.getName());
        if (!webSafeName.equals(f.getName())) {
            f = new LinkFile(f.getParentFile(), webSafeName, f instanceof LinkFile ? ((LinkFile)f).getTarget() : f);
        }
        return f;
    }

    public static String combinePaths(String part1, String part2) {
        return IO.combinePaths(part1, part2, '/');
    }

    public static String combinePaths(String part1, String part2, char separator) {
        int start;
        int end;
        if (part1.length() == 0) {
            return part2;
        }
        if (part2.length() == 0) {
            return part1;
        }
        for (end = part1.length(); end > 0 && part1.charAt(end - 1) == separator; --end) {
        }
        if (part1.endsWith("" + separator + separator)) {
            ++end;
        }
        for (start = 0; start < part2.length() && part2.charAt(start) == separator; ++start) {
        }
        return part1.substring(0, end) + separator + part2.substring(start, part2.length());
    }

    public static int sizeof(Object o) {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(ba);
            oos.writeObject(o);
            return ba.toByteArray().length;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static long deepLastModified(File dir) throws IOException {
        long lastModified = dir.lastModified();
        CachedFile[] files = CachedFile.listFiles(dir);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                long lm = ((File)files[i]).lastModified();
                if (((File)files[i]).isDirectory()) {
                    lm = IO.deepLastModified(files[i]);
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
            }
        }
        return lastModified;
    }

    public static long deepLastModifiedFile(File dir) throws IOException {
        long lastModified = 0L;
        CachedFile[] files = CachedFile.listFiles(dir);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                long lm = ((File)files[i]).lastModified();
                if (((File)files[i]).isDirectory()) {
                    lm = IO.deepLastModifiedFile(files[i]);
                    continue;
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
            }
        }
        return lastModified;
    }

    public static void close(Closeable cl) {
        try {
            if (cl != null) {
                cl.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteDir(File dir) {
        CachedFile[] files = CachedFile.listFiles(dir);
        if (files != null) {
            for (CachedFile f : files) {
                if (((File)f).isDirectory()) {
                    IO.deleteDir(f);
                    continue;
                }
                f.delete();
            }
        }
        dir.delete();
    }

    public static boolean recycle(File dir) {
        return IO.recycle(dir, false);
    }

    public static boolean recycle(File dir, boolean recycleOnly) {
        try {
            if (Platform.isMac()) {
                return !FileManager.moveToTrash((File)dir);
            }
            FileUtil fu = new FileUtil();
            return fu.recycle(dir);
        }
        catch (Throwable t) {
            if (!recycleOnly) {
                IO.deleteDir(dir);
            }
            return false;
        }
    }

    public static File resolvePath(File f, String path) {
        String[] comps;
        if (path == null) {
            path = "";
        }
        for (String comp : comps = path.split("(/|\\\\)")) {
            if (".".equals(comp)) continue;
            f = "..".equals(comp) ? f.getParentFile() : new File(f, comp);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int unzip(File zipFile, File destDir) throws ZipException, IOException {
        int n;
        FileInputStream fis = new FileInputStream(zipFile);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        try {
            n = IO.unzip(zis, destDir, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            zis.close();
            throw throwable;
        }
        zis.close();
        return n;
    }

    public static int unzip(ZipInputStream zis, File destDir) throws ZipException, IOException {
        return IO.unzip(zis, destDir, false);
    }

    public static int unzip(ZipInputStream zis, File destDir, boolean downloading) throws ZipException, IOException {
        ZipEntry entry;
        int entries = 0;
        BufferedOutputStream dest = null;
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            ++entries;
            byte[] data = new byte[BUFSIZE];
            File destFile = new File(destDir, entry.getName());
            if (entry.getName().endsWith("/")) {
                destFile.mkdirs();
                continue;
            }
            File tmpFile = destFile;
            if (downloading) {
                tmpFile = new File(destFile.getParentFile(), destFile.getName() + ".downloading");
            }
            FileOutputStream fos = new FileOutputStream(tmpFile);
            dest = new BufferedOutputStream(fos, BUFSIZE);
            while ((count = zis.read(data, 0, BUFSIZE)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            zis.closeEntry();
            if (!tmpFile.equals(destFile)) {
                tmpFile.renameTo(destFile);
            }
            destFile.setLastModified(entry.getTime());
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyPlainFile(File src, File dest, boolean forceCopy) throws IOException {
        block9: {
            if (src.equals(dest)) {
                return;
            }
            if (src.getName().equalsIgnoreCase("Thumbs.db")) {
                return;
            }
            long srcLastModified = 0L;
            long destLastModified = 0L;
            if (!forceCopy && (srcLastModified = src.lastModified()) <= (destLastModified = dest.lastModified())) {
                return;
            }
            if (preserveLastModified && srcLastModified == 0L) {
                srcLastModified = src.lastModified();
            }
            try {
                if (src.length() > 0x1400000L) {
                    IO.classicCopyFile(src, dest);
                } else {
                    IO.nioCopyFile(src, dest);
                }
                Object var8_5 = null;
                if (srcLastModified <= 0L) break block9;
                dest.setLastModified(srcLastModified);
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (srcLastModified > 0L) {
                    dest.setLastModified(srcLastModified);
                }
                throw throwable;
            }
            {
            }
        }
    }

    private static abstract class IndexedCallable
    implements Callable {
        protected int index;

        public IndexedCallable(int index) {
            this.index = index;
        }
    }
}

