/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JSmartDialog;
import se.datadosen.jalbum.Msg;

public abstract class SlowOperation
extends Thread {
    private JLabel label;
    private Icon icon;
    private Icon altIcon;
    private String title;
    private boolean alive = true;
    private boolean done = false;
    private boolean aborted = false;
    private Object result;
    private Throwable throwable;
    protected JSmartDialog dialog;
    protected JProgressSpinner spinner;
    protected Action abortAction = new AbstractAction(Msg.get("abort")){

        public void actionPerformed(ActionEvent e) {
            SlowOperation.this.aborted = true;
            SlowOperation.this.abort();
        }
    };

    public SlowOperation() {
        this.setDaemon(true);
    }

    public boolean launch(Dialog parent, JLabel messageLabel, String title) throws Throwable {
        return this.launch(parent, messageLabel, null, title);
    }

    public boolean launch(Dialog parent, JLabel messageLabel, Icon altIcon, String title) throws Throwable {
        this.label = messageLabel;
        this.altIcon = altIcon;
        this.title = title;
        this.dialog = new JSlowOperationDialog(parent);
        this.start();
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.throwable != null && !this.aborted) {
            throw this.throwable;
        }
        return !this.aborted;
    }

    public boolean launch(Frame parent, String message, String title) throws Throwable {
        return this.launch(parent, new JLabel(message), null, title);
    }

    public boolean launch(Frame parent, JLabel messageLabel, Icon altIcon, String title) throws Throwable {
        this.label = messageLabel;
        this.altIcon = altIcon;
        this.title = title;
        this.dialog = new JSlowOperationDialog(parent);
        this.start();
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.throwable != null && !this.aborted) {
            throw this.throwable;
        }
        return !this.aborted;
    }

    public JLabel getMessageLabel() {
        return this.label;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public boolean isDone() {
        return this.done;
    }

    public void run() {
        try {
            this.operation();
            this.done = true;
        }
        catch (Throwable t) {
            this.throwable = t;
        }
        this.alive = false;
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public abstract void operation() throws Throwable;

    public abstract void abort();

    private void startBlinker() {
        Thread blinkerThread = new Thread("Blinker thread"){

            public void run() {
                try {
                    while (SlowOperation.this.alive) {
                        2.sleep(500L);
                        SlowOperation.this.label.setIcon(SlowOperation.this.altIcon);
                        2.sleep(500L);
                        SlowOperation.this.label.setIcon(SlowOperation.this.icon);
                    }
                    if (SlowOperation.this.spinner != null) {
                        SlowOperation.this.spinner.setSpinning(false);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        blinkerThread.setDaemon(true);
        blinkerThread.start();
    }

    class JSlowOperationDialog
    extends JSmartDialog {
        public JSlowOperationDialog(Dialog d) {
            super(d, true);
            this.setTitle(SlowOperation.this.title);
            JComponent c = (JComponent)this.getContentPane();
            c.setLayout(new BorderLayout());
            c.setBorder(new EmptyBorder(20, 20, 14, 20));
            c.add((Component)SlowOperation.this.label, "Center");
            this.registerActions(SlowOperation.this.abortAction);
            SlowOperation.this.icon = SlowOperation.this.label.getIcon();
            if (SlowOperation.this.icon != null) {
                if (SlowOperation.this.altIcon == null) {
                    BufferedImage bi = new BufferedImage(SlowOperation.this.icon.getIconWidth(), SlowOperation.this.icon.getIconHeight(), 6);
                    SlowOperation.this.altIcon = new ImageIcon(bi);
                }
                SlowOperation.this.startBlinker();
            } else {
                SlowOperation.this.spinner = new JProgressSpinner(28, true);
                SlowOperation.this.spinner.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
                c.add((Component)SlowOperation.this.spinner, "South");
            }
        }

        public JSlowOperationDialog(Frame f) {
            super(f, true);
            this.setTitle(SlowOperation.this.title);
            JComponent c = (JComponent)this.getContentPane();
            c.setLayout(new BorderLayout());
            c.setBorder(new EmptyBorder(20, 20, 14, 20));
            c.add((Component)SlowOperation.this.label, "Center");
            this.registerActions(SlowOperation.this.abortAction);
            SlowOperation.this.icon = SlowOperation.this.label.getIcon();
            if (SlowOperation.this.icon != null) {
                if (SlowOperation.this.altIcon == null) {
                    BufferedImage bi = new BufferedImage(SlowOperation.this.icon.getIconWidth(), SlowOperation.this.icon.getIconHeight(), 6);
                    SlowOperation.this.altIcon = new ImageIcon(bi);
                }
                SlowOperation.this.startBlinker();
            } else {
                SlowOperation.this.spinner = new JProgressSpinner(28, true);
                SlowOperation.this.spinner.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
                c.add((Component)SlowOperation.this.spinner, "South");
            }
        }
    }
}

