/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.swingworker.SwingWorker;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NoValidSkinException;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;

public class SkinManager {
    public static final String JALBUM_SKIN_TYPE = ".jaskin";
    private int initiallyIgnoredCount;
    private Set<String> ignoreDirs = new HashSet<String>(){
        {
            this.add("__MACOSX");
            this.add(".svn");
            SkinManager.this.initiallyIgnoredCount = this.size();
        }
    };
    private ProgressMonitor progressMonitor;
    private JAlbumFrame window = JAlbumContext.getInstance().getFrame();

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void addIgnoreDir(String dir) {
        this.ignoreDirs.add(dir);
    }

    private boolean isIgnored(String path) {
        for (String ignoreDir : this.ignoreDirs) {
            if (!path.contains(ignoreDir)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String doInstallSkin(String fileName, ZipInputStream zin, int entryCount, File skinsDir) throws ZipException, IOException {
        String string;
        boolean isPatch = fileName.endsWith(".patch.jaskin");
        try {
            ZipEntry e;
            if (this.progressMonitor != null) {
                this.progressMonitor.setMinimum(1);
                this.progressMonitor.setMaximum(entryCount);
            }
            File destDir = skinsDir;
            String currentPath = null;
            String skinName = null;
            int counter = 1;
            HashSet<File> visitedRoots = new HashSet<File>();
            while ((e = zin.getNextEntry()) != null) {
                String p = this.pathOf(e);
                if (!this.isIgnored(p)) {
                    if (!p.equals(currentPath)) {
                        currentPath = p;
                        String n = this.rootOf(e);
                        if (skinName == null) {
                            skinName = n;
                        }
                        destDir = new File(skinsDir, currentPath);
                        File skinDir = new File(skinsDir, n);
                        if (!isPatch && !visitedRoots.contains(skinDir)) {
                            if (skinDir.exists()) {
                                AlbumBean engine = JAlbumContext.getInstance().getEngine();
                                if (engine != null && engine.getSkin().equals(n)) {
                                    engine.unloadCurrentSkin();
                                }
                                IO.recycle(skinDir);
                            }
                            visitedRoots.add(skinDir);
                        }
                        destDir.mkdirs();
                    }
                    File destFile = new File(destDir, this.nameOf(e));
                    if (e.isDirectory()) {
                        if (!this.isIgnored(this.nameOf(e))) {
                            destFile.mkdir();
                        }
                    } else {
                        Object var18_17;
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                        try {
                            byte[] buffer;
                            int bytesRead;
                            while ((bytesRead = zin.read(buffer = new byte[65536])) != -1) {
                                out.write(buffer, 0, bytesRead);
                            }
                            var18_17 = null;
                        }
                        catch (Throwable throwable) {
                            var18_17 = null;
                            zin.closeEntry();
                            out.close();
                            throw throwable;
                        }
                        zin.closeEntry();
                        out.close();
                        {
                        }
                    }
                    if (e.getTime() != -1L) {
                        destFile.setLastModified(e.getTime());
                    }
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.setProgress(counter);
                    if (this.progressMonitor.isCanceled()) break;
                }
                ++counter;
            }
            string = skinName;
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            zin.close();
            throw throwable;
        }
        zin.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEntryCount(ZipInputStream zin) throws IOException {
        int n;
        int counter = 0;
        try {
            while (zin.getNextEntry() != null) {
                ++counter;
            }
            n = counter;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            zin.close();
            throw throwable;
        }
        zin.close();
        return n;
    }

    public void installSkin(final String name, final URL skinUrl, final Runnable afterInstallAction) {
        new SwingWorker<byte[], Object>(){

            void grabFile(URL url, OutputStream out) throws IOException {
                BufferedInputStream in = new BufferedInputStream(url.openStream());
                BufferedOutputStream bout = new BufferedOutputStream(out, 65535);
                byte[] data = new byte[65535];
                int x = 0;
                while ((x = in.read(data, 0, 65535)) >= 0) {
                    bout.write(data, 0, x);
                }
                bout.close();
                in.close();
            }

            protected byte[] doInBackground() throws Exception {
                ((SkinManager)SkinManager.this).window.progressSpinner.workStarted();
                ((SkinManager)SkinManager.this).window.statusBar.pushText("Downloading skin");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.grabFile(skinUrl, baos);
                return baos.toByteArray();
            }

            protected void done() {
                ((SkinManager)SkinManager.this).window.progressSpinner.workDone();
                ((SkinManager)SkinManager.this).window.statusBar.popText("Downloading skin");
                try {
                    SkinManager.this.installSkin(name, (byte[])this.get(), Config.getConfig().chainedSkinsDir.getDirectory(), afterInstallAction);
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    if (ex.getCause() instanceof FileNotFoundException) {
                        JOptionPane.showMessageDialog(SkinManager.this.window, Msg.get("ui.skinNotFoundError", name), Msg.get("sm.skinManagerTitle"), 0);
                    }
                    Debug.showErrorDialog(SkinManager.this.window, ex.getCause());
                }
            }
        }.execute();
    }

    public void installSkin(File skinFile) {
        Config config = Config.getConfig();
        this.installSkin(skinFile, config.chainedSkinsDir.getDirectory());
    }

    public void installSkin(File skinFile, File skinsDir) {
        try {
            this.installSkin(skinFile.getName(), IO.readBytes(skinFile), skinsDir, null);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.get("sm.skinManagerTitle"), 0);
        }
    }

    public void installSkin(final String fileName, final byte[] zipBytes, final File skinsDir, final Runnable afterInstallAction) {
        try {
            skinsDir.mkdirs();
            final Set skins = this.listSkins(new ZipInputStream(new ByteArrayInputStream(zipBytes)));
            Object[] a = skins.toArray();
            JCheckBox[] selections = new JCheckBox[a.length];
            ControlPanel skinPanel = new ControlPanel();
            ((RiverLayout)skinPanel.getLayout()).setHgap(0);
            skinPanel.add(new JLabel(Msg.get("sm.skinInstallerInfo")));
            for (int i = 0; i < a.length; ++i) {
                String skinName = a[i].toString();
                selections[i] = new JCheckBox(skinName, true);
                skinPanel.add("br", selections[i]);
            }
            int answer = JOptionPane.showConfirmDialog(null, skinPanel, Msg.get("sm.skinManagerTitle"), 2, 1);
            if (answer != 0) {
                return;
            }
            for (int i = 0; i < selections.length; ++i) {
                if (selections[i].isSelected()) continue;
                this.addIgnoreDir(selections[i].getText());
            }
            UIManager.put("ProgressMonitor.progressText", Msg.get("sm.skinManagerTitle"));
            final ProgressMonitor pm = new ProgressMonitor(null, Msg.get("sm.installingSkinInfo") + "...", null, 1, 1);
            this.setProgressMonitor(pm);
            Thread installThread = new Thread("Skin install thread"){

                public void run() {
                    try {
                        String skinName = SkinManager.this.doInstallSkin(fileName, new ZipInputStream(new ByteArrayInputStream(zipBytes)), SkinManager.this.getEntryCount(new ZipInputStream(new ByteArrayInputStream(zipBytes))), skinsDir);
                        if (!pm.isCanceled() && SkinManager.this.ignoreDirs.size() - SkinManager.this.initiallyIgnoredCount < skins.size()) {
                            JOptionPane.showMessageDialog(null, Msg.get("sm.skinInstalledInfo"), Msg.get("sm.skinManagerTitle"), 1);
                            if (SkinManager.this.window != null && skinName != null) {
                                if (((SkinManager)SkinManager.this).window.mainSettingsPanel.getSelectedSkin().equals(skinName)) {
                                    SkinManager.this.window.reloadSkin();
                                } else {
                                    ((SkinManager)SkinManager.this).window.mainSettingsPanel.scanSkins();
                                    ((SkinManager)SkinManager.this).window.mainSettingsPanel.setSelectedSkin(skinName);
                                }
                            }
                            if (afterInstallAction != null) {
                                SwingUtilities.invokeLater(afterInstallAction);
                            }
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.get("sm.skinManagerTitle"), 0);
                    }
                }
            };
            installThread.setDaemon(false);
            installThread.start();
        }
        catch (NoValidSkinException ex) {
            JOptionPane.showMessageDialog(null, Msg.get("sm.notAValidSkinFileError"), Msg.get("sm.skinManagerTitle"), 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.get("sm.skinManagerTitle"), 0);
        }
    }

    private String pathOf(ZipEntry e) {
        int i;
        String s = e.getName();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.lastIndexOf(47)) == -1) {
            return "";
        }
        return s.substring(0, i);
    }

    private String nameOf(ZipEntry e) {
        int i;
        String s = e.getName();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.lastIndexOf(47)) == -1) {
            return s;
        }
        return s.substring(i + 1);
    }

    public Set listSkins(ZipInputStream zin) throws NoValidSkinException, ZipException, IOException {
        ZipEntry e;
        TreeSet<String> names = new TreeSet<String>();
        while ((e = zin.getNextEntry()) != null) {
            String rootName = this.rootOf(e);
            if (this.ignoreDirs.contains(rootName)) continue;
            names.add(rootName);
        }
        zin.close();
        if (names.isEmpty()) {
            throw new NoValidSkinException();
        }
        return names;
    }

    private String rootOf(ZipEntry e) throws NoValidSkinException {
        int i;
        String s = e.getName();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.indexOf(47)) == -1) {
            if (e.isDirectory()) {
                return s;
            }
            throw new NoValidSkinException();
        }
        return s.substring(0, i);
    }
}

