/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import net.sbbi.upnp.messages.UPNPResponseException;
import org.mortbay.http.NCSARequestLog;
import org.mortbay.http.RequestLog;
import se.datadosen.jalbum.event.StatusListener;
import se.datadosen.net.JettyHttpServer;
import se.datadosen.net.NetUtil;
import se.datadosen.net.PortMapping;
import se.datadosen.net.PortMappingListener;
import se.datadosen.net.Share;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.tags.XMLDocument;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.IO;

public class ShareBean
extends JettyHttpServer
implements PortMappingListener {
    public static final String NO_LOGGING = "no";
    public static final String CONSOLE_LOGGING = "console";
    public static final String FILE_LOGGING = "file";
    static final File settingsFile = new File(System.getProperty("user.home"), ".jalbum-sharing.xml");
    private PortMapping portMapping = null;
    private transient Vector statusListeners;
    private String externalAddress;
    private String hostName = "";
    private boolean autoStart;
    private boolean doPortMapping = true;
    private String logType = "no";
    private String logFileName = "albumsharing.log";
    private String logDateFormat;
    private NCSARequestLog logger = new NCSARequestLog();
    boolean loopbackAccessOk = false;
    boolean accessViaProxyOk = false;

    public ShareBean() {
        this.setPort(NetUtil.getFreeServerPort());
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public String getLogDateFormat() {
        return this.logger.getLogDateFormat();
    }

    public void setLogDateFormat(String logDateFormat) {
        this.logger.setLogDateFormat(logDateFormat);
        this.logDateFormat = logDateFormat;
    }

    public void setLogger() {
        if (this.logType.equals(NO_LOGGING)) {
            this.server.setRequestLog(null);
            return;
        }
        if (this.logDateFormat != null && this.logDateFormat.length() > 0) {
            this.logger.setLogDateFormat(this.logDateFormat);
        }
        if (this.logType.equals(CONSOLE_LOGGING)) {
            this.logger.setFilename(null);
        } else {
            this.logger.setFilename(this.logFileName);
        }
        this.server.setRequestLog((RequestLog)this.logger);
    }

    public void setRequestLog(RequestLog logger) {
        this.server.setRequestLog(logger);
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isDoPortMapping() {
        return this.doPortMapping;
    }

    public void setDoPortMapping(boolean doPortMapping) {
        this.doPortMapping = doPortMapping;
    }

    public void start() throws Exception {
        this.setLogger();
        super.start();
        this.fireStatusChanged("Web server started");
    }

    public void stop() throws InterruptedException {
        super.stop();
        this.fireStatusChanged("Web server stopped");
    }

    public void ensurePortMapping() throws UPNPResponseException, IOException {
        if (this.portMapping != null) {
            if (this.portMapping.getPort() != this.getPort()) {
                this.portMapping.setMapping(this.getPort());
            }
        } else if (InetAddress.getLocalHost().isSiteLocalAddress()) {
            this.portMapping = new PortMapping("JAlbum album sharing", this.getPort(), this);
        }
    }

    private String getExternalAddressFromWeb() throws IOException {
        URL url = new URL("http://checkip.dyndns.org");
        Object o = url.getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)o));
        String s = reader.readLine();
        return s.substring(s.indexOf(":") + 1, s.indexOf("</body>")).trim();
    }

    public String getExternalAddress() throws UPNPResponseException, IOException {
        if (this.externalAddress == null) {
            this.externalAddress = this.portMapping != null ? this.portMapping.getExternalAddress() : (InetAddress.getLocalHost().isSiteLocalAddress() ? this.getExternalAddressFromWeb() : InetAddress.getLocalHost().getHostAddress());
        }
        return this.externalAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean albumAccessTest() {
        try {
            this.accessViaProxyOk = true;
            String url1 = "http://" + this.getExternalAddress() + ":" + this.getPort() + "/PingServlet";
            this.loopbackAccessOk = this.albumAccessTest(new URL(url1), 700);
            if (!this.loopbackAccessOk) {
                String url2 = "http://jalbum.net/servlet/ProxyServlet?url=http://" + this.getExternalAddress() + ":" + this.getPort() + "/PingServlet";
                this.accessViaProxyOk = this.albumAccessTest(new URL(url2), 2000);
                return this.accessViaProxyOk;
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean albumAccessTest(URL url, int timeout) {
        try {
            Socket sock = new Socket();
            int port = url.getPort();
            if (port == -1) {
                port = 80;
            }
            sock.connect(new InetSocketAddress(url.getHost(), port), timeout);
            sock.close();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            Object o = conn.getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)o));
            String s = reader.readLine();
            return s.equals("JAlbum album sharing");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void saveSettings() throws IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(settingsFile)));
        Element sharing = new Element("sharing");
        sharing.setAttribute("port", this.getPort());
        sharing.setAttribute("hostName", this.hostName);
        sharing.setAttribute("autoStart", this.autoStart);
        sharing.setAttribute("doPortMapping", this.doPortMapping);
        sharing.setAttribute("logType", this.logType);
        sharing.setAttribute("logDateFormat", this.logDateFormat);
        sharing.setAttribute("logFileName", this.logFileName);
        for (Share share : this.getShares()) {
            Element el = new Element("share");
            el.setAttribute("uri", share.uri);
            el.setAttribute("localPath", share.localPath);
            el.setAttribute("active", share.active);
            el.setAttribute("passwordProtect", share.passwordProtect);
            el.setAttribute("userName", share.userName);
            el.setAttribute("password", share.password);
            sharing.addContentElement(el);
        }
        XMLDocument doc = new XMLDocument(sharing);
        out.print(doc);
        out.close();
    }

    public void loadSettings() throws IOException, ElementException {
        LinkedList<Share> shares = new LinkedList<Share>();
        if (!settingsFile.exists()) {
            return;
        }
        String doc = IO.readTextFile(settingsFile);
        Element sharingElement = Elements.getElementByName("sharing", doc, false);
        if (sharingElement != null) {
            Element el;
            Map attrs = sharingElement.getAttributes();
            if (attrs != null) {
                BeanBinder.setProperties((Object)this, attrs);
            }
            String rest = sharingElement.getContent();
            while ((el = Elements.getElementByName("share", rest, false)) != null) {
                Share share = new Share(el.getAttribute("localPath"), el.getAttribute("uri"), el.getBooleanAttribute("active"));
                share.passwordProtect = el.getBooleanAttribute("passwordProtect");
                share.userName = el.getAttribute("userName", "");
                share.password = el.getAttribute("password", "");
                shares.add(share);
                rest = el.getPostElement();
            }
            this.setShares(shares);
        }
    }

    public synchronized void addStatusListener(StatusListener l) {
        Vector v;
        Vector vector = v = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.statusListeners = v;
        }
    }

    public synchronized void removeStatusListener(StatusListener l) {
        if (this.statusListeners != null && this.statusListeners.contains(l)) {
            Vector v = (Vector)this.statusListeners.clone();
            v.removeElement(l);
            this.statusListeners = v;
        }
    }

    protected void fireStatusChanged(String msg) {
        if (this.statusListeners != null) {
            Vector listeners = this.statusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((StatusListener)listeners.elementAt(i)).statusChanged(msg);
            }
        }
    }

    public void statusChanged(String msg) {
        this.fireStatusChanged(msg);
    }
}

