/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingworker.SwingWorker;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.io.CachedFile;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumManager;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.UploadBean;

public class JAlbumInfo
extends JDialog {
    static DateFormat dateFormatter = SimpleDateFormat.getDateTimeInstance();
    File albumDir;
    JCollapsiblePanel generalPanel = new JPackingCollapsiblePanel(Msg.get("ui.mainPanel"), (LayoutManager)new MigLayout("insets 8, wrap 2", "[label][left]"));
    JCollapsiblePanel imagesPanel = new JPackingCollapsiblePanel(Msg.get("ui.imagesLabel"), (LayoutManager)new MigLayout("insets 8, wrap 2", "[label][left]"));
    JCollapsiblePanel localPanel = new JPackingCollapsiblePanel(Msg.get("ui.localAlbum"), (LayoutManager)new MigLayout("insets 8, wrap 2", "[label][left]"));
    JCollapsiblePanel publishedPanel = new JPackingCollapsiblePanel(Msg.get("ui.publishedAlbum"), (LayoutManager)new MigLayout("insets 8, wrap 2", "[label][left]"));
    JLabel objectsSize = new JLabel();
    JLabel localAlbumSize = new JLabel();
    JLabel publishedAlbumSize = new JLabel();
    JLinkLabel projectLocation = new JLinkLabel();
    JLinkLabel imageLocation = new JLinkLabel();
    JLinkLabel localAlbumLocation = new JLinkLabel();
    JLinkLabel publishedLocation = new JLinkLabel();
    ObjectsCalculator objectsCalculator;
    LocalSpaceCalculator localSpaceCalculator;
    PathFinderWorker pathFinderWorker;
    RemoteSpaceCalculator remoteSpaceCalculator;
    JProgressSpinner objectsSpinner = new JProgressSpinner(16, true);
    JProgressSpinner localAlbumSpinner = new JProgressSpinner(16, true);
    JProgressSpinner remoteSpaceSpinner = new JProgressSpinner(16);
    JProgressSpinner publishedLocationSpinner = new JProgressSpinner(16);
    JButton deleteLocalAlbumButton;
    JButton deletePublishedAlbumButton;
    JAlbumContext context;
    AlbumBean engine;
    AlbumProject project;
    AccountProfile account;
    UploadBean uploadBean;
    UploadBean.PathFinder pathFinder;
    private DecimalFormat twoDec = new DecimalFormat("0.##");
    private JLabel icon = new JLabel();
    private Action deleteLocalAlbumAction;
    private Action deletePublishedAlbumAction;

    public JAlbumInfo(JAlbumContext context, AlbumProject project) {
        super((Frame)context.getFrame(), Msg.get("ui.albumInfoTitle", project.getLongName()));
        this.context = context;
        this.engine = context.getEngine();
        this.project = project;
        try {
            AlbumObject rep = project.getRootFolder().getRepresentingAlbumObject(true);
            if (rep != null) {
                this.icon.setIcon(rep.getRepresentingIcon(new Dimension(32, 32), true, false));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.init();
    }

    private void onClose() {
        if (this.objectsCalculator != null) {
            this.objectsCalculator.cancel(true);
        }
        if (this.localSpaceCalculator != null) {
            this.localSpaceCalculator.cancel(true);
        }
        if (this.remoteSpaceCalculator != null) {
            this.remoteSpaceCalculator.cancel(true);
        }
    }

    private void init() {
        final PropertyChangeListener reworkWhenDone = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(SwingWorker.StateValue.DONE)) {
                    JAlbumInfo.this.startWorkers();
                }
            }
        };
        final JAlbumManager manager = this.context.getFrame().albumExplorer.albumManager;
        this.deleteLocalAlbumAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                manager.deleteLocalAlbumAction.actionPerformed(e, reworkWhenDone);
            }
        };
        this.deletePublishedAlbumAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                manager.deletePublishedAlbumAction.actionPerformed(e, reworkWhenDone);
            }
        };
        final File projectDir = this.project.getProjectFile().getParentFile();
        final File imageDir = this.project.getRootFolder().getFile();
        this.projectLocation.setText(this.project.getProjectFile().getAbsolutePath());
        this.projectLocation.setURL(this.project.getProjectFile().getAbsolutePath());
        this.projectLocation.setToolTipText(Msg.get("edit.showInFilesystem"));
        this.projectLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openLocal(projectDir);
                }
                catch (IOException ex) {
                    System.err.println(ex.toString());
                }
            }
        });
        this.imageLocation.setText(imageDir.getAbsolutePath());
        this.imageLocation.setURL(imageDir.getAbsolutePath());
        this.imageLocation.setToolTipText(Msg.get("edit.showInFilesystem"));
        this.imageLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openLocal(imageDir);
                }
                catch (IOException ex) {
                    System.err.println(ex.toString());
                }
            }
        });
        this.albumDir = this.engine.getInterpretedOutputDirectory();
        this.localAlbumLocation.setText(this.albumDir.getAbsolutePath());
        final File indexFile = new File(this.albumDir, this.engine.getIndexPageName() + this.engine.getPageExtension());
        this.localAlbumLocation.setURL(indexFile.getAbsolutePath());
        this.localAlbumLocation.setToolTipText(Msg.get("ui.openInBrowser"));
        this.localAlbumLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openLocal(indexFile);
                }
                catch (IOException ex) {
                    System.err.println(ex.toString());
                }
            }
        });
        this.deleteLocalAlbumButton = new JPlainButton(this.deleteLocalAlbumAction, false);
        this.deleteLocalAlbumButton.setIcon(Icons.getIcon("small.delete"));
        this.deleteLocalAlbumButton.setToolTipText((String)manager.deleteLocalAlbumAction.getValue("Name"));
        this.deletePublishedAlbumButton = new JPlainButton(this.deletePublishedAlbumAction, false);
        this.deletePublishedAlbumButton.setIcon(Icons.getIcon("small.delete"));
        this.deletePublishedAlbumButton.setToolTipText((String)manager.deletePublishedAlbumAction.getValue("Name"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JAlbumInfo.this.onClose();
            }
        });
        this.setDefaultCloseOperation(2);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        JAlbumInfo.this.setVisible(false);
                        JAlbumInfo.this.onClose();
                    }
                }
            }
        });
        this.setLayout((LayoutManager)new MigLayout("insets 0, fillx, wrap 1"));
        this.generalPanel.add(new JLabel(Msg.get("ui.location") + ":"));
        this.generalPanel.add(this.projectLocation);
        this.generalPanel.add(new JLabel(Msg.get("ui.changed") + ":"));
        this.generalPanel.add(new JLabel(this.lastModified(this.project.getProjectFile())));
        this.imagesPanel.add(new JLabel(Msg.get("ui.size") + ":"));
        this.imagesPanel.add((Component)this.objectsSize, "split 2");
        this.imagesPanel.add(this.objectsSpinner);
        this.imagesPanel.add(new JLabel(Msg.get("ui.location") + ":"));
        this.imagesPanel.add(this.imageLocation);
        this.imagesPanel.add(new JLabel(Msg.get("ui.changed") + ":"));
        File albumFilesFile = new File(imageDir, "albumfiles.txt");
        this.imagesPanel.add(new JLabel(this.lastModified(albumFilesFile)));
        this.localPanel.add(new JLabel(Msg.get("ui.size") + ":"));
        this.localPanel.add((Component)this.localAlbumSize, "split 2");
        this.localPanel.add(this.localAlbumSpinner);
        this.localPanel.add(new JLabel(Msg.get("ui.location") + ":"));
        this.localPanel.add((Component)this.localAlbumLocation, "split 2");
        this.localPanel.add(this.deleteLocalAlbumButton);
        this.localPanel.add(new JLabel(Msg.get("ui.changed") + ":"));
        this.localPanel.add(new JLabel(this.lastModified(this.albumDir)));
        this.publishedPanel.add(new JLabel(Msg.get("ui.size") + ":"));
        this.publishedPanel.add((Component)this.publishedAlbumSize, "split 2");
        this.publishedPanel.add(this.remoteSpaceSpinner);
        this.publishedPanel.add(new JLabel(Msg.get("ui.location") + ":"));
        this.publishedPanel.add((Component)this.publishedLocation, "split 3");
        this.publishedPanel.add(this.deletePublishedAlbumButton);
        this.publishedPanel.add(this.publishedLocationSpinner);
        this.add((Component)this.generalPanel, "growx");
        this.add((Component)this.imagesPanel, "growx");
        this.add((Component)this.localPanel, "growx");
        this.add((Component)this.publishedPanel, "growx");
        this.imagesPanel.setExpanded(true);
        this.localPanel.setExpanded(true);
        this.publishedPanel.setExpanded(true);
        String accountProfileName = (String)this.project.getRootFolder().getProperties().get("accountProfileName");
        if (accountProfileName == null) {
            accountProfileName = this.engine.getAccountProfileName();
        }
        this.account = AccountManager.getInstance().findAccountByName(accountProfileName);
        if (this.account == null) {
            this.account = AccountManager.getInstance().getFirstMyjalbumAccount();
        }
        if (this.account == null) {
            this.publishedLocation.setText(Msg.get("ui.notPublished"));
            this.publishedLocationSpinner.setVisible(false);
        }
        this.uploadBean = new UploadBean();
        this.pack();
        this.startWorkers();
    }

    private void startWorkers() {
        this.deleteLocalAlbumButton.setVisible(this.albumDir.exists());
        this.deletePublishedAlbumButton.setVisible(false);
        this.remoteSpaceSpinner.setVisible(false);
        if (this.account != null) {
            this.pathFinderWorker = new PathFinderWorker();
            this.remoteSpaceCalculator = new RemoteSpaceCalculator();
            this.publishedLocationSpinner.setSpinning(true);
            this.pathFinderWorker.execute();
        }
        this.objectsCalculator = new ObjectsCalculator(this.project.getRootFolder());
        this.localSpaceCalculator = new LocalSpaceCalculator(this.albumDir);
        this.objectsCalculator.execute();
        this.localAlbumSpinner.setSpinning(true);
        this.localSpaceCalculator.execute();
    }

    protected String formatAsMB(long bytes) {
        return this.twoDec.format((double)bytes / 1024.0 / 1024.0);
    }

    protected String lastModified(File f) {
        if (f.exists()) {
            return dateFormatter.format(new Date(f.lastModified()));
        }
        return "";
    }

    class JPackingCollapsiblePanel
    extends JCollapsiblePanel
    implements PropertyChangeListener {
        public JPackingCollapsiblePanel(String title, LayoutManager layout) {
            super(title, layout);
            this.addPropertyChangeListener("expanded", this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JAlbumInfo.this.pack();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ObjectsCalculator
    extends SwingWorker<Long, Object> {
        private AlbumObject root;
        private long size = 0L;
        private long nObjects = 0L;

        public ObjectsCalculator(AlbumObject root) {
            this.root = root;
        }

        private void processFolder(AlbumObject folder) throws InterruptedException {
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
            for (AlbumObject ao : folder.getChildren()) {
                if (!ao.isIncluded()) continue;
                ++this.nObjects;
                if (ao.isFolder()) {
                    this.processFolder(ao);
                    continue;
                }
                this.size += ao.getFile().length();
            }
        }

        protected Long doInBackground() throws Exception {
            this.processFolder(this.root);
            return this.size;
        }

        protected void done() {
            JAlbumInfo.this.objectsSpinner.setVisible(false);
            try {
                if (this.isCancelled()) {
                    return;
                }
                JAlbumInfo.this.objectsSize.setText(Msg.get("ui.sizeObjects", JAlbumInfo.this.formatAsMB((Long)this.get()), this.nObjects));
                JAlbumInfo.this.pack();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LocalSpaceCalculator
    extends SwingWorker<Long, Object> {
        private File albumRootDir;
        private long size = 0L;
        private long nFiles = 0L;
        private long nFolders = 0L;

        public LocalSpaceCalculator(File albumRootDir) {
            this.albumRootDir = albumRootDir;
        }

        private void processDir(File dir) throws InterruptedException {
            CachedFile[] files;
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
            for (CachedFile f : files = CachedFile.listFiles(dir)) {
                if (((File)f).isDirectory()) {
                    ++this.nFolders;
                    this.processDir(f);
                    continue;
                }
                ++this.nFiles;
                this.size += ((File)f).length();
            }
        }

        protected Long doInBackground() throws Exception {
            if (this.albumRootDir.exists()) {
                this.processDir(this.albumRootDir);
            }
            return this.size;
        }

        protected void done() {
            JAlbumInfo.this.localAlbumSpinner.setVisible(false);
            try {
                if (this.isCancelled()) {
                    return;
                }
                JAlbumInfo.this.localAlbumSize.setText(Msg.get("ui.sizeFilesFolders", JAlbumInfo.this.formatAsMB((Long)this.get()), this.nFiles, this.nFolders));
                if (this.albumRootDir.exists()) {
                    JAlbumInfo.this.deleteLocalAlbumButton.setVisible(true);
                }
                JAlbumInfo.this.pack();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RemoteSpaceCalculator
    extends SwingWorker<String, Object> {
        int nFiles;

        RemoteSpaceCalculator() {
        }

        protected String doInBackground() throws Exception {
            try {
                Set<RemoteFile> files = JAlbumInfo.this.uploadBean.getExistingAlbumFiles(JAlbumInfo.this.engine, JAlbumInfo.this.pathFinder.getResolvedRemoteDirectory());
                long totalSize = UploadBean.getTotalSize(files, 1);
                this.nFiles = files.size();
                return JAlbumInfo.this.formatAsMB(totalSize);
            }
            catch (Exception ex) {
                System.err.println(ex);
                return null;
            }
        }

        protected void done() {
            JAlbumInfo.this.remoteSpaceSpinner.setSpinning(false);
            JAlbumInfo.this.remoteSpaceSpinner.setVisible(false);
            if (this.isCancelled()) {
                return;
            }
            JAlbumInfo.this.uploadBean.disconnect();
            try {
                String size = (String)this.get();
                if (size != null) {
                    JAlbumInfo.this.publishedAlbumSize.setText(Msg.get("ui.sizeFiles", size, this.nFiles));
                } else {
                    JAlbumInfo.this.publishedAlbumSize.setText("");
                    JAlbumInfo.this.publishedLocation.setText(Msg.get("ui.notPublished"));
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PathFinderWorker
    extends SwingWorker<UploadBean.PathFinder, Object> {
        PathFinderWorker() {
        }

        protected UploadBean.PathFinder doInBackground() throws Exception {
            JAlbumInfo.this.uploadBean.setAccountProperties(JAlbumInfo.this.account);
            JAlbumInfo.this.uploadBean.connect();
            return JAlbumInfo.this.uploadBean.getPathFinder(JAlbumInfo.this.project.getRootFolder(), JAlbumInfo.this.engine);
        }

        protected void done() {
            block8: {
                JAlbumInfo.this.publishedLocationSpinner.setSpinning(false);
                JAlbumInfo.this.publishedLocationSpinner.setVisible(false);
                try {
                    JAlbumInfo.this.pathFinder = (UploadBean.PathFinder)this.get();
                    String url = JAlbumInfo.this.pathFinder.getResolvedAlbumURL();
                    if (url == null) {
                        JAlbumInfo.this.publishedLocation.setText(Msg.get("publish.NoWebDirectorySelected"));
                        JAlbumInfo.this.publishedLocation.setURL(null);
                        break block8;
                    }
                    try {
                        if (!JAlbumInfo.this.pathFinder.albumExists()) {
                            JAlbumInfo.this.publishedLocation.setText(Msg.get("ui.notPublished"));
                            JAlbumInfo.this.publishedLocation.setURL(null);
                            JAlbumInfo.this.uploadBean.disconnect();
                            break block8;
                        }
                        JAlbumInfo.this.publishedLocation.setText(url);
                        JAlbumInfo.this.publishedLocation.setURL(url);
                        JAlbumInfo.this.publishedLocation.setToolTipText(Msg.get("ui.openInBrowser"));
                        JAlbumInfo.this.deletePublishedAlbumButton.setVisible(true);
                        JAlbumInfo.this.remoteSpaceSpinner.setVisible(true);
                        JAlbumInfo.this.remoteSpaceSpinner.setSpinning(true);
                        JAlbumInfo.this.remoteSpaceCalculator.execute();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JAlbumInfo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (RemoteFSException ex) {
                        Logger.getLogger(JAlbumInfo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                catch (ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

