/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSDelegate;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFile;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.Latch;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.RemoteFileImpl;
import se.datadosen.jalbum.UploadBean;

class DeleteWorkers {
    private UploadBean uploadBean;
    private Worker[] workers;
    private BlockingQueue<RemoteFile> queue = new LinkedBlockingQueue<RemoteFile>();
    private final RemoteFile lastMarker = new RemoteFileImpl("");
    private boolean abort = false;
    private Latch filesInProgress = new Latch();

    DeleteWorkers(UploadBean uploadBean, int maxTransfers) {
        this.uploadBean = uploadBean;
        this.workers = new Worker[maxTransfers];
        this.workers[0] = new Worker(uploadBean.getRemoteFS());
    }

    public void enqueue(RemoteFile file) throws OperationAbortedException {
        if (this.abort) {
            throw new OperationAbortedException();
        }
        this.queue.add(file);
    }

    private synchronized void fireFileProgressStarted(AlbumBeanEvent eventObject) {
        this.uploadBean.fireImageProcessingStarted(eventObject);
    }

    private synchronized void fireFileProgressFinished(AlbumBeanEvent eventObject) {
        this.uploadBean.fireImageProcessingFinished(eventObject);
    }

    void startDeleting() {
        for (int i = 1; i < this.workers.length; ++i) {
            this.workers[i] = new Worker(i);
            this.workers[i].start();
        }
    }

    void waitUntilDone() throws OperationAbortedException, IOException, RemoteFSException {
        Throwable t = null;
        if (!this.queue.isEmpty()) {
            this.workers[0].start();
        }
        this.enqueue(this.lastMarker);
        for (Worker w : this.workers) {
            try {
                w.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (this.abort) {
            throw new OperationAbortedException();
        }
        for (int i = 1; i < this.workers.length; ++i) {
            if (this.workers[i].throwable == null) {
                return;
            }
            t = this.workers[i].throwable;
        }
        if (t != null) {
            t.printStackTrace(System.err);
            if (t instanceof OperationAbortedException) {
                throw (OperationAbortedException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RemoteFSException) {
                throw (RemoteFSException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            t.printStackTrace(System.err);
        }
    }

    private class Worker
    extends Thread {
        RemoteFSDelegate channel;
        boolean disconnectOnDone;
        Throwable throwable;

        public Worker(int i) {
            super("Delete worker " + (i + 1));
            this.disconnectOnDone = true;
            this.setDaemon(true);
        }

        Worker(RemoteFSDelegate connectedChannel) {
            super("Main delete worker");
            this.disconnectOnDone = true;
            this.channel = connectedChannel;
            this.disconnectOnDone = false;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            RemoteFile file = null;
            if (this.channel == null) {
                this.prepareConnection();
            }
            while (true) {
                DeleteWorkers deleteWorkers = DeleteWorkers.this;
                synchronized (deleteWorkers) {
                    file = (RemoteFile)DeleteWorkers.this.queue.take();
                    if (file.isDirectory()) {
                        DeleteWorkers.this.filesInProgress.awaitZero();
                        this.channel.removeDirectory(file.getFullPath());
                        continue;
                    }
                    DeleteWorkers.this.filesInProgress.countUp();
                }
                if (file == DeleteWorkers.this.lastMarker) break;
                if (DeleteWorkers.this.abort) {
                    throw new OperationAbortedException();
                }
                AlbumBeanEvent eventObject = new AlbumBeanEvent(this, file.getFullPath(), file.getName(), 0, 1, 0, 1);
                DeleteWorkers.this.fireFileProgressStarted(eventObject);
                if (eventObject.isAborted()) {
                    DeleteWorkers.this.abort = true;
                    throw new OperationAbortedException();
                }
                if (file.isDirectory()) {
                    this.channel.removeDirectory(file.getFullPath());
                } else {
                    this.channel.removeFile(file.getFullPath());
                }
                DeleteWorkers.this.filesInProgress.countDown();
                DeleteWorkers.this.fireFileProgressFinished(eventObject);
                if (eventObject.isAborted()) throw new OperationAbortedException();
            }
            DeleteWorkers.this.queue.add(DeleteWorkers.this.lastMarker);
            Object var6_7 = null;
            if (!this.disconnectOnDone) return;
            try {
                this.channel.disconnect();
                return;
            }
            catch (Exception ex2) {}
            return;
            {
                catch (InterruptedException ex) {
                    Object var6_8 = null;
                    if (!this.disconnectOnDone) return;
                    try {
                        this.channel.disconnect();
                        return;
                    }
                    catch (Exception ex2) {}
                    return;
                }
                catch (Throwable t) {
                    if (file != null) {
                        BlockingQueue blockingQueue = DeleteWorkers.this.queue;
                        synchronized (blockingQueue) {
                            DeleteWorkers.this.queue.add(file);
                            DeleteWorkers.this.filesInProgress.countDown();
                        }
                    }
                    t.printStackTrace(System.err);
                    this.throwable = t;
                    Object var6_9 = null;
                    if (!this.disconnectOnDone) return;
                    try {
                        this.channel.disconnect();
                        return;
                    }
                    catch (Exception ex2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (!this.disconnectOnDone) throw throwable;
                try {
                    this.channel.disconnect();
                    throw throwable;
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        private void prepareConnection() throws RemoteFSException, IOException {
            this.channel = RemoteFSBean.createInstance();
            this.connect();
        }

        private void connect() throws RemoteFSException, IOException {
            UploadBean ub = DeleteWorkers.this.uploadBean;
            this.channel.setProtocol(ub.getProtocol());
            this.channel.setForceUTF8(ub.isFtpForceUTF8());
            this.channel.setPassiveMode(ub.isPassiveMode());
            this.channel.setPort(ub.getFtpPort());
            this.channel.connect(ub.getFtpServer(), ub.getFtpUser(), ub.getFtpPassword());
        }
    }
}

