/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import se.datadosen.component.JSmartTextField;

public class JBackgroundTextField
extends JSmartTextField {
    private String backgroundText;

    public String getBackgroundText() {
        return this.backgroundText;
    }

    public void setBackgroundText(String backgroundText) {
        this.backgroundText = backgroundText;
        this.repaint();
    }

    public JBackgroundTextField(int chars) {
        super(chars);
        this.init();
    }

    private void init() {
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                JBackgroundTextField.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                JBackgroundTextField.this.setText(JBackgroundTextField.this.getText().trim());
                JBackgroundTextField.this.repaint();
            }
        });
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.hasFocus() && this.getText().equals("") && this.backgroundText != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setColor(Color.gray);
            Font originalFont = g.getFont();
            g.setFont(originalFont.deriveFont(2));
            FontMetrics fm = g.getFontMetrics();
            String s = this.backgroundText;
            Rectangle2D rect = fm.getStringBounds(s, g);
            LineMetrics lm = fm.getLineMetrics(s, g);
            g.drawString(s, 6, (int)((double)lm.getAscent() + ((double)this.getHeight() - rect.getHeight()) / 2.0));
            g.setFont(originalFont);
        }
    }
}

