/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util.startup;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.ICancel;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.ILoadingMessage;

public class Loading
extends Dialog
implements ILoadingMessage {
    String empty = "...........................................................................................";
    private JLabel myCurrentLbl = new JLabel(this.empty);
    private JLabel mySourceLbl = new JLabel(this.empty);
    private ICancel myCancel;
    private int myIncrement = 1;

    public Loading(Frame parent) {
        super(parent);
        super.setTitle(AppStarter.getString("Loading.1"));
        super.setResizable(false);
        super.setModal(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Loading.this.cancel();
            }
        });
        try {
            this.initLayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        SwingUtils.centerOnScreen(this);
        super.setVisible(true);
    }

    public void start(Runnable run) {
        if (run == null) {
            this.dispose();
            throw new IllegalArgumentException("Task required");
        }
        Thread thread = new Thread(run);
        thread.start();
        super.setModal(true);
        super.toFront();
    }

    public void setText(String msg) {
        this.mySourceLbl.setText(msg);
    }

    public int getNextIncrement() {
        return this.myIncrement++;
    }

    public synchronized void setCancel(ICancel cancel) {
        this.myCancel = cancel;
    }

    public void setMessage(String msg) {
        this.myCurrentLbl.setText(msg);
    }

    private synchronized void cancel() {
        if (this.myCancel != null) {
            this.myCancel.cancel();
        } else {
            System.exit(0);
        }
    }

    private void initLayout() throws Exception {
        Dimension size = new Dimension(630, 15);
        this.mySourceLbl.setMinimumSize(size);
        this.mySourceLbl.setPreferredSize(size);
        this.myCurrentLbl.setMinimumSize(size);
        this.myCurrentLbl.setPreferredSize(size);
        this.myCurrentLbl.setText("Starting Task...");
        JLabel banner = new JLabel("JIBS -- The Java Image Browser Sorter                              ");
        try {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/org/gerhardb/jibs/help/banner.gif"));
            banner = new JLabel(imageIcon);
            Border raisedbevel = BorderFactory.createRaisedBevelBorder();
            Border loweredbevel = BorderFactory.createLoweredBevelBorder();
            CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
            banner.setBorder(compound);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JButton cancelBtn = new JButton(AppStarter.getString("cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Loading.this.cancel();
            }
        });
        JPanelRows basePanel = new JPanelRows(0);
        JPanel row = basePanel.topRow(1);
        row.add(banner);
        row = basePanel.nextRow();
        row.add(this.myCurrentLbl);
        row = basePanel.nextRow();
        row.add(this.mySourceLbl);
        row = basePanel.nextRow(1);
        row.add(cancelBtn);
        this.add((Component)basePanel, null);
    }

    public static void main(String[] args) {
        JFrame parent = new JFrame();
        parent.getContentPane().add(new JLabel("hi"));
        parent.setVisible(true);
        String test = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        Runnable runThis = new Runnable(){

            public void run() {
            }
        };
        Loading loader = new Loading(parent);
        loader.setTitle("Loader Test");
        loader.setMessage(test);
        loader.setText(test);
        loader.getNextIncrement();
        loader.getNextIncrement();
        loader.getNextIncrement();
        loader.getNextIncrement();
        System.out.println("Increment: " + loader.getNextIncrement());
        loader.start(runThis);
    }
}

