/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.print;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterResolution;

public class MediaFormat {
    private static final int DEFAULT_DPI = 72;
    private PrinterResolution myResolution = new PrinterResolution(72, 72, 100);
    private double myPageFormatPageHeight;
    private double myPageFormatPrintableHeight;
    private double myPageFormatPageWidth;
    private double myPageFormatPrintableWidth;
    private double myPageFormatPrintableX;
    private double myPageFormatPrintableY;
    private double myDpiPageHeight;
    private double myDpiPrintableHeight;
    private double myDpiPageWidth;
    private double myDpiPrintableWidth;
    private double myDpiPrintableX;
    private double myDpiPrintableY;
    private OrientationRequested myOrientation;
    private int myDPI;

    public MediaFormat() {
        this.imprintPageFormat(new PageFormat());
        this.updateDPICalcs();
    }

    public MediaFormat(PageFormat pf) {
        this.imprintPageFormat(pf);
        this.updateDPICalcs();
    }

    public MediaFormat convertToPrintable() {
        MediaFormat rtnMe = new MediaFormat();
        rtnMe.myResolution = this.myResolution;
        rtnMe.myPageFormatPageHeight = this.myPageFormatPrintableHeight;
        rtnMe.myPageFormatPrintableHeight = this.myPageFormatPrintableHeight;
        rtnMe.myPageFormatPageWidth = this.myPageFormatPrintableWidth;
        rtnMe.myPageFormatPrintableWidth = this.myPageFormatPrintableWidth;
        rtnMe.myPageFormatPrintableX = 0.0;
        rtnMe.myPageFormatPrintableY = 0.0;
        rtnMe.myDpiPageHeight = this.myDpiPrintableHeight;
        rtnMe.myDpiPrintableHeight = this.myDpiPrintableHeight;
        rtnMe.myDpiPageWidth = this.myDpiPrintableWidth;
        rtnMe.myDpiPrintableWidth = this.myDpiPrintableWidth;
        rtnMe.myDpiPrintableX = 0.0;
        rtnMe.myDpiPrintableY = 0.0;
        rtnMe.myOrientation = this.myOrientation;
        rtnMe.myDPI = this.myDPI;
        return rtnMe;
    }

    public int getDPI() {
        return this.myDPI;
    }

    public double getDpiPageHeight() {
        return this.myDpiPageHeight;
    }

    public double getDpiPrintableHeight() {
        return this.myDpiPrintableHeight;
    }

    public double getDpiPageWidth() {
        return this.myDpiPageWidth;
    }

    public double getDpiPrintableWidth() {
        return this.myDpiPrintableWidth;
    }

    public double getDpiPrintableX() {
        return this.myDpiPrintableX;
    }

    public double getDpiPrintableY() {
        return this.myDpiPrintableY;
    }

    public OrientationRequested getOrientation() {
        return this.myOrientation;
    }

    private void updateDPICalcs() {
        this.myDpiPageHeight = this.myPageFormatPageHeight;
        this.myDpiPrintableHeight = this.myPageFormatPrintableHeight;
        this.myDpiPageWidth = this.myPageFormatPageWidth;
        this.myDpiPrintableWidth = this.myPageFormatPrintableWidth;
        this.myDpiPrintableX = this.myPageFormatPrintableX;
        this.myDpiPrintableY = this.myPageFormatPrintableY;
        this.myDPI = this.myResolution.getFeedResolution(100);
        if (this.myDPI != 72) {
            double dpiAdjustment = (double)this.myDPI / 72.0;
            this.myDpiPageHeight *= dpiAdjustment;
            this.myDpiPrintableHeight *= dpiAdjustment;
            this.myDpiPageWidth *= dpiAdjustment;
            this.myDpiPrintableWidth *= dpiAdjustment;
            this.myDpiPrintableX *= dpiAdjustment;
            this.myDpiPrintableY *= dpiAdjustment;
        }
    }

    public PageFormat getPageFormat() {
        Paper p = new Paper();
        p.setImageableArea(this.myPageFormatPrintableX, this.myPageFormatPrintableY, this.myPageFormatPrintableWidth, this.myPageFormatPrintableHeight);
        p.setSize(this.myPageFormatPageWidth, this.myPageFormatPageHeight);
        PageFormat rtnMe = new PageFormat();
        rtnMe.setPaper(p);
        if (this.myOrientation == OrientationRequested.LANDSCAPE) {
            rtnMe.setOrientation(0);
        } else if (this.myOrientation == OrientationRequested.REVERSE_LANDSCAPE) {
            rtnMe.setOrientation(2);
        } else {
            rtnMe.setOrientation(1);
        }
        return rtnMe;
    }

    public void imprintResolution(PrinterResolution resolution) {
        this.myResolution = resolution;
        this.updateDPICalcs();
    }

    public void imprintPageFormat(PageFormat pageFormat) {
        switch (pageFormat.getOrientation()) {
            case 0: {
                this.myOrientation = OrientationRequested.LANDSCAPE;
                break;
            }
            case 2: {
                this.myOrientation = OrientationRequested.REVERSE_LANDSCAPE;
                break;
            }
            default: {
                this.myOrientation = OrientationRequested.PORTRAIT;
            }
        }
        this.myPageFormatPageHeight = pageFormat.getHeight();
        this.myPageFormatPrintableHeight = pageFormat.getImageableHeight();
        this.myPageFormatPageWidth = pageFormat.getWidth();
        this.myPageFormatPrintableWidth = pageFormat.getImageableWidth();
        this.myPageFormatPrintableX = pageFormat.getImageableX();
        this.myPageFormatPrintableY = pageFormat.getImageableY();
        this.updateDPICalcs();
    }

    public PrinterResolution getResolution() {
        return this.myResolution;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MediaFormat)) {
            return false;
        }
        MediaFormat that = (MediaFormat)object;
        if (this.myPageFormatPageHeight != that.myPageFormatPageHeight) {
            return false;
        }
        if (this.myPageFormatPrintableHeight != that.myPageFormatPrintableHeight) {
            return false;
        }
        if (this.myPageFormatPageWidth != that.myPageFormatPageWidth) {
            return false;
        }
        if (this.myPageFormatPrintableWidth != that.myPageFormatPrintableWidth) {
            return false;
        }
        if (this.myPageFormatPrintableX != that.myPageFormatPrintableX) {
            return false;
        }
        if (this.myPageFormatPrintableY != that.myPageFormatPrintableY) {
            return false;
        }
        if (!this.myOrientation.equals(that.myOrientation)) {
            return false;
        }
        if (this.myResolution.getFeedResolution(100) != that.myResolution.getFeedResolution(100)) {
            return false;
        }
        return this.myResolution.getCrossFeedResolution(100) == that.myResolution.getCrossFeedResolution(100);
    }

    public String toString() {
        return "MediaFormat\nInch Page Height/Width: " + this.myPageFormatPageHeight / 72.0 + " / " + this.myPageFormatPageWidth / 72.0 + "\nInch Printable Height/Width: " + this.myPageFormatPrintableHeight / 72.0 + " / " + this.myPageFormatPrintableWidth / 72.0 + "\nInch Y/X: " + this.myPageFormatPrintableY / 72.0 + " / " + this.myPageFormatPrintableX / 72.0 + "\n72 Page Height/Width: " + this.myPageFormatPageHeight + " / " + this.myPageFormatPageWidth + "\n72 Printable Height/Width: " + this.myPageFormatPrintableHeight + " / " + this.myPageFormatPrintableWidth + "\n72 Y/X: " + this.myPageFormatPrintableY + " / " + this.myPageFormatPrintableX + "\nDPI: " + this.myResolution.getFeedResolution(100) + "\nDPI Page Height/Width: " + this.myDpiPageHeight + " / " + this.myDpiPageWidth + "\nDPI Printable Height/Width: " + this.myDpiPrintableHeight + " / " + this.myDpiPrintableWidth + "\nDPI Y/X: " + this.myDpiPrintableY + " / " + this.myDpiPrintableX + "\n===============================================================";
    }

    public int hashCode() {
        return (int)(this.myPageFormatPageHeight + this.myPageFormatPageWidth);
    }

    public static void main(String[] args) {
        MediaFormat mf = new MediaFormat();
        System.out.println(mf);
        mf.imprintResolution(new PrinterResolution(600, 600, 100));
        System.out.println(mf);
        mf.imprintResolution(new PrinterResolution(72, 72, 100));
        System.out.println(mf);
        MediaFormat mf1 = new MediaFormat();
        System.out.println("Equals: " + mf.equals(mf1));
        mf1.imprintResolution(new PrinterResolution(600, 600, 100));
        System.out.println("Resolution Not Equals: " + mf.equals(mf1));
        mf1 = new MediaFormat();
        System.out.println("Equals: " + mf.equals(mf1));
        Paper p = new Paper();
        p.setSize(144.0, 144.0);
        p.setImageableArea(0.0, 0.0, 100.0, 100.0);
        PageFormat pf = new PageFormat();
        pf.setPaper(p);
        System.out.println("Paper Not Equals (new page): " + mf.equals(pf));
        mf1 = new MediaFormat();
        System.out.println("Equals: " + mf.equals(mf1));
        pf.setOrientation(0);
        mf1.imprintPageFormat(pf);
        System.out.println("Orientation Not Equals: " + mf.equals(mf1));
    }
}

