/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.io;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.gerhardb.lib.io.DirListModel;

public class DragDropList
extends JList
implements Transferable,
DropTargetListener,
DragGestureListener,
DragSourceListener {
    static final DataFlavor[] myDataFlavors = new DataFlavor[]{DataFlavor.javaFileListFlavor};
    DefaultListModel myListModel;
    DragSource myDragSource = new DragSource();
    ArrayList myTransferData = new ArrayList();
    int myDragOverIndex = -1;
    int[] myDragSelections;
    boolean okToDropFiles;

    public DragDropList(DefaultListModel model, boolean filesOK) {
        super(model);
        super.setCellRenderer(new MyCellRenderer());
        this.myListModel = model;
        this.myDragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.okToDropFiles = filesOK;
    }

    public void removeSelected() {
        Object[] picked = this.getSelectedValues();
        for (int i = 0; i < picked.length; ++i) {
            this.myListModel.removeElement(picked[i]);
        }
    }

    public void dragEnter(DropTargetDragEvent event) {
        if (0 == (event.getSourceActions() & 3)) {
            event.rejectDrag();
        } else if (0 == (event.getDropAction() & 3)) {
            event.acceptDrag(3);
        }
        this.myDragSelections = this.getSelectedIndices();
    }

    public void dragExit(DropTargetEvent dte) {
        this.myDragOverIndex = -1;
        this.myDragSelections = null;
    }

    public void dragOver(DropTargetDragEvent dtde) {
        int index;
        dtde.getLocation();
        Point dropPoint = dtde.getLocation();
        this.myDragOverIndex = index = this.locationToIndex(dropPoint);
        int[] indicesPlus = new int[this.myDragSelections.length + 1];
        for (int i = 0; i < this.myDragSelections.length; ++i) {
            indicesPlus[i] = this.myDragSelections[i];
        }
        indicesPlus[this.myDragSelections.length] = index;
        this.setSelectedIndices(indicesPlus);
    }

    public void drop(DropTargetDropEvent event) {
        if (!event.isDataFlavorSupported(myDataFlavors[0])) {
            event.rejectDrop();
            return;
        }
        switch (event.getDropAction()) {
            case 2: {
                event.acceptDrop(2);
                break;
            }
            case 1: {
                event.acceptDrop(1);
                break;
            }
        }
        this.myDragOverIndex = -1;
        event.dropComplete(this.doDrop(event));
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        this.myDragSource.startDrag(dge, DragSource.DefaultMoveDrop, this, this);
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess()) {
            // empty if block
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public Object getTransferData(DataFlavor flavor) {
        this.myTransferData = new ArrayList();
        for (int i = 0; i < this.myDragSelections.length; ++i) {
            this.myTransferData.add(this.myListModel.elementAt(this.myDragSelections[i]));
        }
        return this.myTransferData;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return myDataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < myDataFlavors.length; ++i) {
            if (!myDataFlavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    private boolean doDrop(DropTargetDropEvent event) {
        Transferable transfer = event.getTransferable();
        try {
            Point dropPoint = event.getLocation();
            int index = this.locationToIndex(dropPoint);
            Object moveObj = transfer.getTransferData(myDataFlavors[0]);
            if (2 == event.getDropAction() && this.myTransferData.equals(moveObj)) {
                for (int i = this.myDragSelections.length - 1; i >= 0; --i) {
                    if (this.myDragSelections[i] < index) {
                        --index;
                    }
                    this.myListModel.remove(this.myDragSelections[i]);
                }
            }
            if (moveObj instanceof List) {
                List fileList = (List)moveObj;
                int[] newIndexes = new int[fileList.size()];
                for (int i = 0; i < newIndexes.length; ++i) {
                    Object obj = fileList.get(i);
                    if (!(obj instanceof File)) continue;
                    File saveMe = (File)obj;
                    boolean doDrop = true;
                    if (!this.okToDropFiles && !saveMe.isDirectory()) {
                        doDrop = false;
                    }
                    if (!doDrop) continue;
                    this.myListModel.add(index, saveMe);
                    newIndexes[i] = index++;
                }
                this.setSelectedIndices(newIndexes);
                return true;
            }
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
            System.err.println("DragDropList.drop: " + ex.getMessage());
            event.rejectDrop();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.err.println("DragDropList.drop: " + ex.getMessage());
            event.rejectDrop();
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            DirListModel model = new DirListModel(null);
            DragDropList dirList = new DragDropList(model, true);
            dirList.setMinimumSize(new Dimension(200, 100));
            model.recurseAdd(new File("E:/testpics"));
            JFrame f = new JFrame("File Tree Test");
            f.getContentPane().add(dirList);
            f.setSize(300, 300);
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
            f.setVisible(true);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            if (DragDropList.this.myDragOverIndex == index) {
                this.setBackground(Color.YELLOW);
                this.setForeground(Color.BLACK);
            } else if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

