/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.image.ImageUtil;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.util.startup.AppStarter;

public abstract class IOImage {
    File myFile;
    BufferedImage myImage;

    public IOImage(File file) throws Exception {
        this.myFile = file;
        if (this.myFile == null || !this.myFile.exists()) {
            throw new IOException(this.myFile + " " + AppStarter.getString("IOImage.0"));
        }
    }

    public abstract BufferedImage getImage();

    public abstract void save(BufferedImage var1, File var2) throws Exception;

    public abstract String getImageFactoryName();

    public abstract boolean isSaveInNataveFormatPossible();

    public File getFile() {
        return this.myFile;
    }

    public void saveJPEG(BufferedImage image, float quality) throws IOException {
        this.saveJPEG(image, quality, this.myFile.getAbsolutePath());
    }

    public void saveJPEG(BufferedImage image, float quality, String saveAsName) throws IOException {
        String testName = saveAsName.toLowerCase();
        if (!testName.endsWith(".jpeg") && !testName.endsWith(".jpg")) {
            saveAsName = FileUtil.fileNameNoExtension(saveAsName) + ".jpeg";
        }
        File theFile = new File(saveAsName);
        ImageUtil.saveJPEG(image, quality, theFile);
        this.myImage = image;
        this.myFile = theFile;
    }

    public void save(BufferedImage image) throws Exception {
        this.save(image, this.myFile.getAbsolutePath());
    }

    public void save(BufferedImage image, String saveAsName) throws Exception {
        File theFile = new File(saveAsName);
        this.save(image, theFile);
        this.myImage = image;
        this.myFile = theFile;
    }

    public static void main(String[] args) {
        File in = new File("e:/testpics/proof/a.jpg");
        File out = new File("e:/testpics/a.jpeg");
        try {
            BufferedImage img = ImageFactory.getImageFactory().makeImage(in).getImage();
            ImageUtil.saveJPEG(img, 1.0f, out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

