/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.gerhardb.lib.dirtree.rdp.ListShowTreeCoordinator;
import org.gerhardb.lib.dirtree.rdp.PathManager;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.startup.AppStarter;

public class BasicOptionsManager {
    private static final String START_TYPE = "StartType";
    public static final int START_NO_DIRECTORY = 0;
    public static final int START_LAST_VIEWED_DIRECTORY = 1;
    public static final int START_PARTICULAR_DIRECTORY = 2;
    private static final String REMEMBER_DIRECTORIES = "rememberDirectories";
    JRadioButton startNothing = new JRadioButton(AppStarter.getString("VPDMainPanel.2"));
    JRadioButton startLast = new JRadioButton(AppStarter.getString("VPDMainPanel.3"));
    JRadioButton startParticular = new JRadioButton(PathManager.VIEW_DIR_BTN_TEXT);
    JCheckBox rememberChkBox = new JCheckBox(AppStarter.getString("VPDMainPanel.81"));
    ListShowTreeCoordinator myLST;
    JPanel basicPanel = new JPanel(false);

    public BasicOptionsManager(ListShowTreeCoordinator lst) {
        this.myLST = lst;
    }

    void init() {
        switch (this.getStartType()) {
            case 2: {
                this.startParticular.setSelected(true);
                break;
            }
            case 1: {
                this.startLast.setSelected(true);
                break;
            }
            default: {
                this.startNothing.setSelected(true);
            }
        }
    }

    public boolean getRememberDirectories() {
        return this.myLST.getPreferences().getBoolean(REMEMBER_DIRECTORIES, true);
    }

    public int getStartType() {
        return this.myLST.getPreferences().getInt(START_TYPE, 1);
    }

    public boolean getStartNothing() {
        return this.startNothing.isSelected();
    }

    public Component getStartupComponent(JComponent component) {
        this.startNothing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BasicOptionsManager.this.adjustView();
            }
        });
        this.startLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BasicOptionsManager.this.adjustView();
            }
        });
        this.startParticular.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                BasicOptionsManager.this.adjustView();
            }
        });
        this.adjustView();
        this.rememberChkBox.setSelected(this.getRememberDirectories());
        this.rememberChkBox.setToolTipText("<html>" + AppStarter.getString("VPDMainPanel.47") + "<br>" + AppStarter.getString("VPDMainPanel.49") + "<br>" + AppStarter.getString("VPDMainPanel.51") + "</html>");
        JPanelRows rtnMe = new JPanelRows();
        rtnMe.setToolTipText(AppStarter.getString("VPDMainPanel.53"));
        rtnMe.setBorder(new TitledBorder(new LineBorder(Color.BLACK), AppStarter.getString("VPDMainPanel.54"), 1, 2));
        JPanel aRow = rtnMe.topRow();
        aRow.add(this.rememberChkBox);
        if (component != null) {
            aRow.add(component);
        }
        aRow = rtnMe.nextRow();
        aRow.add(this.startNothing);
        aRow.add(this.startLast);
        aRow.add(this.startParticular);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.startNothing);
        bg.add(this.startLast);
        bg.add(this.startParticular);
        return rtnMe;
    }

    public Component getSortComponent() {
        JPanel rtnMe = new JPanel();
        rtnMe.setToolTipText(AppStarter.getString("VPDMainPanel.70"));
        rtnMe.setBorder(new TitledBorder(new LineBorder(Color.BLACK), AppStarter.getString("VPDMainPanel.71"), 1, 2));
        BoxLayout layout = new BoxLayout(rtnMe, 1);
        rtnMe.setLayout(layout);
        JRadioButton[] sortButtons = this.myLST.getSortManager().makeSortRadioButtons();
        for (int i = 0; i < sortButtons.length; ++i) {
            rtnMe.add(sortButtons[i]);
        }
        return rtnMe;
    }

    public void adjustView() {
        this.myLST.getPathManager().adjustView(this.startParticular.isSelected());
    }

    public void save() {
        try {
            this.myLST.getPathManager().save();
            if (this.startParticular.isSelected()) {
                this.myLST.getPreferences().putInt(START_TYPE, 2);
            } else if (this.startLast.isSelected()) {
                this.myLST.getPreferences().putInt(START_TYPE, 1);
            } else {
                this.myLST.getPreferences().putInt(START_TYPE, 0);
            }
            this.myLST.getPreferences().putBoolean(REMEMBER_DIRECTORIES, this.rememberChkBox.isSelected());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.basicPanel, ex.getMessage(), AppStarter.getString("save.failed"), 0);
            return;
        }
    }
}

