/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.io.File;
import javax.swing.JOptionPane;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.dirtree.filelist.FileListPlugins;
import org.gerhardb.lib.dirtree.filelist.popup.FileSeveralNameChangeDialog;
import org.gerhardb.lib.dirtree.filelist.popup.FileSingleNameChangeDialog;
import org.gerhardb.lib.util.startup.AppStarter;

public class FileNameChanger {
    File[] myInputFileList;
    File[] myOutputFileList;
    boolean iRan = false;
    private boolean iFoundDuplicates = false;
    private boolean iWasCancelled = false;

    public FileNameChanger(File[] fileList) {
        this.myInputFileList = fileList;
        this.myOutputFileList = new File[this.myInputFileList.length];
        for (int i = 0; i < this.myInputFileList.length; ++i) {
            this.myOutputFileList[i] = this.myInputFileList[i];
            for (int j = i + 1; j < this.myInputFileList.length; ++j) {
                if (this.myInputFileList[i] == null || this.myInputFileList[j] == null || !this.myInputFileList[i].equals(this.myInputFileList[j])) continue;
                if (!this.iFoundDuplicates) {
                    this.iFoundDuplicates = true;
                    int picked = JOptionPane.showConfirmDialog(null, AppStarter.getString("FileNameChanger.0"), AppStarter.getString("FileNameChanger.1"), 2);
                    if (picked == 2) {
                        this.iWasCancelled = true;
                        return;
                    }
                }
                this.myInputFileList[j] = null;
            }
        }
    }

    public File[] getChangedNames() {
        return this.myOutputFileList;
    }

    public boolean ran() {
        return this.iRan;
    }

    public void showDialog(FileListPlugins plugins, ExtendedDirectoryTree tree, boolean bothTabs, boolean showRenameTabAtTop) {
        if (this.iWasCancelled) {
            return;
        }
        if (this.myInputFileList.length < 2) {
            new FileSingleNameChangeDialog(this, plugins, tree, bothTabs, showRenameTabAtTop);
        } else {
            new FileSeveralNameChangeDialog(this, plugins, tree, bothTabs, showRenameTabAtTop);
        }
    }
}

