/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.gerhardb.lib.dirtree.filelist.popup.FileName;
import org.gerhardb.lib.dirtree.filelist.popup.FileSeveralNameChangeDialog;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.startup.AppStarter;

public class FileNameChangeCompleteTab
extends JPanel {
    private Preferences myPrefs;
    private final String USE_NEW_ENDING = "newEnding";
    private final String ENDING = "ending";
    JTextField myTextFld = new JTextField(33);
    JTextField myEndingFld = new JTextField(6);
    String mySampleText = "sample";
    JLabel mySampleLbl = new JLabel("<html><big>&nbsp;</big></html>");
    FileSeveralNameChangeDialog myDialog;
    FileName myFileName;
    JRadioButton myKeepEndingBtn = new JRadioButton(AppStarter.getString("FileNameChangeCompleteTab.2"));
    JRadioButton myChangeEndingBtn = new JRadioButton(AppStarter.getString("FileNameChangeCompleteTab.3"));
    JButton myOkBtn = new JButton(AppStarter.getString("ok"));

    FileNameChangeCompleteTab(FileSeveralNameChangeDialog dialog, String sample, int listLength, String appName) {
        super(new BorderLayout());
        this.myDialog = dialog;
        this.mySampleText = sample;
        this.myFileName = new FileName(listLength);
        this.myPrefs = Preferences.userRoot().node("/" + appName + "/org/gerhardb/jibs/viewer/FileNameChangeCompleteTab");
        this.setUpScreen();
        this.mySampleLbl.setText(this.getNewName(1, this.mySampleText, true));
    }

    public JButton getDefaultButton() {
        return this.myOkBtn;
    }

    public String getNewName(int i, String oldName, boolean html) {
        String ending = null;
        if (this.myChangeEndingBtn.isSelected()) {
            ending = this.myEndingFld.getText();
        }
        return this.myFileName.getNewName(i, oldName, html, ending);
    }

    private void setUpScreen() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.myKeepEndingBtn);
        bg.add(this.myChangeEndingBtn);
        this.myTextFld.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FileNameChangeCompleteTab.this.myFileName.setTemplate(FileNameChangeCompleteTab.this.myTextFld.getText());
                FileNameChangeCompleteTab.this.mySampleLbl.setText(FileNameChangeCompleteTab.this.getNewName(1, FileNameChangeCompleteTab.this.mySampleText, true));
            }
        });
        this.myEndingFld.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FileNameChangeCompleteTab.this.mySampleLbl.setText(FileNameChangeCompleteTab.this.getNewName(1, FileNameChangeCompleteTab.this.mySampleText, true));
                FileNameChangeCompleteTab.this.myPrefs.put("ending", FileNameChangeCompleteTab.this.myEndingFld.getText());
            }
        });
        ActionListener endingListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileNameChangeCompleteTab.this.myPrefs.putBoolean("newEnding", FileNameChangeCompleteTab.this.myChangeEndingBtn.isSelected());
                FileNameChangeCompleteTab.this.mySampleLbl.setText(FileNameChangeCompleteTab.this.getNewName(1, FileNameChangeCompleteTab.this.mySampleText, true));
                if (FileNameChangeCompleteTab.this.myChangeEndingBtn.isSelected()) {
                    FileNameChangeCompleteTab.this.myEndingFld.setEnabled(true);
                } else {
                    FileNameChangeCompleteTab.this.myEndingFld.setEnabled(false);
                }
            }
        };
        this.myChangeEndingBtn.addActionListener(endingListener);
        this.myKeepEndingBtn.addActionListener(endingListener);
        this.myOkBtn = new JButton(AppStarter.getString("ok"));
        this.myOkBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileNameChangeCompleteTab.this.ok();
            }
        });
        this.myOkBtn.setMnemonic(75);
        JButton cancelBtn = new JButton(AppStarter.getString("cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileNameChangeCompleteTab.this.cancel();
            }
        });
        JPanelRows mainPanel = new JPanelRows(1);
        JPanel row = mainPanel.topRow();
        row.add(new JLabel("Change name to" + AppStarter.getString("colon") + " "));
        row.add(this.myTextFld);
        row = mainPanel.nextRow();
        row.add(new JLabel(AppStarter.getString("FileNameChangeCompleteTab.6")));
        row = mainPanel.nextRow();
        row.add(new JLabel("<html>&nbsp;</html>"));
        row.add(this.mySampleLbl);
        row = mainPanel.nextRow(0);
        row.add(this.myKeepEndingBtn);
        row = mainPanel.nextRow(0);
        row.add(this.myChangeEndingBtn);
        row.add(this.myEndingFld);
        this.myEndingFld.setText(this.myPrefs.get(this.ENDING, null));
        if (this.myPrefs.getBoolean(this.USE_NEW_ENDING, false)) {
            this.myChangeEndingBtn.setSelected(true);
            this.myEndingFld.setEnabled(true);
        } else {
            this.myKeepEndingBtn.setSelected(true);
            this.myEndingFld.setEnabled(false);
        }
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        btnPanel.add(this.myOkBtn);
        btnPanel.add(cancelBtn);
        super.add((Component)mainPanel, "Center");
        super.add((Component)btnPanel, "South");
    }

    void ok() {
        this.myDialog.doNameChange();
        this.myDialog.done();
    }

    void cancel() {
        this.myTextFld.setText(null);
        this.myDialog.done();
    }
}

