/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.filelist;

import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JToolBar;
import org.gerhardb.lib.dirtree.DTNListFactory;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.rdp.TreeManagerSet;
import org.gerhardb.lib.io.FilenameFileFilter;
import org.gerhardb.lib.playlist.FileListFactory;
import org.gerhardb.lib.playlist.ListMaker;
import org.gerhardb.lib.util.startup.ActiveActions;
import org.gerhardb.lib.util.startup.AppStarter;

public class FileListManager {
    TreeManagerSet myTreeManagerSet;
    ArrayList myBackList = new ArrayList(40);
    ArrayList myForwardList = new ArrayList(10);
    FilenameFileFilter myFilter;
    JButton myBackBtn = new JButton("dummy");
    JButton myForwardBtn = new JButton("dummy");

    public FileListManager(TreeManagerSet tm, FilenameFileFilter filter) {
        this.myTreeManagerSet = tm;
        this.myFilter = filter;
    }

    public boolean setTargetDir(String dir) {
        if (dir == null) {
            return false;
        }
        return this.setTargetDir(new File(dir));
    }

    public boolean setTargetDir(File dir) {
        if (dir == null) {
            return false;
        }
        try {
            this.myTreeManagerSet.getPathManager().setDirectory(4, dir.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            FileListFactory maker = null;
            DirectoryTreeNode node = this.myTreeManagerSet.getRDPplugins().getExtendedDirectoryTree().findANode(dir);
            if (node == null) {
                maker = new FileListFactory(dir);
                this.displayScroll(maker, true);
                return true;
            }
            return this.setTargetDir(node, false);
        }
        catch (Exception ex) {
            System.out.println("ScrollFactory: " + ex.getMessage());
            return false;
        }
    }

    public boolean setTargetDir(DirectoryTreeNode node, boolean nonImage) {
        if (node == null) {
            return false;
        }
        DirectoryTreeNode[] nodeArray = new DirectoryTreeNode[]{node};
        return this.setTargetDir(nodeArray, nonImage);
    }

    public boolean setTargetDir(DirectoryTreeNode[] nodeList, boolean nonImage) {
        if (nodeList == null || nodeList.length == 0) {
            return false;
        }
        try {
            this.myTreeManagerSet.getPathManager().setDirectory(4, nodeList[0].getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            DTNListFactory maker = new DTNListFactory(nodeList, nonImage, this.myFilter);
            this.displayScroll(maker, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public void askUserForViewDirectory(Window window) {
        int returnVal;
        File oldViewDir;
        File newDirectory = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(AppStarter.getString("Popups.10"));
        chooser.setFileSelectionMode(1);
        String oldViewDirName = this.myTreeManagerSet.getRDPplugins().getPathManager().getDirectoryAbsolute(4);
        if (oldViewDirName != null && (oldViewDir = new File(oldViewDirName)).exists() && oldViewDir.isDirectory()) {
            chooser.setCurrentDirectory(oldViewDir);
        }
        if ((returnVal = chooser.showOpenDialog(window)) == 0) {
            try {
                newDirectory = chooser.getSelectedFile();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (newDirectory == null || !newDirectory.exists() || !newDirectory.isDirectory()) {
            return;
        }
        this.setTargetDir(newDirectory);
    }

    public void addButtonsToToolBar(JToolBar bar, ActiveActions aa) {
        this.myBackBtn = aa.getToolBarButton("view", "back");
        this.myForwardBtn = aa.getToolBarButton("view", "forward");
        this.statusForwardAndBackButtons();
        bar.add(this.myBackBtn);
        bar.add(this.myForwardBtn);
    }

    public void forward() {
        if (this.myForwardList.isEmpty()) {
            return;
        }
        int lastItem = this.myForwardList.size() - 1;
        ListMaker maker = (ListMaker)this.myForwardList.remove(lastItem);
        this.myBackList.add(maker);
        this.statusForwardAndBackButtons();
        this.displayScroll(maker, false);
    }

    public void back() {
        int size = this.myBackList.size();
        if (size > 0) {
            this.myForwardList.add(this.myBackList.remove(size - 1));
        }
        ListMaker maker = null;
        if (size > 1) {
            maker = (ListMaker)this.myBackList.get(size - 2);
        }
        this.statusForwardAndBackButtons();
        this.displayScroll(maker, false);
    }

    private void statusForwardAndBackButtons() {
        this.myForwardBtn.setEnabled(!this.myForwardList.isEmpty());
        if (this.myBackList.size() > 1) {
            this.myBackBtn.setEnabled(true);
        } else {
            this.myBackBtn.setEnabled(false);
        }
    }

    private void displayScroll(ListMaker maker, boolean newDirectory) {
        this.myTreeManagerSet.getRDPplugins().setWaitCursor(true);
        this.myTreeManagerSet.getScroller().setListMaker(maker);
        this.myTreeManagerSet.getRDPmanager().getIScrollDirTree().fileListUpdated();
        this.myTreeManagerSet.getMoveManager().setUndoOff();
        if (newDirectory) {
            this.myForwardList.clear();
            this.myBackList.add(maker);
            while (this.myBackList.size() > 50) {
                this.myBackList.remove(0);
            }
        }
        this.statusForwardAndBackButtons();
        this.myTreeManagerSet.getScroller().requestFocus();
        this.myTreeManagerSet.getRDPplugins().setWaitCursor(false);
    }
}

