/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileFilter;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import org.gerhardb.lib.dirtree.DirectoryTree;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.ITreePopupMenu;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.dirtree.rdp.RDPmanager;
import org.gerhardb.lib.playlist.Scroller;

public class ExtendedDirectoryTree
extends DirectoryTree
implements DropTargetListener,
KeyListener {
    ITreePopupMenu myPopupGetter;

    public ExtendedDirectoryTree(Window window, FileFilter filter, RDPmanager rdpManager, Scroller scroller, ITreePopupMenu getter, boolean countHiddenDirectories) {
        super(window, filter, rdpManager, scroller, countHiddenDirectories);
        this.myPopupGetter = getter;
        this.addMouseListener(new MouseAdpt(this));
        this.addKeyListener(this);
        new DropTarget(this, this);
    }

    protected JPopupMenu getPopupMenu(TreePath path) {
        return this.myPopupGetter.getPopupMenu(path);
    }

    public void dragEnter(DropTargetDragEvent event) {
        switch (event.getDropAction()) {
            case 1: 
            case 2: 
            case 3: {
                event.acceptDrag(3);
                break;
            }
            default: {
                event.rejectDrag();
            }
        }
    }

    public void dragExit(DropTargetEvent dte) {
        super.clearSelection();
    }

    public void dragOver(DropTargetDragEvent dtde) {
        dtde.getLocation();
        Point dropPoint = dtde.getLocation();
        TreePath tp = this.getClosestPathForLocation(dropPoint.x, dropPoint.y);
        if (tp == null) {
            return;
        }
        Object objPicked = tp.getLastPathComponent();
        if (objPicked == null || !(objPicked instanceof DirectoryTreeNode)) {
            return;
        }
        super.setSelectionPath(tp);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent event) {
        if (!event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            event.rejectDrop();
            return;
        }
        Point dropPoint = event.getLocation();
        TreePath tp = this.getClosestPathForLocation(dropPoint.x, dropPoint.y);
        if (tp == null) {
            event.rejectDrop();
            return;
        }
        Object objPicked = tp.getLastPathComponent();
        if (objPicked == null || !(objPicked instanceof DirectoryTreeNode)) {
            event.rejectDrop();
            return;
        }
        DirectoryTreeNode dirNode = (DirectoryTreeNode)objPicked;
        boolean moveNotCopy = false;
        switch (event.getDropAction()) {
            case 2: {
                event.acceptDrop(2);
                moveNotCopy = true;
                break;
            }
            case 1: {
                event.acceptDrop(1);
                moveNotCopy = false;
                break;
            }
            default: {
                event.rejectDrop();
                return;
            }
        }
        Transferable transfer = event.getTransferable();
        Object moveObj = null;
        try {
            moveObj = transfer.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            event.dropComplete(false);
            return;
        }
        if (moveObj == null || !(moveObj instanceof List)) {
            event.dropComplete(false);
            return;
        }
        List fileList = (List)moveObj;
        this.myRDPmanager.addToRememberedMoveList(dirNode);
        this.myRDPmanager.getMoveManager().moveOrCopySeveral(moveNotCopy, dirNode, fileList.toArray());
        event.dropComplete(false);
    }

    public void keyPressed(KeyEvent e) {
        this.consume(e);
    }

    public void keyReleased(KeyEvent e) {
        this.consume(e);
    }

    public void keyTyped(KeyEvent e) {
        this.consume(e);
    }

    private void consume(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 65: {
                if (!event.isControlDown()) break;
                event.consume();
                FileList list = this.myRDPmanager.getIScrollDirTree().getFileList();
                list.setSelectionInterval(0, list.getModel().getSize() - 1);
            }
        }
    }

    void showStats(DirectoryTreeNode node, boolean countImageFilesInNodes) {
        this.myRDPmanager.showStats(node, countImageFilesInNodes);
    }

    private class MouseAdpt
    extends MouseAdapter {
        ExtendedDirectoryTree myTree = null;
        TreePath selPath = null;

        public MouseAdpt(ExtendedDirectoryTree tree) {
            this.myTree = tree;
        }

        public void mouseReleased(MouseEvent e) {
            int selRow = this.myTree.getRowForLocation(e.getX(), e.getY());
            if (selRow < 0) {
                return;
            }
            if (e.getClickCount() == 1) {
                this.selPath = this.myTree.getPathForLocation(e.getX(), e.getY());
            }
            if ((e.getModifiers() & 8) != 0 || (e.getModifiers() & 4) != 0) {
                ExtendedDirectoryTree.this.getPopupMenu(this.selPath).show((Component)e.getSource(), e.getX(), e.getY());
                return;
            }
            if (e.getClickCount() == 2) {
                Object end = this.selPath.getLastPathComponent();
                if (end == null || !(end instanceof DirectoryTreeNode)) {
                    return;
                }
                ExtendedDirectoryTree.this.myRDPmanager.getIScrollDirTree().setCurrentDirectory((DirectoryTreeNode)end, false);
            }
            super.mouseReleased(e);
        }
    }
}

