/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gerhardb.jibs.explorer.ExplorerBox;
import org.gerhardb.lib.dirtree.DTNListFactory;
import org.gerhardb.lib.dirtree.DTNWriter;
import org.gerhardb.lib.dirtree.DirectoryTree;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.io.FileNameComparatorInsensative;
import org.gerhardb.lib.io.FilenameFileFilter;
import org.gerhardb.lib.playlist.ListMaker;
import org.gerhardb.lib.util.ModalProgressDialogFlex;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.ILoadingMessage;

public class DirectoryTreeNode
extends DefaultMutableTreeNode {
    private DirectoryTree myTree;
    private String myDisplayName;
    private File myDirectory;
    private static boolean clsCancelLoad = false;
    protected int myNodeDirCount = 0;
    protected int myNodeAllFileCount = 0;
    protected int myNodeTargetFileCount = 0;
    protected long myNodeAllFileSize = 0L;
    protected long myNodeTargetFileSize = 0L;
    boolean iAmPopulating = true;

    public DirectoryTreeNode(DirectoryTree tree, File f, ILoadingMessage loadingMsg) throws FileNotFoundException {
        this.myTree = tree;
        this.myDisplayName = f.getName();
        if (this.myDisplayName.trim().equals("")) {
            this.myDisplayName = f.toString();
        }
        this.myDirectory = f;
        if (!f.isDirectory()) {
            throw new FileNotFoundException(f.toString() + " " + AppStarter.getString("DirectoryTreeNode.1"));
        }
        if (loadingMsg != null) {
            loadingMsg.setMessage(loadingMsg.getNextIncrement() + " " + this.myDisplayName);
        }
    }

    public boolean isPopulating() {
        return this.iAmPopulating;
    }

    public static void cancelRecursiveLoading() {
        clsCancelLoad = true;
    }

    public static void resetRecursiveLoading() {
        clsCancelLoad = false;
    }

    public File getDirectory() {
        return this.myDirectory;
    }

    public String getAbsolutePath() {
        return this.myDirectory.getAbsolutePath();
    }

    public File getFile() {
        return this.myDirectory;
    }

    public String getName() {
        return this.myDisplayName;
    }

    public int getDirCountForTree() {
        return this.myNodeDirCount;
    }

    public int getTotalFileCount() {
        return this.myNodeAllFileCount;
    }

    public int getTargetFileCount() {
        return this.myNodeTargetFileCount;
    }

    public long getTotalFileSize() {
        return this.myNodeAllFileSize;
    }

    public long getTargetFileSize() {
        return this.myNodeTargetFileSize;
    }

    public TreeTotals getTreeTotals() {
        TreeTotals rtnMe = new TreeTotals();
        this.addNodeToTotals(this, rtnMe);
        this.loopOverKids(this, rtnMe);
        return rtnMe;
    }

    private void loopOverKids(DirectoryTreeNode node, TreeTotals tt) {
        Enumeration<TreeNode> kids = node.children();
        while (kids.hasMoreElements()) {
            DirectoryTreeNode aChild = (DirectoryTreeNode)kids.nextElement();
            this.addNodeToTotals(aChild, tt);
            this.loopOverKids(aChild, tt);
        }
    }

    private void addNodeToTotals(DirectoryTreeNode node, TreeTotals tt) {
        tt.aggregateDirectoryCount += node.myNodeDirCount;
        tt.aggregateTotalFileCount += node.myNodeAllFileCount;
        tt.aggregateTargetFileCount += node.myNodeTargetFileCount;
        tt.aggregateTotalFileSize += node.myNodeAllFileSize;
        tt.aggregateTargetFileSize += node.myNodeTargetFileSize;
    }

    public void populate(ILoadingMessage loadingMsg) {
        File[] dirArray = this.countFiles();
        try {
            Arrays.sort(dirArray, new FileNameComparatorInsensative());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < dirArray.length; ++i) {
            try {
                DirectoryTreeNode node = new DirectoryTreeNode(this.myTree, dirArray[i], loadingMsg);
                super.add(node);
                node.populate(loadingMsg);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.iAmPopulating = false;
    }

    public void recount() {
        this.iAmPopulating = true;
        this.countFiles();
        this.iAmPopulating = false;
        this.myTree.updateTreeLabels();
        DefaultTreeModel dtm = (DefaultTreeModel)this.myTree.getModel();
        dtm.nodeStructureChanged(this);
    }

    public void incrementFileCount(long newFileSize) {
        ++this.myNodeAllFileCount;
        ++this.myNodeTargetFileCount;
        this.myNodeAllFileSize += newFileSize;
        this.myNodeTargetFileSize += newFileSize;
        this.myTree.updateTreeLabels();
    }

    public void decrementFileCount(long newFileSize) {
        --this.myNodeAllFileCount;
        --this.myNodeTargetFileCount;
        this.myNodeAllFileSize -= newFileSize;
        this.myNodeTargetFileSize -= newFileSize;
        this.myTree.updateTreeLabels();
    }

    public void reloadNodes() {
        final ModalProgressDialogFlex flex = new ModalProgressDialogFlex(this.myTree.getTopWindow(), AppStarter.getString("DirectoryTreeNode.17"), AppStarter.getString("DirectoryTreeNode.18"), null, null, 300L);
        Runnable runMe = new Runnable(){

            public void run() {
                DirectoryTreeNode.this.iAmPopulating = true;
                DirectoryTreeNode.this.reloadNodes(flex);
                DirectoryTreeNode.this.iAmPopulating = false;
            }
        };
        flex.run(runMe);
    }

    public void reloadNodes(final ExplorerBox box, final boolean supressRootDirectories, final DTNWriter writer) {
        final ModalProgressDialogFlex flex = new ModalProgressDialogFlex(this.myTree.getTopWindow(), AppStarter.getString("DirectoryTreeNode.17"), AppStarter.getString("DirectoryTreeNode.18"), null, null, 300L);
        Runnable runMe = new Runnable(){

            public void run() {
                DirectoryTreeNode.this.iAmPopulating = true;
                DirectoryTreeNode.this.reloadNodes(flex);
                try {
                    writer.store(DirectoryTreeNode.this);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(box, "Unexpected Problem storing node list", ex.getMessage(), 0);
                }
                DirectoryTreeNode.this.iAmPopulating = false;
                try {
                    box.setRootDirectory(DirectoryTreeNode.this.myDirectory, supressRootDirectories);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        flex.run(runMe);
    }

    public void reloadNodes(ModalProgressDialogFlex flex) {
        DTNListFactory dlf;
        super.removeAllChildren();
        this.populate(flex);
        ((DefaultTreeModel)this.myTree.getModel()).nodeStructureChanged(this);
        if (this.myTree.myRDPmanager == null) {
            return;
        }
        this.myTree.myRDPmanager.rescan();
        ListMaker lm = this.myTree.getScroller().getListMaker();
        if (lm instanceof DTNListFactory && (dlf = (DTNListFactory)lm).nodesUpdated(this)) {
            this.myTree.getScroller().reloadScroller();
        }
    }

    private File[] countFiles() {
        ArrayList<File> rtnDirectories = new ArrayList<File>(100);
        boolean countTargetFiles = this.myTree.getCountTargetFiles();
        this.myNodeDirCount = 0;
        this.myNodeAllFileCount = 0;
        this.myNodeTargetFileCount = 0;
        this.myNodeAllFileSize = 0L;
        this.myNodeTargetFileSize = 0L;
        File[] files = this.myDirectory.listFiles();
        if (files == null || files.length == 0 || clsCancelLoad) {
            return new File[0];
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                if (!this.myTree.isNotAnExcludedDirectory(files[i])) continue;
                if (this.myTree.countHiddenDirectories()) {
                    rtnDirectories.add(files[i]);
                    ++this.myNodeDirCount;
                    continue;
                }
                if (files[i].isHidden()) continue;
                rtnDirectories.add(files[i]);
                ++this.myNodeDirCount;
                continue;
            }
            ++this.myNodeAllFileCount;
            this.myNodeAllFileSize += files[i].length();
            if (!countTargetFiles || !this.myTree.getFileFilter().accept(files[i])) continue;
            ++this.myNodeTargetFileCount;
            this.myNodeTargetFileSize += files[i].length();
        }
        File[] rtnMe = new File[rtnDirectories.size()];
        rtnDirectories.toArray(rtnMe);
        return rtnMe;
    }

    private synchronized void addNode(File dirFile) {
        if (!dirFile.isDirectory()) {
            return;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DirectoryTreeNode node = (DirectoryTreeNode)this.getChildAt(i);
            if (!node.myDisplayName.equals(this.myDisplayName)) continue;
            return;
        }
        TreePath pathToShow = new TreePath(this.getPath());
        TreePath[] expanded = this.myTree.getExpandedDescendants(this.myTree.getRootNode(), pathToShow);
        try {
            DirectoryTreeNode node = new DirectoryTreeNode(this.myTree, dirFile, null);
            super.add(node);
            pathToShow = pathToShow.pathByAddingChild(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((DefaultTreeModel)this.myTree.getModel()).nodeStructureChanged(this);
        this.sort();
        this.myTree.expandPath(expanded);
        this.myTree.expandPath(pathToShow);
        this.myTree.scrollPathToVisible(pathToShow);
    }

    private void sort() {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(super.getChildCount());
        Enumeration<TreeNode> kids = super.children();
        while (kids.hasMoreElements()) {
            list.add(kids.nextElement());
        }
        Object[] nodeArray = list.toArray();
        try {
            Arrays.sort(nodeArray, new FileNameComparatorInsensative());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.removeAllChildren();
        for (int i = 0; i < nodeArray.length; ++i) {
            super.add((DirectoryTreeNode)nodeArray[i]);
        }
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        model.nodeStructureChanged(this);
    }

    public void newSubDir() {
        String parentDir = this.myDirectory.getAbsolutePath();
        String newDirName = JOptionPane.showInputDialog(AppStarter.getString("DirectoryTreeNode.3"));
        if (newDirName == null) {
            return;
        }
        if ((newDirName = newDirName.trim()).length() == 0) {
            return;
        }
        try {
            File newDir = new File(parentDir, newDirName);
            if (newDir.mkdir()) {
                this.addNode(newDir);
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
    }

    public void renameDir() {
        String fullOldName = null;
        String fullNewName = null;
        try {
            String oldName = this.myDirectory.getName();
            String question = AppStarter.getString("DirectoryTreeNode.4") + AppStarter.getString("colon") + " ";
            String newDirName = JOptionPane.showInputDialog(question, (Object)oldName);
            if (newDirName == null) {
                return;
            }
            if ((newDirName = newDirName.trim()).length() == 0) {
                return;
            }
            String parentDir = this.myDirectory.getParent();
            if (parentDir != null) {
                fullOldName = parentDir + File.separator + oldName;
                fullNewName = parentDir + File.separator + newDirName;
            } else {
                fullOldName = oldName;
                fullNewName = newDirName;
            }
            if (!this.myDirectory.exists()) {
                JOptionPane.showMessageDialog(this.myTree, AppStarter.getString("DirectoryTreeNode.23"), AppStarter.getString("DirectoryTreeNode.24"), 1);
                return;
            }
            if (!this.myDirectory.canWrite()) {
                JOptionPane.showMessageDialog(this.myTree, AppStarter.getString("DirectoryTreeNode.25"), AppStarter.getString("DirectoryTreeNode.26"), 1);
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.myTree, AppStarter.getString("DirectoryTreeNode.27") + ex.getLocalizedMessage(), AppStarter.getString("DirectoryTreeNode.28"), 1);
        }
        try {
            File newDir = new File(fullNewName);
            if (newDir.exists()) {
                JOptionPane.showMessageDialog(this.myTree, AppStarter.getString("DirectoryTreeNode.31"), AppStarter.getString("DirectoryTreeNode.32"), 1);
                return;
            }
            if (this.myDirectory.renameTo(newDir)) {
                this.myDirectory = newDir;
                this.myDisplayName = this.myDirectory.getName();
                ((DefaultTreeModel)this.myTree.getModel()).nodeChanged(this);
                DirectoryTreeNode theParent = (DirectoryTreeNode)super.getParent();
                if (theParent != null) {
                    theParent.sort();
                }
                if (this.myTree.getPlugins() != null) {
                    this.myTree.getPlugins().updateDirNameIfNeeded(fullOldName, fullNewName, this);
                }
            } else {
                JOptionPane.showMessageDialog(this.myTree, AppStarter.getString("DirectoryTreeNode.33"), AppStarter.getString("DirectoryTreeNode.34"), 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.myTree, AppStarter.getString("DirectoryTreeNode.35") + ex.getLocalizedMessage(), AppStarter.getString("DirectoryTreeNode.36"), 1);
        }
    }

    public void deleteDir() {
        int answer;
        File[] files = this.myDirectory.listFiles();
        if (files != null && files.length > 0 && (answer = JOptionPane.showConfirmDialog(null, this.myDisplayName + " " + AppStarter.getString("DirectoryTreeNode.13") + AppStarter.getString("DirectoryTreeNode.14") + AppStarter.getString("DirectoryTreeNode.15"), AppStarter.getString("DirectoryTreeNode.12") + " " + this.myDisplayName + "?", 0)) == 1) {
            return;
        }
        DefaultMutableTreeNode aParent = (DefaultMutableTreeNode)super.getParent();
        if (aParent == null) {
            JOptionPane.showMessageDialog(null, AppStarter.getString("DirectoryTreeNode.11"), AppStarter.getString("DirectoryTreeNode.0"), 1);
            return;
        }
        if (!this.myDirectory.delete()) {
            return;
        }
        TreePath[] expanded = this.myTree.getExpandedDescendants(this.myTree.getRootNode(), new TreePath(this.getPath()));
        this.parent.remove(this);
        this.reloadNodes(null);
        this.myTree.expandPath(expanded);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(100);
        buff.append(this.myDisplayName);
        if (this.myTree.getCountTargetFiles()) {
            buff.append(" (" + this.myNodeTargetFileCount + " / " + this.myNodeAllFileCount + ")");
        } else {
            buff.append(" (" + this.myNodeAllFileCount + ")");
        }
        return buff.toString();
    }

    public static void main(String[] args) {
        Iterator<Charset> loop = Charset.availableCharsets().values().iterator();
        while (loop.hasNext()) {
            System.out.println(loop.next());
        }
        File dir = new File("/news/bad/umlaut");
        File[] files = dir.listFiles();
        if (files == null || files.length == 0 || clsCancelLoad) {
            return;
        }
        if (!files[0].exists()) {
            System.out.println("Failed: " + files[0]);
            try {
                byte[] bytes = files[0].getAbsolutePath().getBytes("UTF-16");
                String fileName = new String(bytes, "UTF-16");
                File aFile = new File(fileName);
                System.out.println("aFile:  " + aFile);
                if (aFile.exists()) {
                    System.out.println("Succeeded: " + aFile);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.exit(0);
        FilenameFileFilter ff = ImageFactory.getImageFactory().getFilter();
        for (int i = 0; i < files.length; ++i) {
            System.out.println(files[i]);
            if (ff.accept(files[i])) {
                System.out.println("Accepted");
            }
            if (files[i].isDirectory()) continue;
            System.out.println("Is File");
            String name = files[i].getName();
            System.out.println("name: " + name);
            name = name.toLowerCase();
            System.out.println("lowercase name: " + name);
            if (!name.endsWith(".jpg")) continue;
            System.out.println("jpg");
        }
    }

    public class TreeTotals {
        public int aggregateDirectoryCount = 0;
        public int aggregateTotalFileCount = 0;
        public int aggregateTargetFileCount = 0;
        public long aggregateTotalFileSize = 0L;
        public long aggregateTargetFileSize = 0L;
    }
}

