/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.sorter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.gerhardb.jibs.viewer.PicInfoDialogBase;
import org.gerhardb.jibs.viewer.shows.classic.SingleDrag;
import org.gerhardb.jibs.viewer.sorter.TileConstants;
import org.gerhardb.jibs.viewer.sorter.TilePanel;
import org.gerhardb.lib.dirtree.filelist.FileDrag;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.image.ImageFactory;

class Tile
extends JComponent
implements DragGestureListener,
DragSourceListener,
Transferable,
DropTargetListener,
MouseListener {
    private static final int PADDING = 5;
    private static final int PADDINGx2 = 10;
    private boolean iBeDraggedOver = false;
    File myFile;
    private BufferedImage myImage;
    private DragSource myDragSource = new DragSource();

    public Tile() {
        this(-1, null);
    }

    public Tile(int at, File file) {
        BufferedImage ezImage;
        this.myFile = file;
        super.setOpaque(false);
        super.setPreferredSize(TilePanel.clsTileSizeDim);
        super.addMouseListener(this);
        new DropTarget(this, this);
        TilePanel.clsTilePanel.add((Component)this, at);
        TilePanel.clsTilePanel.revalidate();
        if (this.myFile != null && (ezImage = ImageFactory.getImageFactory().getImageEZ(this.myFile)) != null) {
            int imgHeight = TilePanel.clsTileSize - 10;
            int imgWidth = TilePanel.clsTileSize - 10;
            this.myImage = ImageChangeUtil.fitAspectDown(ezImage, imgWidth, imgHeight);
        }
        this.myDragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    int getIndex() {
        Component[] tiles = TilePanel.clsTilePanel.getComponents();
        for (int i = 0; i < tiles.length; ++i) {
            if (tiles[i] != this) continue;
            return i;
        }
        return -1;
    }

    protected void paintComponent(Graphics g) {
        String tileIndex;
        Dimension textSize;
        Graphics2D g2 = (Graphics2D)g;
        if (this.iBeDraggedOver) {
            g.setColor(Color.pink);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (this.myFile == null) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (this.myImage == null) {
            g.setColor(Color.green);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.myImage != null) {
            int centerX = (super.getWidth() - this.myImage.getWidth()) / 2;
            int centerY = (super.getHeight() - this.myImage.getHeight()) / 2;
            g.drawImage(this.myImage, centerX, centerY, this);
        }
        if ((textSize = Tile.setFont(g, tileIndex = Integer.toString(this.getIndex() + 1), super.getWidth())).getWidth() > 0.0) {
            int textY = (int)(((double)super.getHeight() - textSize.getHeight()) / 2.0);
            FontMetrics fm = g.getFontMetrics();
            textY += fm.getAscent();
            g2.setPaint(Color.red);
        }
        g.dispose();
    }

    private static Dimension setFont(Graphics g, String msg, int box_width) {
        FontMetrics fm;
        int msg_width;
        int type_size = 40;
        int type_size_min = 4;
        do {
            Font f = new Font("Default", 0, type_size);
            g.setFont(f);
        } while ((msg_width = (fm = g.getFontMetrics()).stringWidth(msg)) >= box_width && (type_size -= 2) >= type_size_min);
        if (type_size < type_size_min) {
            return new Dimension(0, 0);
        }
        return new Dimension(msg_width, fm.getHeight());
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Cursor cursor = DragSource.DefaultLinkNoDrop;
        switch (dge.getDragAction()) {
            case 2: {
                cursor = DragSource.DefaultMoveDrop;
                break;
            }
            case 1: {
                cursor = DragSource.DefaultCopyDrop;
                break;
            }
            default: {
                return;
            }
        }
        this.myDragSource.startDrag(dge, cursor, this, this);
    }

    public Object getTransferData(DataFlavor flavor) {
        if (TileConstants.TILE_DATA_FLAVOR.equals(flavor)) {
            return this;
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return TileConstants.CLS_DATA_FLAVORS;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < TileConstants.CLS_DATA_FLAVORS.length; ++i) {
            if (!TileConstants.CLS_DATA_FLAVORS[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    private void evaluateDrag(DropTargetDragEvent event) {
        switch (event.getDropAction()) {
            case 1: 
            case 2: 
            case 3: {
                event.acceptDrag(3);
                this.iBeDraggedOver = true;
                super.repaint();
                break;
            }
            default: {
                this.iBeDraggedOver = false;
                super.repaint();
                event.rejectDrag();
            }
        }
    }

    public void dragEnter(DropTargetDragEvent event) {
        this.evaluateDrag(event);
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        this.evaluateDrag(event);
    }

    public void dragExit(DropTargetEvent dte) {
        this.iBeDraggedOver = false;
        super.repaint();
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent event) {
        switch (event.getDropAction()) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                event.rejectDrop();
                return;
            }
        }
        if (event.isLocalTransfer()) {
            if (event.isDataFlavorSupported(TileConstants.TILE_DATA_FLAVOR)) {
                System.out.println("Processing LOCAL Tile Drop");
                event.acceptDrop(event.getDropAction());
                this.processLocalTileDrag(event);
            } else if (event.isDataFlavorSupported(FileDrag.FILE_DRAG_DATA_FLAVOR)) {
                event.acceptDrop(event.getDropAction());
                this.processLocalFileDrag(event);
            } else if (event.isDataFlavorSupported(SingleDrag.SINGLE_DRAG_DATA_FLAVOR)) {
                System.out.println("Tile: Processing LOCAL Single Drop");
                event.acceptDrop(event.getDropAction());
                this.processLocalSingleDrag(event);
            }
        } else if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            event.acceptDrop(event.getDropAction());
            this.processFileList(event);
        }
        if (this.myFile == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TilePanel.clsHorizontalScrollBar.setValue(TilePanel.clsHorizontalScrollBar.getMaximum());
                }
            });
        }
        event.rejectDrop();
    }

    void processLocalTileDrag(DropTargetDropEvent event) {
        Transferable transfer = event.getTransferable();
        Object moveObj = null;
        try {
            moveObj = transfer.getTransferData(TileConstants.TILE_DATA_FLAVOR);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            event.dropComplete(false);
            return;
        }
        if (moveObj == null || !(moveObj instanceof Tile)) {
            event.dropComplete(false);
            return;
        }
        Tile tileDrag = (Tile)moveObj;
        new Tile(this.getIndex(), tileDrag.myFile);
        event.dropComplete(true);
        this.iBeDraggedOver = false;
        super.repaint();
    }

    void processLocalFileDrag(DropTargetDropEvent event) {
        Transferable transfer = event.getTransferable();
        Object moveObj = null;
        try {
            moveObj = transfer.getTransferData(FileDrag.FILE_DRAG_DATA_FLAVOR);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            event.dropComplete(false);
            return;
        }
        if (moveObj == null || !(moveObj instanceof FileDrag)) {
            event.dropComplete(false);
            return;
        }
        FileDrag fileDrag = (FileDrag)moveObj;
        List fileList = fileDrag.getFileList();
        Object[] loop = fileList.toArray();
        for (int i = 0; i < loop.length; ++i) {
            if (!(loop[i] instanceof File)) continue;
            new Tile(this.getIndex(), (File)loop[i]);
        }
        event.dropComplete(true);
        this.iBeDraggedOver = false;
        super.repaint();
    }

    void processLocalSingleDrag(DropTargetDropEvent event) {
        Transferable transfer = event.getTransferable();
        Object moveObj = null;
        try {
            moveObj = transfer.getTransferData(SingleDrag.SINGLE_DRAG_DATA_FLAVOR);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            event.dropComplete(false);
            return;
        }
        if (moveObj == null || !(moveObj instanceof SingleDrag)) {
            event.dropComplete(false);
            return;
        }
        SingleDrag singleDrag = (SingleDrag)moveObj;
        File file = singleDrag.getFileToTransfer();
        if (file != null) {
            new Tile(this.getIndex(), singleDrag.getFileToTransfer());
        }
        event.dropComplete(true);
        this.iBeDraggedOver = false;
        super.repaint();
        TilePanel.clsSortScreen.getScroller().refreshCurrentImage();
    }

    void processFileList(DropTargetDropEvent event) {
        Transferable transfer = event.getTransferable();
        Object moveObj = null;
        try {
            moveObj = transfer.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            event.dropComplete(false);
            return;
        }
        if (moveObj == null || !(moveObj instanceof List)) {
            event.dropComplete(false);
            return;
        }
        List fileList = (List)moveObj;
        Object[] loop = fileList.toArray();
        for (int i = 0; i < loop.length; ++i) {
            if (!(loop[i] instanceof File)) continue;
            new Tile(this.getIndex(), (File)loop[i]);
        }
        event.dropComplete(false);
        this.iBeDraggedOver = false;
        super.repaint();
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        if (this.myFile == null) {
            return;
        }
        if (event.getDropSuccess() && event.getDropAction() == 2) {
            TilePanel.clsTilePanel.remove(this);
            TilePanel.clsTilePanel.revalidate();
        }
        event.getDragSourceContext().setCursor(Cursor.getPredefinedCursor(0));
        TilePanel.clsSortScreen.getScroller().refreshCurrentImage();
    }

    public void dropActionChanged(DragSourceDragEvent event) {
        switch (event.getUserAction()) {
            case 2: {
                event.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                break;
            }
            case 1: {
                event.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
                break;
            }
        }
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void mouseClicked(MouseEvent event) {
        if (!(1 == event.getButton() && event.getClickCount() == 2 || 2 != event.getButton() && 3 != event.getButton() || this.myFile == null)) {
            PicInfoDialogBase info = new PicInfoDialogBase((Frame)TilePanel.clsSortScreen.getFrame(), TilePanel.clsSortScreen.getScroller());
            info.display(this.myFile, null, -1, -1, false);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

