/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.contact;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.contact.ContactSheetOptions;
import org.gerhardb.lib.image.ImageUtil;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.print.PageablePreviewer;
import org.gerhardb.lib.swing.GlassPane;
import org.gerhardb.lib.swing.JPanelRows;

public class ContactSheetSaveOptions {
    static final DecimalFormat FILE_COUNT_FORMAT = new DecimalFormat("#0000");
    JFormattedTextField myWidthFld;
    JFormattedTextField myHeightFld;
    JFormattedTextField myMarginFld;
    JTextField myNameFld;
    JTextField myDirFld;
    ContactSheetOptions myBase;
    private static final String WIDTH = "WIDTH";
    private static final String HEIGHT = "HEIGHT";
    private static final String MARGIN = "MARGIN";
    private static final String DIRECTORY = "DIRECTORY";
    private static final String NAME = "NAME";

    ContactSheetSaveOptions(ContactSheetOptions base) {
        this.myBase = base;
    }

    JPanel getPanel() {
        this.myWidthFld = new JFormattedTextField(new DecimalFormat("######"));
        this.myHeightFld = new JFormattedTextField(new DecimalFormat("######"));
        this.myMarginFld = new JFormattedTextField(new DecimalFormat("######"));
        this.myNameFld = new JTextField(10);
        this.myDirFld = new JTextField(40);
        JButton saveBtn = new JButton(Jibs.getString("save"));
        saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ContactSheetSaveOptions.this.save();
            }
        });
        JButton previewBtn = new JButton(Jibs.getString("preview"));
        previewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ContactSheetSaveOptions.this.saveOptions();
                JButton button = new JButton(Jibs.getString("save"));
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        ContactSheetSaveOptions.this.save();
                    }
                });
                JButton[] prtButtons = new JButton[]{button};
                new PageablePreviewer(ContactSheetSaveOptions.this.myBase.myContactSheet, prtButtons, ContactSheetSaveOptions.this.myBase.myContactSheet.getPreviewProgressBar(), false);
            }
        });
        JButton btnDir = new JButton("...");
        btnDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dir = ContactSheetSaveOptions.this.myDirFld.getText();
                if (dir == null) {
                    dir = System.getProperty("user.home");
                }
                dir = FileUtil.lookupDir(Jibs.getString("ContactSheetSaveOptions.5"), dir, ContactSheetSaveOptions.this.myBase.myFrame);
                ContactSheetSaveOptions.this.myDirFld.setText(dir);
            }
        });
        this.myWidthFld.setColumns(6);
        this.myHeightFld.setColumns(6);
        this.myMarginFld.setColumns(6);
        JPanelRows rtnMe = new JPanelRows();
        JPanel row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetSaveOptions.2") + Jibs.getString("colon") + "  "));
        row.add(this.myWidthFld);
        row.add(new JLabel(" " + Jibs.getString("ContactSheetSaveOptions.18") + Jibs.getString("colon") + " "));
        row.add(this.myHeightFld);
        row.add(new JLabel(" " + Jibs.getString("ContactSheetSaveOptions.22") + Jibs.getString("colon") + " "));
        row.add(this.myMarginFld);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetSaveOptions.25") + Jibs.getString("colon") + " "));
        row.add(this.myNameFld);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetSaveOptions.28") + Jibs.getString("colon") + " "));
        row.add(this.myDirFld);
        row.add(btnDir);
        row = rtnMe.nextRow(1);
        row.add(saveBtn);
        row.add(previewBtn);
        row.add(this.myBase.myCloseBtn);
        previewBtn.requestFocus();
        this.getOptions();
        JPanel bottomA = new JPanel(new BorderLayout());
        bottomA.add((Component)this.myBase.myContactSheet.getDirectoryProgress(), "Center");
        JPanel bottomB = new JPanel(new BorderLayout());
        bottomB.add((Component)this.myBase.myContactSheet.getProgressBar(), "Center");
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)bottomA, "Center");
        bottom.add((Component)bottomB, "South");
        rtnMe.add((Component)bottom, "South");
        return rtnMe;
    }

    void save() {
        this.saveOptions();
        Thread show = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean checkOverwrite = true;
                ContactSheetSaveOptions.this.myBase.myFrame.setCursor(Cursor.getPredefinedCursor(3));
                GlassPane eatMe = new GlassPane();
                eatMe.setGlassPane(ContactSheetSaveOptions.this.myBase.myFrame);
                try {
                    ContactSheetSaveOptions.this.myBase.myFrame.setCursor(Cursor.getPredefinedCursor(3));
                    String front = ContactSheetSaveOptions.this.myDirFld.getText() + System.getProperty("file.separator") + ContactSheetSaveOptions.this.myNameFld.getText() + "-";
                    int stop = ContactSheetSaveOptions.this.myBase.myContactSheet.getNumberOfPages() - 1;
                    for (int i = 0; i <= stop; ++i) {
                        String fileName = front + FILE_COUNT_FORMAT.format(i + 1) + ".jpg";
                        File file = new File(fileName);
                        if (file.exists() && checkOverwrite) {
                            int overwrite = JOptionPane.showConfirmDialog(ContactSheetSaveOptions.this.myBase.myFrame, Jibs.getString("ContactSheetSaveOptions.14"), Jibs.getString("ContactSheetSaveOptions.15"), 0);
                            if (overwrite == 1) {
                                return;
                            }
                            checkOverwrite = false;
                        }
                        System.out.println("Saving page " + i + " as " + file);
                        PageFormat pf = ContactSheetSaveOptions.this.myBase.myContactSheet.getPageFormat(i);
                        BufferedImage buff = new BufferedImage((int)pf.getWidth(), (int)pf.getHeight(), 1);
                        Graphics2D g2 = buff.createGraphics();
                        try {
                            ContactSheetSaveOptions.this.myBase.myContactSheet.print(g2, pf, i);
                            ImageUtil.saveJPEG(buff, 1.0f, file);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(ContactSheetSaveOptions.this.myBase.myFrame, ex.getMessage(), Jibs.getString("problem"), 0);
                            ContactSheetSaveOptions.this.myBase.myFrame.setCursor(Cursor.getPredefinedCursor(0));
                            eatMe.removeGlassPane();
                            return;
                        }
                    }
                }
                finally {
                    ContactSheetSaveOptions.this.myBase.myFrame.setCursor(Cursor.getPredefinedCursor(0));
                    eatMe.removeGlassPane();
                }
            }
        });
        show.start();
    }

    void getOptions() {
        this.myWidthFld.setText(Integer.toString(this.myBase.myPrefs.getInt(WIDTH, 640)));
        this.myHeightFld.setText(Integer.toString(this.myBase.myPrefs.getInt(HEIGHT, 480)));
        this.myMarginFld.setText(Integer.toString(this.myBase.myPrefs.getInt(MARGIN, 20)));
        this.myDirFld.setText(this.myBase.myPrefs.get(DIRECTORY, System.getProperty("user.home")));
        this.myNameFld.setText(this.myBase.myPrefs.get(NAME, "idx"));
    }

    void saveOptions() {
        this.myBase.iAmSaving = true;
        this.myBase.saveOptions();
        this.myBase.myPrefs.put(WIDTH, this.myWidthFld.getText());
        this.myBase.myPrefs.put(HEIGHT, this.myHeightFld.getText());
        this.myBase.myPrefs.put(MARGIN, this.myMarginFld.getText());
        this.myBase.myPrefs.put(DIRECTORY, this.myDirFld.getText());
        this.myBase.myPrefs.put(NAME, this.myNameFld.getText());
    }
}

