/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.contact;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.contact.CSO;
import org.gerhardb.jibs.viewer.contact.ContactSheet;
import org.gerhardb.jibs.viewer.contact.ContactSheetPrintOptions;
import org.gerhardb.jibs.viewer.contact.ContactSheetSaveOptions;
import org.gerhardb.jibs.viewer.contact.DirFiles;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.io.NoFiles;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.print.PrintableBase;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

public class ContactSheetOptions
implements ChangeListener,
CSO {
    public static final int SHOW_DIALOG = 0;
    public static final int SHOW_PREVIEW = 1;
    public static final int SHOW_PRINT = 2;
    static final String INSERT_DIR_NAME = "<@>";
    private static final String CT_USE_SELECTED = "CT_USE_SELECTED";
    private static final String CT_USE_ALL = "CT_USE_ALL";
    private static final String CT_USE_DIR = "CT_USE_DIR";
    static final String DEFAULT_TITLE = "Contact Sheet/Thumbnails";
    private static final String JIBS_WEB_SITE = "www.jibs.us";
    private static final String DEFAULT_LEFT_HEADER = Jibs.getString("ContactSheetOptions.0") + " " + "<%!>" + "-" + "<%@>";
    private static final String DEFAULT_RIGHT_HEADER = "<%%> " + Jibs.getString("ContactSheetOptions.126");
    File[] mySelectedFiles;
    File[] mySingleDirectoryFiles;
    DirFiles[] myPrintDirectoriesFiles;
    ContactSheetPrintOptions myPrintOptions;
    ContactSheetSaveOptions mySaveOptions;
    JTextField myDirFld = new JTextField(40);
    JButton myBtnDir = new JButton("...");
    JRadioButton myUseSelected = new JRadioButton(Jibs.getString("ContactSheetOptions.1"));
    JRadioButton myUseAll = new JRadioButton("Use all files currently shown in browser");
    JRadioButton myUseDirectory = new JRadioButton(Jibs.getString("ContactSheetOptions.11") + Jibs.getString("colon") + " ");
    JCheckBox myWalkTree = new JCheckBox(Jibs.getString("ContactSheetOptions.14"));
    JCheckBox myRepaginate = new JCheckBox(Jibs.getString("ContactSheetOptions.15"));
    JTabbedPane myTabs = new JTabbedPane();
    JTextField myHeader = new JTextField(50);
    JTextField myHeaderLeft = new JTextField(30);
    JTextField myHeaderRight = new JTextField(30);
    JTextField myFooter = new JTextField(50);
    JTextField myFooterLeft = new JTextField(30);
    JTextField myFooterRight = new JTextField(30);
    JComboBox myHeaderFont;
    JComboBox myFooterFont;
    JComboBox myPictureFont;
    JFormattedTextField myHeaderFontSize = new JFormattedTextField(new Integer(100));
    JFormattedTextField myFooterFontSize = new JFormattedTextField(new Integer(100));
    JFormattedTextField myPictureFontSize = new JFormattedTextField(new Integer(100));
    JLabel myDescription = new JLabel("");
    boolean iCountedFiles;
    String myLastDir;
    boolean myLastWalkTree;
    boolean myLastRepaginate;
    JFrame myParentFrame;
    JFrame myFrame;
    ContactSheet myContactSheet;
    JButton myCloseBtn;
    private JSlider myRowSlider = new JSlider(0, 1, 8, 4);
    private JSlider myColSlider = new JSlider(0, 1, 6, 3);
    private JSlider myFrameSlider = new JSlider(0, 0, 20, 1);
    private JSlider myShadowSlider = new JSlider(0, 0, 20, 0);
    private JLabel myFileCount = new JLabel();
    private JLabel myPageCount = new JLabel();
    private JCheckBox myShowPicCount = new JCheckBox(Jibs.getString("ContactSheetOptions.16"));
    private JCheckBox myShowLines = new JCheckBox(Jibs.getString("ContactSheetOptions.17"));
    private JCheckBox myShowFileName = new JCheckBox(Jibs.getString("ContactSheetOptions.18"));
    private JCheckBox myShowFileSize = new JCheckBox(Jibs.getString("ContactSheetOptions.19"));
    Color mySaveTextColor = Color.YELLOW;
    Color mySaveBackgroundColor = Color.BLACK;
    Color myPrintTextColor = Color.BLACK;
    Color myPrintBackgroundColor = Color.WHITE;
    JLabel mySaveSample = this.makeSample(Jibs.getString("ContactSheetOptions.20"));
    JLabel myPrintSample = this.makeSample(Jibs.getString("ContactSheetOptions.21"));
    Scroller myScroller;
    private static final String PREF_PATH = "/org/gerhardb/jibs/ContactSheetOptions";
    Preferences myPrefs;
    boolean iAmSaving;
    private static final String ROW_COUNT = "ROW_COUNT";
    private static final String COLUMN_COUNT = "COLUMN_COUNT";
    private static final String CT_FRAME_SIZE = "CT_FRAME_SIZE";
    private static final String CT_SHADOW_SIZE = "CT_SHADOW_SIZE";
    private static final String CSS_SHOW_PIC_NAME = "CSS_SHOW_PIC_NAME";
    private static final String CSS_SHOW_PIC_COUNT = "CSS_SHOW_PIC_COUNT";
    private static final String CSS_SHOW_PIC_SIZE = "CSS_SHOW_PIC_SIZE";
    private static final String CT_DIRECTORY = "CONTRACT_TREE_DIRECTORY";
    private static final String CT_WALK = "CONTRACT_TREE_WALK";
    private static final String CT_PAGINATE = "CONTRACT_TREE_PAGINATE";
    private static final String CT_HEADER = "CT_HEADER";
    private static final String CT_FOOTER = "CT_FOOTER";
    private static final String CT_R_FOOTER = "CT_R_FOOTER";
    private static final String CT_L_FOOTER = "CT_L_FOOTER";
    private static final String CT_R_HEADER = "CT_R_HEADER";
    private static final String CT_L_HEADER = "CT_L_HEADER";
    private static final String CT_PIC_FONT = "CT_PIC_FONT";
    private static final String CT_HEADER_FONT = "CT_HEADER_FONT";
    private static final String CT_FOOTER_FONT = "CT_FOOTER_FONT";
    private static final String CT_PIC_FONT_SIZE = "CT_PIC_FONT_SIZE";
    private static final String CT_HEADER_FONT_SIZE = "CT_HEADER_FONT_SIZE";
    private static final String CT_FOOTER_FONT_SIZE = "CT_FOOTER_FONT_SIZE";
    private static final String CT_SHOW_LINES = "CT_SHOW_LINES";
    private static final String CT_CLR_SAVE_TEXT = "CT_CLR_SAVE_TEXT";
    private static final String CT_CLR_SAVE_BACK = "CT_CLR_SAVE_BACK";
    private static final String CT_CLR_PRT_TEXT = "CT_CLR_PRT_TEXT";
    private static final String CT_CLR_PRT_BACK = "CT_CLR_PRT_BACK";

    public ContactSheetOptions(JFrame frame, File[] selectedFiles, int showOnTop, Scroller scroller) {
        this.myParentFrame = frame;
        this.myScroller = scroller;
        this.myPrefs = Preferences.userRoot().node(PREF_PATH);
        this.myContactSheet = new ContactSheet(this);
        this.myFrame = new JFrame(DEFAULT_TITLE);
        this.myFrame.setIconImage(Icons.icon(26).getImage());
        this.myCloseBtn = new JButton(Jibs.getString("close"));
        this.myCloseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ContactSheetOptions.this.exit();
            }
        });
        this.myFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ContactSheetOptions.this.exit();
            }
        });
        this.mySelectedFiles = selectedFiles == null ? new File[0] : selectedFiles;
        this.myPrintOptions = new ContactSheetPrintOptions(this);
        this.mySaveOptions = new ContactSheetSaveOptions(this);
        this.setContentPane(this.getPanel());
        this.iCountedFiles = false;
        this.setRowCol();
        switch (showOnTop) {
            case 1: {
                this.updatePictureList();
                this.myPrintOptions.preview();
                break;
            }
            case 2: {
                this.updatePictureList();
                this.myPrintOptions.print();
            }
        }
    }

    public Preferences getPreferences() {
        return this.myPrefs;
    }

    public String getHeader(int pageIndex) {
        return this.convert(pageIndex, this.myHeader.getText());
    }

    public String getHeaderLeft(int pageIndex) {
        return this.convert(pageIndex, this.myHeaderLeft.getText());
    }

    public String getHeaderRight(int pageIndex) {
        return this.convert(pageIndex, this.myHeaderRight.getText());
    }

    public String getFooter(int pageIndex) {
        return this.convert(pageIndex, this.myFooter.getText());
    }

    public String getFooterLeft(int pageIndex) {
        return this.convert(pageIndex, this.myFooterLeft.getText());
    }

    public String getFooterRight(int pageIndex) {
        return this.convert(pageIndex, this.myFooterRight.getText());
    }

    public int getPictureFontSize() {
        try {
            return Integer.parseInt(this.myPictureFontSize.getText());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 10;
        }
    }

    public int getHeaderFontSize() {
        try {
            return Integer.parseInt(this.myHeaderFontSize.getText());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 10;
        }
    }

    public int getFooterFontSize() {
        try {
            return Integer.parseInt(this.myFooterFontSize.getText());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 10;
        }
    }

    public String getHeaderFontFamily() {
        return this.myHeaderFont.getModel().getSelectedItem().toString();
    }

    public String getFooterFontFamily() {
        return this.myFooterFont.getModel().getSelectedItem().toString();
    }

    public String getPictureFontFamily() {
        return this.myPictureFont.getModel().getSelectedItem().toString();
    }

    public void showPageCount() {
        if (this.myContactSheet == null) {
            return;
        }
        this.myFileCount.setText(Integer.toString(this.myContactSheet.getFileCount()));
        this.myPageCount.setText(Integer.toString(this.myContactSheet.getNumberOfPages()));
    }

    public boolean numberPictures() {
        return this.myShowPicCount.isSelected();
    }

    public boolean showLines() {
        return this.myShowLines.isSelected();
    }

    public Color getTextColor() {
        if (this.iAmSaving) {
            return this.mySaveTextColor;
        }
        return this.myPrintTextColor;
    }

    public Color getBackgroundColor() {
        if (this.iAmSaving) {
            return this.mySaveBackgroundColor;
        }
        return this.myPrintBackgroundColor;
    }

    public boolean showPictureSize() {
        return this.myShowFileSize.isSelected();
    }

    public boolean showPictureName() {
        return this.myShowFileName.isSelected();
    }

    public int showPictureFrame() {
        return this.myFrameSlider.getValue();
    }

    public int showPictureShadow() {
        return this.myShadowSlider.getValue();
    }

    public void stateChanged(ChangeEvent e) {
        int currentTab = this.myTabs.getSelectedIndex();
        if (currentTab == 0) {
            return;
        }
        this.updatePictureList();
    }

    void updatePictureList() {
        this.myContactSheet.flushBuffer();
        if (this.myUseSelected.isSelected()) {
            this.myContactSheet.setFiles(this.mySelectedFiles);
        } else if (this.myUseAll.isSelected()) {
            this.myContactSheet.setFiles(this.myScroller.getPictureFiles());
        } else {
            boolean fileCountingNeeded = false;
            if (!this.iCountedFiles) {
                fileCountingNeeded = true;
                this.iCountedFiles = true;
            } else if (this.myLastDir == null) {
                fileCountingNeeded = true;
            } else if (!this.myLastDir.equals(this.myDirFld.getText())) {
                fileCountingNeeded = true;
            } else if (this.myLastWalkTree != this.myWalkTree.isSelected()) {
                fileCountingNeeded = true;
            } else if (this.myLastRepaginate != this.myRepaginate.isSelected()) {
                fileCountingNeeded = true;
            }
            if (fileCountingNeeded) {
                this.myFrame.setCursor(Cursor.getPredefinedCursor(3));
                this.myLastDir = this.myDirFld.getText();
                this.myLastWalkTree = this.myWalkTree.isSelected();
                this.myLastRepaginate = this.myRepaginate.isSelected();
                File treeRoot = new File(this.myLastDir);
                if (!treeRoot.exists()) {
                    JOptionPane.showMessageDialog(this.myFrame, Jibs.getString("ContactSheetOptions.22") + Jibs.getString("colon") + " " + this.myLastDir, Jibs.getString("problem"), 0);
                    this.iCountedFiles = false;
                    this.myTabs.setSelectedIndex(0);
                    return;
                }
                if (this.myWalkTree.isSelected() && this.myRepaginate.isSelected()) {
                    this.mySingleDirectoryFiles = null;
                    this.myPrintDirectoriesFiles = this.getDirFiles();
                } else {
                    this.mySingleDirectoryFiles = this.getFiles();
                    this.myPrintDirectoriesFiles = null;
                }
                this.myFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (this.myPrintDirectoriesFiles == null) {
                this.myContactSheet.setFiles(this.mySingleDirectoryFiles);
            } else {
                this.myContactSheet.setDirectories(this.myPrintDirectoriesFiles);
            }
        }
    }

    private String convert(int pageIndex, String text) {
        String rtnMe = this.myContactSheet.convert(text, pageIndex);
        if (rtnMe.indexOf(INSERT_DIR_NAME) > -1) {
            String currDir = this.currentDirectory(pageIndex).replace('\\', '/');
            rtnMe = rtnMe.replaceAll(INSERT_DIR_NAME, currDir);
        }
        return rtnMe;
    }

    private String currentDirectory(int pageIndex) {
        if (this.myUseSelected.isSelected()) {
            return this.myScroller.getDescription();
        }
        if (!this.myWalkTree.isSelected()) {
            return this.myDirFld.getText();
        }
        return this.myContactSheet.getDirectory(pageIndex);
    }

    DirFiles[] getDirFiles() {
        DirFiles[] rtnMe = null;
        File treeRoot = new File(this.myLastDir);
        if (treeRoot.isFile()) {
            File[] fArray = new File[1];
            rtnMe = new DirFiles[]{new DirFiles(treeRoot, fArray)};
            return rtnMe;
        }
        ArrayList<File> directories = new ArrayList<File>(1000);
        directories.add(treeRoot);
        this.addDirectoriesRecursive(directories, treeRoot);
        rtnMe = new DirFiles[directories.size()];
        for (int i = 0; i < rtnMe.length; ++i) {
            File aDir = (File)directories.get(i);
            File[] someFiles = aDir.listFiles(ImageFactory.getImageFactory().getFilter());
            rtnMe[i] = new DirFiles(aDir, someFiles);
        }
        return rtnMe;
    }

    File[] getFiles() {
        File[] rtnMe = null;
        File treeRoot = new File(this.myLastDir);
        if (treeRoot.isFile()) {
            rtnMe = new File[]{treeRoot};
        } else if (this.myLastWalkTree) {
            ArrayList<File> directories = new ArrayList<File>(1000);
            directories.add(treeRoot);
            this.addDirectoriesRecursive(directories, treeRoot);
            ArrayList<File> files = new ArrayList<File>(10000);
            Iterator loop = directories.iterator();
            while (loop.hasNext()) {
                File aDir = (File)loop.next();
                File[] someFiles = aDir.listFiles(ImageFactory.getImageFactory().getFilter());
                for (int i = 0; i < someFiles.length; ++i) {
                    files.add(someFiles[i]);
                }
            }
            rtnMe = new File[files.size()];
            files.toArray(rtnMe);
        } else {
            rtnMe = treeRoot.listFiles(ImageFactory.getImageFactory().getFilter());
        }
        return rtnMe;
    }

    void addDirectoriesRecursive(ArrayList directories, File root) {
        int i;
        File[] someDirs = root.listFiles(NoFiles.NO_FILES);
        for (i = 0; i < someDirs.length; ++i) {
            directories.add(someDirs[i]);
        }
        for (i = 0; i < someDirs.length; ++i) {
            this.addDirectoriesRecursive(directories, someDirs[i]);
        }
    }

    Container getPanel() {
        this.myBtnDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dir = ContactSheetOptions.this.myDirFld.getText();
                if (dir == null) {
                    dir = System.getProperty("user.home");
                }
                dir = FileUtil.lookupDir(Jibs.getString("ContactSheetOptions.25"), dir, ContactSheetOptions.this.myFrame);
                ContactSheetOptions.this.myDirFld.setText(dir);
            }
        });
        this.myWalkTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContactSheetOptions.this.myRepaginate.setEnabled(ContactSheetOptions.this.myWalkTree.isSelected());
            }
        });
        this.myUseSelected.setSelected(true);
        this.myUseAll.setSelected(false);
        this.myUseDirectory.setSelected(false);
        ButtonGroup aGroup = new ButtonGroup();
        aGroup.add(this.myUseAll);
        aGroup.add(this.myUseSelected);
        aGroup.add(this.myUseDirectory);
        String description = this.myScroller.getDescription();
        this.myDescription.setText(description);
        this.myUseSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContactSheetOptions.this.setButtons();
            }
        });
        this.myUseAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContactSheetOptions.this.setButtons();
            }
        });
        this.myUseDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContactSheetOptions.this.setButtons();
            }
        });
        JPanelRows filesPanel = new JPanelRows();
        JPanel row = filesPanel.topRow();
        row.add(this.myUseSelected);
        row = filesPanel.nextRow();
        row.add(this.myUseAll);
        row.add(this.myDescription);
        row = filesPanel.nextRow();
        row.add(this.myUseDirectory);
        row.add(this.myDirFld);
        row.add(this.myBtnDir);
        row = filesPanel.nextRow();
        row.add(this.myUseDirectory);
        row.add(this.myDirFld);
        row.add(this.myBtnDir);
        row = filesPanel.nextRow();
        row.add(this.myWalkTree);
        row.add(this.myRepaginate);
        JPanel savePanel = this.mySaveOptions.getPanel();
        JPanel printPanel = this.myPrintOptions.getPanel();
        this.myTabs.addChangeListener(this);
        this.myTabs.addTab(Jibs.getString("ContactSheetOptions.26"), filesPanel);
        this.myTabs.addTab(Jibs.getString("ContactSheetOptions.27"), this.getSliders());
        this.myTabs.addTab(Jibs.getString("ContactSheetOptions.28"), this.getOptionsPanel());
        this.myTabs.addTab(Jibs.getString("ContactSheetOptions.29"), this.getFontsPanel());
        this.myTabs.addTab(Jibs.getString("ContactSheetOptions.30"), this.getColorsPanel());
        this.myTabs.addTab(Jibs.getString("save"), savePanel);
        this.myTabs.addTab(Jibs.getString("print"), printPanel);
        JPanel rtnMe = new JPanel(new BorderLayout());
        rtnMe.add((Component)this.myTabs, "Center");
        rtnMe.add((Component)this.myCloseBtn, "South");
        this.getOptions();
        this.setButtons();
        return rtnMe;
    }

    JPanel getSliders() {
        this.myRowSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ContactSheetOptions.this.setRowCol();
            }
        });
        this.myColSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ContactSheetOptions.this.setRowCol();
            }
        });
        this.myShowFileName.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ContactSheetOptions.this.myShowFileName.isSelected()) {
                    ContactSheetOptions.this.myShowPicCount.setEnabled(true);
                } else {
                    ContactSheetOptions.this.myShowPicCount.setEnabled(false);
                }
            }
        });
        this.myShowPicCount.setToolTipText(Jibs.getString("ContactSheetOptions.33"));
        this.myRowSlider.setSnapToTicks(true);
        this.myRowSlider.setPaintLabels(true);
        this.myRowSlider.setPaintTicks(true);
        this.myRowSlider.setMajorTickSpacing(1);
        this.myColSlider.setSnapToTicks(true);
        this.myColSlider.setPaintLabels(true);
        this.myColSlider.setPaintTicks(true);
        this.myColSlider.setMajorTickSpacing(1);
        this.myFrameSlider.setSnapToTicks(true);
        this.myFrameSlider.setPaintLabels(true);
        this.myFrameSlider.setPaintTicks(true);
        this.myFrameSlider.setMajorTickSpacing(1);
        this.myShadowSlider.setSnapToTicks(true);
        this.myShadowSlider.setPaintLabels(true);
        this.myShadowSlider.setPaintTicks(true);
        this.myShadowSlider.setMajorTickSpacing(1);
        JPanelRows rtnMe = new JPanelRows();
        JPanel row = rtnMe.topRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.6")));
        row.add(this.myRowSlider);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.7")));
        row.add(this.myColSlider);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.8") + Jibs.getString("colon") + " "));
        row.add(this.myFileCount);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.9") + Jibs.getString("colon") + " "));
        row.add(this.myPageCount);
        row = rtnMe.nextRow();
        row.add(this.myShowFileName);
        row.add(this.myShowPicCount);
        row = rtnMe.nextRow();
        row.add(this.myShowFileSize);
        row = rtnMe.nextRow(new BorderLayout());
        row.add((Component)new JLabel("Size of Frame    "), "West");
        row.add((Component)this.myFrameSlider, "Center");
        row = rtnMe.nextRow(new BorderLayout());
        row.add((Component)new JLabel("Size of Shadow"), "West");
        row.add((Component)this.myShadowSlider, "Center");
        return rtnMe;
    }

    void setRowCol() {
        this.myContactSheet.setColRow(this.myColSlider.getValue(), this.myRowSlider.getValue());
    }

    void setButtons() {
        this.myDirFld.setEnabled(false);
        this.myBtnDir.setEnabled(false);
        this.myWalkTree.setEnabled(false);
        this.myRepaginate.setEnabled(false);
        if (this.myUseDirectory.isSelected()) {
            this.myDirFld.setEnabled(true);
            this.myBtnDir.setEnabled(true);
            this.myWalkTree.setEnabled(true);
            this.myRepaginate.setEnabled(this.myWalkTree.isSelected());
        }
    }

    void getOptions() {
        this.myRowSlider.setValue(this.myPrefs.getInt(ROW_COUNT, 4));
        this.myColSlider.setValue(this.myPrefs.getInt(COLUMN_COUNT, 3));
        this.myFrameSlider.setValue(this.myPrefs.getInt(CT_FRAME_SIZE, 1));
        this.myShadowSlider.setValue(this.myPrefs.getInt(CT_SHADOW_SIZE, 0));
        this.myShowFileName.setSelected(this.myPrefs.getBoolean(CSS_SHOW_PIC_NAME, false));
        this.myShowPicCount.setSelected(this.myPrefs.getBoolean(CSS_SHOW_PIC_COUNT, false));
        this.myShowFileSize.setSelected(this.myPrefs.getBoolean(CSS_SHOW_PIC_SIZE, false));
        this.myDirFld.setText(this.myPrefs.get(CT_DIRECTORY, System.getProperty("user.home")));
        this.myWalkTree.setSelected(this.myPrefs.getBoolean(CT_WALK, false));
        this.myRepaginate.setSelected(this.myPrefs.getBoolean(CT_PAGINATE, true));
        this.myRepaginate.setEnabled(this.myWalkTree.isSelected());
        this.myHeader.setText(this.myPrefs.get(CT_HEADER, INSERT_DIR_NAME));
        this.myHeaderLeft.setText(this.myPrefs.get(CT_L_HEADER, ""));
        this.myHeaderRight.setText(this.myPrefs.get(CT_R_HEADER, ""));
        this.myFooter.setText(this.myPrefs.get(CT_FOOTER, PrintableBase.DEFAULT_FOOTER));
        this.myFooterLeft.setText(this.myPrefs.get(CT_L_FOOTER, Jibs.getString("PrintableBase.3")));
        this.myFooterRight.setText(this.myPrefs.get(CT_R_FOOTER, JIBS_WEB_SITE));
        this.myShowLines.setSelected(this.myPrefs.getBoolean(CT_SHOW_LINES, true));
        this.myHeaderFont.getModel().setSelectedItem(this.myPrefs.get(CT_HEADER_FONT, Jibs.getString("arial")));
        this.myFooterFont.getModel().setSelectedItem(this.myPrefs.get(CT_FOOTER_FONT, Jibs.getString("arial")));
        this.myPictureFont.getModel().setSelectedItem(this.myPrefs.get(CT_PIC_FONT, Jibs.getString("arial")));
        this.myHeaderFontSize.setText(this.myPrefs.get(CT_HEADER_FONT_SIZE, "10"));
        this.myFooterFontSize.setText(this.myPrefs.get(CT_FOOTER_FONT_SIZE, "10"));
        this.myPictureFontSize.setText(this.myPrefs.get(CT_PIC_FONT_SIZE, "10"));
        this.mySaveTextColor = SwingUtils.StringToColor(this.myPrefs.get(CT_CLR_SAVE_TEXT, "0,0,255,255"));
        this.mySaveBackgroundColor = SwingUtils.StringToColor(this.myPrefs.get(CT_CLR_SAVE_BACK, "0,0,0,255"));
        this.myPrintTextColor = SwingUtils.StringToColor(this.myPrefs.get(CT_CLR_PRT_TEXT, "0,0,0,255"));
        this.myPrintBackgroundColor = SwingUtils.StringToColor(this.myPrefs.get(CT_CLR_PRT_BACK, "255,255,255,255"));
        this.mySaveSample.setForeground(this.mySaveTextColor);
        this.mySaveSample.setBackground(this.mySaveBackgroundColor);
        this.myPrintSample.setForeground(this.myPrintTextColor);
        this.myPrintSample.setBackground(this.myPrintBackgroundColor);
    }

    void saveOptions() {
        this.myPrefs.putInt(ROW_COUNT, this.myRowSlider.getValue());
        this.myPrefs.putInt(COLUMN_COUNT, this.myColSlider.getValue());
        this.myPrefs.putInt(CT_FRAME_SIZE, this.myFrameSlider.getValue());
        this.myPrefs.putInt(CT_SHADOW_SIZE, this.myShadowSlider.getValue());
        this.myPrefs.putBoolean(CSS_SHOW_PIC_NAME, this.myShowFileName.isSelected());
        this.myPrefs.putBoolean(CSS_SHOW_PIC_COUNT, this.myShowPicCount.isSelected());
        this.myPrefs.putBoolean(CSS_SHOW_PIC_SIZE, this.myShowFileSize.isSelected());
        this.myPrefs.put(CT_DIRECTORY, this.myDirFld.getText());
        this.myPrefs.putBoolean(CT_WALK, this.myWalkTree.isSelected());
        this.myPrefs.putBoolean(CT_PAGINATE, this.myRepaginate.isSelected());
        this.myPrefs.putBoolean(CT_USE_SELECTED, this.myUseSelected.isSelected());
        this.myPrefs.putBoolean(CT_USE_DIR, this.myUseDirectory.isSelected());
        this.myPrefs.putBoolean(CT_USE_ALL, this.myUseAll.isSelected());
        this.myPrefs.put(CT_HEADER, this.myHeader.getText());
        this.myPrefs.put(CT_L_HEADER, this.myHeaderLeft.getText());
        this.myPrefs.put(CT_R_HEADER, this.myHeaderRight.getText());
        this.myPrefs.put(CT_FOOTER, this.myFooter.getText());
        this.myPrefs.put(CT_L_FOOTER, this.myFooterLeft.getText());
        this.myPrefs.put(CT_R_FOOTER, this.myFooterRight.getText());
        this.myPrefs.putBoolean(CT_SHOW_LINES, this.myShowLines.isSelected());
        this.myPrefs.put(CT_HEADER_FONT, this.myHeaderFont.getModel().getSelectedItem().toString());
        this.myPrefs.put(CT_FOOTER_FONT, this.myFooterFont.getModel().getSelectedItem().toString());
        this.myPrefs.put(CT_PIC_FONT, this.myPictureFont.getModel().getSelectedItem().toString());
        this.myPrefs.put(CT_HEADER_FONT_SIZE, this.myHeaderFontSize.getText());
        this.myPrefs.put(CT_FOOTER_FONT_SIZE, this.myFooterFontSize.getText());
        this.myPrefs.put(CT_PIC_FONT_SIZE, this.myPictureFontSize.getText());
        this.myPrefs.put(CT_CLR_SAVE_TEXT, SwingUtils.ColorToString(this.mySaveTextColor));
        this.myPrefs.put(CT_CLR_SAVE_BACK, SwingUtils.ColorToString(this.mySaveBackgroundColor));
        this.myPrefs.put(CT_CLR_PRT_TEXT, SwingUtils.ColorToString(this.myPrintTextColor));
        this.myPrefs.put(CT_CLR_PRT_BACK, SwingUtils.ColorToString(this.myPrintBackgroundColor));
    }

    void setContentPane(Container panel) {
        this.myFrame.setContentPane(panel);
        this.myFrame.pack();
        SwingUtils.centerOnScreen(this.myFrame);
        this.myFrame.setVisible(true);
    }

    void exit() {
        this.saveOptions();
        try {
            this.myPrefs.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myFrame.dispose();
        if (this.myParentFrame == null) {
            System.exit(0);
        }
    }

    JPanel getOptionsPanel() {
        JButton defaultBtn = new JButton(Jibs.getString("ContactSheetOptions.48"));
        defaultBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ContactSheetOptions.this.myHeader.setText(ContactSheetOptions.INSERT_DIR_NAME);
                ContactSheetOptions.this.myHeaderLeft.setText(DEFAULT_LEFT_HEADER);
                ContactSheetOptions.this.myHeaderRight.setText(DEFAULT_RIGHT_HEADER);
                ContactSheetOptions.this.myFooter.setText(PrintableBase.DEFAULT_FOOTER);
                ContactSheetOptions.this.myFooterLeft.setText(Jibs.getString("PrintableBase.3"));
                ContactSheetOptions.this.myFooterRight.setText(ContactSheetOptions.JIBS_WEB_SITE);
            }
        });
        JPanelRows topWest = new JPanelRows();
        JPanel row = topWest.topRow();
        row.add(this.myShowLines);
        row = topWest.nextRow();
        row.add(defaultBtn);
        JPanelRows topEast = new JPanelRows();
        row = topEast.topRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.99") + " " + "<#>" + " " + Jibs.getString("ContactSheetOptions.102")));
        row = topEast.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.103") + " " + "<##>" + " " + Jibs.getString("ContactSheetOptions.106")));
        row = topEast.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.107") + " " + INSERT_DIR_NAME + " " + Jibs.getString("ContactSheetOptions.110")));
        row = topEast.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.107") + " " + "<%!>" + " " + Jibs.getString("ContactSheetOptions.120")));
        row = topEast.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.107") + " " + "<%@>" + " " + Jibs.getString("ContactSheetOptions.121")));
        row = topEast.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.107") + " " + "<%%>" + " " + Jibs.getString("ContactSheetOptions.122")));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)topWest, "West");
        top.add((Component)topEast, "East");
        JPanelRows rtnMe = new JPanelRows();
        row = rtnMe.topRow();
        row.add(top);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.58")));
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.111") + Jibs.getString("colon") + "   "));
        row.add(this.myHeaderLeft);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.60") + Jibs.getString("colon") + " "));
        row.add(this.myHeader);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.63") + Jibs.getString("colon") + " "));
        row.add(this.myHeaderRight);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.66")));
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.114") + Jibs.getString("colon") + "     "));
        row.add(this.myFooterLeft);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.68") + Jibs.getString("colon") + " "));
        row.add(this.myFooter);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.117") + Jibs.getString("colon") + "   "));
        row.add(this.myFooterRight);
        return rtnMe;
    }

    JPanel getFontsPanel() {
        final JTextField myHeaderSample = new JTextField(Jibs.getString("ContactSheetOptions.72"));
        myHeaderSample.setEditable(false);
        myHeaderSample.setBorder(null);
        final JTextField myFooterSample = new JTextField(Jibs.getString("ContactSheetOptions.73"));
        myFooterSample.setEditable(false);
        myFooterSample.setBorder(null);
        final JTextField myPictureSample = new JTextField(Jibs.getString("ContactSheetOptions.74"));
        myPictureSample.setEditable(false);
        myPictureSample.setBorder(null);
        this.myHeaderFontSize.setColumns(4);
        this.myFooterFontSize.setColumns(4);
        this.myPictureFontSize.setColumns(4);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        this.myHeaderFont = new JComboBox<String>(fonts);
        this.myFooterFont = new JComboBox<String>(fonts);
        this.myPictureFont = new JComboBox<String>(fonts);
        FontCellRenderer renderer = new FontCellRenderer(fonts);
        this.myHeaderFont.setRenderer(renderer);
        this.myFooterFont.setRenderer(renderer);
        this.myPictureFont.setRenderer(renderer);
        this.myHeaderFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String fontFamily = ContactSheetOptions.this.myHeaderFont.getModel().getSelectedItem().toString();
                myHeaderSample.setFont(new Font(fontFamily, 0, 14));
            }
        });
        this.myFooterFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String fontFamily = ContactSheetOptions.this.myFooterFont.getModel().getSelectedItem().toString();
                myFooterSample.setFont(new Font(fontFamily, 0, 14));
            }
        });
        this.myPictureFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String fontFamily = ContactSheetOptions.this.myPictureFont.getModel().getSelectedItem().toString();
                myPictureSample.setFont(new Font(fontFamily, 0, 14));
            }
        });
        JPanelRows rtnMe = new JPanelRows();
        JPanel row = rtnMe.topRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.75") + Jibs.getString("colon") + " "));
        row.add(this.myHeaderFont);
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.78") + Jibs.getString("colon") + " "));
        row.add(this.myHeaderFontSize);
        row.add(myHeaderSample);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.81") + Jibs.getString("colon") + " "));
        row.add(this.myPictureFont);
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.84") + Jibs.getString("colon") + " "));
        row.add(this.myPictureFontSize);
        row.add(myPictureSample);
        row = rtnMe.nextRow();
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.87") + Jibs.getString("colon") + "   "));
        row.add(this.myFooterFont);
        row.add(new JLabel(Jibs.getString("ContactSheetOptions.88") + Jibs.getString("colon") + " "));
        row.add(this.myFooterFontSize);
        row.add(myFooterSample);
        return rtnMe;
    }

    JPanel getColorsPanel() {
        final JRadioButton saveText = new JRadioButton(Jibs.getString("ContactSheetOptions.91"));
        final JRadioButton saveBackground = new JRadioButton(Jibs.getString("ContactSheetOptions.92"));
        final JRadioButton printText = new JRadioButton(Jibs.getString("ContactSheetOptions.93"));
        final JRadioButton printBackground = new JRadioButton(Jibs.getString("ContactSheetOptions.94"));
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(saveText);
        bGroup.add(saveBackground);
        bGroup.add(printText);
        bGroup.add(printBackground);
        saveText.setSelected(true);
        final JColorChooser jcc = new JColorChooser(Color.WHITE);
        jcc.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Color newColor = jcc.getColor();
                if (saveText.isSelected()) {
                    ContactSheetOptions.this.mySaveSample.setForeground(newColor);
                    ContactSheetOptions.this.mySaveTextColor = newColor;
                } else if (saveBackground.isSelected()) {
                    ContactSheetOptions.this.mySaveSample.setBackground(newColor);
                    ContactSheetOptions.this.mySaveBackgroundColor = newColor;
                } else if (printText.isSelected()) {
                    ContactSheetOptions.this.myPrintSample.setForeground(newColor);
                    ContactSheetOptions.this.myPrintTextColor = newColor;
                } else if (printBackground.isSelected()) {
                    ContactSheetOptions.this.myPrintSample.setBackground(newColor);
                    ContactSheetOptions.this.myPrintBackgroundColor = newColor;
                }
            }
        });
        jcc.setPreviewPanel(new JPanel());
        jcc.setBorder(BorderFactory.createTitledBorder(Jibs.getString("ContactSheetOptions.96")));
        JPanelRows samples = new JPanelRows();
        JPanel row = samples.topRow();
        row.add(saveText);
        row = samples.nextRow();
        row.add(saveBackground);
        row = samples.nextRow();
        row.add(this.mySaveSample);
        row = samples.nextRow();
        row.add(printText);
        row = samples.nextRow();
        row.add(printBackground);
        row = samples.nextRow();
        row.add(this.myPrintSample);
        JPanel rtnMe = new JPanel(new BorderLayout());
        rtnMe.add((Component)samples, "West");
        rtnMe.add((Component)jcc, "East");
        return rtnMe;
    }

    JLabel makeSample(String text) {
        Dimension dim = new Dimension(180, 40);
        JLabel rtnMe = new JLabel(text);
        rtnMe.setPreferredSize(dim);
        rtnMe.setMinimumSize(dim);
        rtnMe.setHorizontalAlignment(0);
        rtnMe.setOpaque(true);
        rtnMe.setBackground(Color.WHITE);
        rtnMe.setForeground(Color.BLACK);
        rtnMe.setFont(new Font(Jibs.getString("arial"), 1, 18));
        return rtnMe;
    }

    public static void main(String[] args) {
        try {
            File dir = new File("D:/testpics/delete");
            new ContactSheetOptions(null, dir.listFiles(), 1, new Scroller());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class FontCellRenderer
    extends JLabel
    implements ListCellRenderer {
        String[] myFonts;

        public FontCellRenderer(String[] fonts) {
            this.myFonts = fonts;
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(220, 20));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            if (index > -1) {
                this.setFont(new Font(this.myFonts[index], 0, 16));
            }
            return this;
        }
    }
}

