/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.PicInfoExif;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.swing.SwingUtils;

public class PicInfoDialogBase
extends JDialog {
    PicInfoExif myPicInfoExif;
    private JButton myCloseBtn = new JButton(Jibs.getString("ok"));
    protected boolean isSlideShowRunning;
    Scroller myScroller;

    public PicInfoDialogBase(Frame owner, Scroller scroller) {
        super(owner, Jibs.getString("PicInfoDialog.1"), true);
        this.myScroller = scroller;
    }

    public void display(File file, JComponent picturePanel, int displayInfoWidth, int displayInfoHeight, boolean showDisplayInfo) {
        this.myPicInfoExif = new PicInfoExif(file, picturePanel, displayInfoWidth, displayInfoHeight, showDisplayInfo, this.myScroller);
        this.isSlideShowRunning = this.myScroller.isSlideShowRunning();
        this.myScroller.stopSlideShow();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PicInfoDialogBase.this.close();
            }
        });
        this.myCloseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PicInfoDialogBase.this.close();
            }
        });
        class Dismiss
        extends AbstractAction {
            Dismiss() {
                super("dismiss");
            }

            public void actionPerformed(ActionEvent e) {
                PicInfoDialogBase.this.close();
            }
        }
        Dismiss dismiss = new Dismiss();
        String actionID = "dismiss";
        this.myCloseBtn.getActionMap().put(actionID, dismiss);
        InputMap map = this.myCloseBtn.getInputMap(2);
        map.put(KeyStroke.getKeyStroke("CANCEL"), actionID);
        map.put(KeyStroke.getKeyStroke("ENTER"), actionID);
        this.setSize(new Dimension(600, 430));
        this.getContentPane().add(this.setUpScreen());
        this.setUpMenus();
        this.setSize(640, 480);
        SwingUtils.centerOnScreen(this);
        this.myCloseBtn.requestFocus();
        this.setVisible(true);
    }

    protected JButton[] getToolBarButtons() {
        return new JButton[0];
    }

    private Component setUpScreen() {
        JToolBar btnRows = new JToolBar();
        btnRows.setFloatable(false);
        btnRows.add(this.myCloseBtn);
        JButton[] toolBarBtns = this.getToolBarButtons();
        for (int i = 0; i < toolBarBtns.length; ++i) {
            btnRows.add(toolBarBtns[i]);
        }
        JPanel rtnMe = this.myPicInfoExif.makeBorderPanel();
        rtnMe.add((Component)btnRows, "South");
        return new JScrollPane(rtnMe);
    }

    private void setUpMenus() {
        JMenuItem menuFileClose = new JMenuItem(Jibs.getString("close"));
        menuFileClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PicInfoDialogBase.this.dispose();
            }
        });
        JMenu menuFile = new JMenu(Jibs.getString("file"));
        menuFile.add(menuFileClose);
        JMenuBar menu = new JMenuBar();
        menu.add(menuFile);
        this.setJMenuBar(menu);
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
        if (this.isSlideShowRunning) {
            this.myScroller.startSlideShow(ViewerPreferences.continuousShow());
        } else {
            this.myScroller.stopSlideShow();
        }
    }
}

