/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

public class CheckSumChecker
extends JFrame {
    private static final String LAST_FILE = "LastFile";
    private static final String ALGORITHM = "Algorithm";
    private static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/util/CheckSumChecker");
    JTextField myFileName = new JTextField(60);
    JTextField myDownloadedHash = new JTextField(60);
    JLabel myComputedHash = new JLabel("     ");
    JLabel myResults = new JLabel("     ");
    JComboBox myAlgorithm = new JComboBox();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public CheckSumChecker() {
        super("Check Sum Checker");
        this.layoutComponents();
        this.myFileName.setText(clsPrefs.get(LAST_FILE, null));
        this.setIconImage(Icons.icon(26).getImage());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CheckSumChecker.this.pack();
                CheckSumChecker.this.setVisible(true);
                SwingUtils.centerOnScreen(CheckSumChecker.this);
            }
        });
    }

    private void layoutComponents() {
        this.setSize(new Dimension(600, 600));
        this.myAlgorithm.addItem("MD2");
        this.myAlgorithm.addItem("MD5");
        this.myAlgorithm.addItem("SHA-1");
        this.myAlgorithm.addItem("SHA-256");
        this.myAlgorithm.addItem("SHA-384");
        this.myAlgorithm.addItem("SHA-512");
        this.myAlgorithm.setEditable(false);
        this.myAlgorithm.setSelectedItem(clsPrefs.get(ALGORITHM, "MD2"));
        JButton goBtn = new JButton("Compute Hash");
        goBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CheckSumChecker.this.go();
            }
        });
        JButton fileBtn = new JButton("...");
        fileBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CheckSumChecker.this.selectFile();
            }
        });
        JButton compareBtn = new JButton("Compare");
        compareBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CheckSumChecker.this.checkHashes();
            }
        });
        JPanelRows topPanel = new JPanelRows(1);
        JPanel aRow = topPanel.topRow();
        aRow.add(new JLabel("File: "));
        aRow.add(this.myFileName);
        aRow.add(fileBtn);
        aRow = topPanel.nextRow();
        aRow.add(this.myAlgorithm);
        aRow.add(goBtn);
        aRow = topPanel.nextRow();
        aRow.add(this.myComputedHash);
        aRow = topPanel.nextRow();
        aRow.add(new JLabel("Hash to compare: "));
        aRow.add(this.myDownloadedHash);
        aRow = topPanel.nextRow();
        aRow.add(compareBtn);
        aRow = topPanel.nextRow();
        aRow.add(this.myResults);
        this.setContentPane(topPanel);
    }

    void selectFile() {
        File picked;
        JFileChooserExtra chooser = new JFileChooserExtra(clsPrefs.get(LAST_FILE, null));
        chooser.setDialogTitle(Jibs.getString("CheckSumChecker.15"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setSaveName("CheckSumChecker", "DirectoryTreeList.txt");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (picked = chooser.getSelectedFile()) != null) {
            String fileName = picked.toString();
            if (!fileName.contains(".")) {
                fileName = fileName + ".txt";
            }
            this.myFileName.setText(fileName);
            try {
                clsPrefs.put(LAST_FILE, picked.toString());
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void go() {
        String algorithm = this.myAlgorithm.getSelectedItem().toString();
        clsPrefs.put(ALGORITHM, this.myAlgorithm.getSelectedItem().toString());
        String fileName = this.myFileName.getText();
        File fileToHash = new File(fileName);
        if (!fileToHash.exists()) {
            JOptionPane.showMessageDialog(this, "Could not access file", "Problem", 0);
            return;
        }
        this.myResults.setOpaque(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            int totalBytesRead = 0;
            byte[] input = new byte[1000000];
            FileInputStream is = new FileInputStream(fileToHash);
            int bytesRead = ((InputStream)is).read(input);
            totalBytesRead = bytesRead < input.length ? bytesRead : (totalBytesRead += bytesRead);
            while (bytesRead == input.length) {
                md.update(input);
                bytesRead = ((InputStream)is).read(input);
                totalBytesRead += bytesRead;
            }
            byte[] finalInput = new byte[bytesRead];
            for (int i = 0; i < bytesRead; ++i) {
                finalInput[i] = input[i];
            }
            md.update(finalInput);
            ((InputStream)is).close();
            System.out.println("fileToHash.length(): " + fileToHash.length());
            System.out.println("totalBytesRead:      " + totalBytesRead);
            if (fileToHash.length() != (long)totalBytesRead) {
                JOptionPane.showMessageDialog(this, "Could not read entire file", "Problem Encountered", 0);
                return;
            }
            byte[] theHashAsBytes = md.digest();
            String hexHash = CheckSumChecker.asHex(theHashAsBytes);
            this.myComputedHash.setText(hexHash);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Problem Encountered", 0);
            return;
        }
        if (this.myDownloadedHash.getText().trim().length() > 0) {
            this.checkHashes();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void checkHashes() {
        String computedHash = this.myComputedHash.getText().trim();
        this.myResults.setOpaque(true);
        if (computedHash.length() == 0) {
            this.go();
            computedHash = this.myComputedHash.getText().trim();
            if (computedHash.length() == 0) {
                this.myResults.setText("You need to compute a hash on a file first.");
                this.myResults.setBackground(Color.YELLOW);
                return;
            }
        }
        String downloadedHash = this.myDownloadedHash.getText();
        if ((downloadedHash = downloadedHash.trim()).length() == 0) {
            this.myResults.setText("You need to enter a hash to compare against.");
            this.myResults.setBackground(Color.YELLOW);
            return;
        }
        if (computedHash.equals(downloadedHash)) {
            this.myResults.setText("The hashes match.");
            this.myResults.setBackground(Color.GREEN);
        } else {
            this.myResults.setText("The hashes do not match.");
            this.myResults.setBackground(Color.RED);
        }
    }

    public static String asHex(byte[] hash) {
        char[] buf = new char[hash.length * 2];
        int x = 0;
        for (int i = 0; i < hash.length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }

    public static void main(String[] args) {
        new CheckSumChecker();
    }
}

