/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textPad;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.LicenseBox;
import org.gerhardb.jibs.textPad.TextPad;
import org.gerhardb.jibs6.Jibs6Hacks;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.print.PrintableText;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.app.AboutBox;
import org.gerhardb.lib.util.app.Info;
import org.gerhardb.lib.util.startup.ActiveActions;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.FactoryDefaultActions;

public class TextPadActions
extends ActiveActions {
    TextPad myTextPad;

    public TextPadActions(TextPad ss) {
        this.myTextPad = ss;
    }

    public Action getAction(String menu, String item) {
        menu = "SortScreen.menu." + menu;
        return super.getAction(menu, item);
    }

    protected FactoryDefaultActions getFactoryDefaultActions() {
        return new DefaultStartupActions();
    }

    public JButton getToolBarButton(String menu, String item) {
        JButton rtnMe = this.getAccelleratedToolBarButton(menu, item);
        return rtnMe;
    }

    JMenu getFileMenu() {
        JMenuItem openOneFileMenu = new JMenuItem("Open File");
        openOneFileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TextPadActions.this.myTextPad.open();
            }
        });
        JMenuItem copyMenu = new JMenuItem("Copy All");
        copyMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new PrintableText(TextPadActions.this.myTextPad.myEditorPane).copy();
            }
        });
        JMenu move = ActionHelpers.makeMenu("move");
        move.add(this.makeMenuItem("file", "repeat"));
        move.add(this.makeMenuItem("file", "park"));
        move.add(this.makeMenuItem("file", "trash"));
        move.add(this.makeMenuItem("file", "directoryList"));
        JMenu fileMenu = ActionHelpers.makeMenu("file");
        fileMenu.add(openOneFileMenu);
        fileMenu.add(this.makeMenuItem("file", "openview"));
        fileMenu.add(this.myTextPad.myLST.getPathManager().getRecentDirMenu());
        fileMenu.add(this.makeMenuItem("file", "opentree"));
        fileMenu.add(this.myTextPad.myLST.getPathManager().getRecentTreeMenu());
        Action action = this.getAction("file", "defaultFileView");
        if (action != null) {
            fileMenu.add(new JMenuItem(action));
        }
        fileMenu.addSeparator();
        fileMenu.add(move);
        fileMenu.add(this.makeMenuItem("file", "empty"));
        fileMenu.addSeparator();
        JMenuItem exit = this.makeMenuItem("file", "exit");
        String closeOrExit = "Close";
        if (this.myTextPad.iExitOnClose) {
            closeOrExit = "Exit";
        }
        exit.setText(closeOrExit);
        fileMenu.add(exit);
        return fileMenu;
    }

    JMenu getEditMenu() {
        JMenu menu = ActionHelpers.makeMenu("edit");
        menu.add(this.makeMenuItem("edit", "undo"));
        menu.add(this.makeMenuItem("edit", "redo"));
        return menu;
    }

    JMenu getViewMenu() {
        JMenu menu = ActionHelpers.makeMenu("view");
        menu.add(this.makeMenuItem("view", "reload"));
        menu.add(this.makeMenuItem("view", "back"));
        menu.add(this.makeMenuItem("view", "forward"));
        return menu;
    }

    JMenu getHelpMenu() {
        JMenu menu = ActionHelpers.makeMenu("help");
        menu.add(this.makeMenuItem("help", "help"));
        menu.add(this.makeMenuItem("help", "about"));
        menu.add(this.makeMenuItem("help", "license"));
        menu.add(this.makeMenuItem("help", "info"));
        return menu;
    }

    class LicenseAction
    extends AbstractAction {
        LicenseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new LicenseBox(TextPadActions.this.myTextPad);
        }
    }

    class InfoAction
    extends AbstractAction {
        InfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Show Info not yet available.");
            new Info(TextPadActions.this.myTextPad, TextPadActions.this.myTextPad);
        }
    }

    class AboutAction
    extends AbstractAction {
        AboutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new AboutBox(TextPadActions.this.myTextPad);
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean showedDesktopDialog = false;
            try {
                if (AppStarter.isJava6Enabled()) {
                    showedDesktopDialog = Jibs6Hacks.helpToBrowser((JFrame)TextPadActions.this.myTextPad);
                }
            }
            catch (NoClassDefFoundError ex) {
                JOptionPane.showMessageDialog(TextPadActions.this.myTextPad, Jibs.getString("SortScreen.10"), Jibs.getString("SortScreen.51"), 1);
            }
            if (!showedDesktopDialog) {
                JOptionPane.showMessageDialog(TextPadActions.this.myTextPad, Jibs.getString("SortScreen.10"), Jibs.getString("SortScreen.51"), 1);
            }
        }
    }

    class RenameAction
    extends AbstractAction {
        RenameAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TextPadActions.this.myTextPad.myLST.getFileList().renameSomeFiles();
        }
    }

    class ForwardAction
    extends AbstractAction {
        ForwardAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            TextPadActions.this.myTextPad.myLST.getFileListManager().forward();
        }
    }

    class BackAction
    extends AbstractAction {
        BackAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            TextPadActions.this.myTextPad.myLST.getFileListManager().back();
        }
    }

    class ReloadAction
    extends AbstractAction {
        ReloadAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            TextPadActions.this.myTextPad.setCursor(Cursor.getPredefinedCursor(3));
            TextPadActions.this.myTextPad.myLST.reloadScroller();
            TextPadActions.this.myTextPad.setCursor(Cursor.getDefaultCursor());
        }
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            FileList list = TextPadActions.this.myTextPad.myLST.getFileList();
            list.clearSelection();
            list.addSelectionInterval(0, list.getModel().getSize() - 1);
            TextPadActions.this.myTextPad.myLST.showPageFromScroller();
        }
    }

    class CopyAction
    extends AbstractAction {
        CopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("myTextPad.myShow.getSaver().copy(); not yet available.");
        }
    }

    class RedoAction
    extends AbstractAction {
        RedoAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            TextPadActions.this.myTextPad.myLST.getRDPmanager().getMoveManager().getUndoManager().redo();
            TextPadActions.this.myTextPad.myLST.getRDPmanager().getMoveManager().updateUndoRedoButtons();
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            TextPadActions.this.myTextPad.myLST.getRDPmanager().getMoveManager().getUndoManager().undo();
            TextPadActions.this.myTextPad.myLST.getRDPmanager().getMoveManager().updateUndoRedoButtons();
        }
    }

    class TreeDirectoryAction
    extends AbstractAction {
        TreeDirectoryAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TextPadActions.this.myTextPad.myLST.getTreeManager().setTreeDirectory();
        }
    }

    class ViewDirectoryAction
    extends AbstractAction {
        ViewDirectoryAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TextPadActions.this.myTextPad.myLST.getFileListManager().askUserForViewDirectory(TextPadActions.this.myTextPad);
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TextPadActions.this.myTextPad.exit();
        }
    }

    class EmptyTrashAction
    extends AbstractAction {
        EmptyTrashAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TextPadActions.this.myTextPad.myLST.getRDPmanager().emptyTrash();
        }
    }

    class DirectoryListAction
    extends AbstractAction {
        DirectoryListAction() {
            super(null, Icons.icon(29));
        }

        public void actionPerformed(ActionEvent ae) {
            TextPadActions.this.myTextPad.myLST.getRDPmanager().clickDirectoryList();
        }
    }

    class RepeatAction
    extends AbstractAction {
        RepeatAction() {
            super(null, Icons.icon(15));
        }

        public void actionPerformed(ActionEvent ae) {
            TextPadActions.this.myTextPad.myLST.getRDPmanager().clickRepeat();
        }
    }

    class ParkAction
    extends AbstractAction {
        ParkAction() {
            super(null, Icons.icon(14));
        }

        public void actionPerformed(ActionEvent ae) {
            TextPadActions.this.myTextPad.myLST.getRDPmanager().clickPark();
        }
    }

    class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            super(null, Icons.icon(3));
        }

        public void actionPerformed(ActionEvent ae) {
            TextPadActions.this.myTextPad.myLST.getRDPmanager().clickTrash();
        }
    }

    private class DefaultStartupActions
    extends FactoryDefaultActions {
        public DefaultStartupActions() {
            this.addStartupAction("SortScreen.menu", "file", "repeat", new RepeatAction(), Icons.icon(15));
            this.addStartupAction("SortScreen.menu", "file", "park", new ParkAction(), Icons.icon(14));
            this.addStartupAction("SortScreen.menu", "file", "trash", new DeleteAction(), Icons.icon(3));
            this.addStartupAction("SortScreen.menu", "file", "directoryList", new DirectoryListAction(), Icons.icon(29));
            this.addStartupAction("SortScreen.menu", "file", "openview", new ViewDirectoryAction(), null);
            this.addStartupAction("SortScreen.menu", "file", "opentree", new TreeDirectoryAction(), null);
            try {
                Action defaultFileViewerAction;
                if (AppStarter.isJava6Enabled() && (defaultFileViewerAction = Jibs6Hacks.getDefaultFileViewerAction((Scroller)TextPadActions.this.myTextPad.myLST.getScroller())) != null) {
                    this.addStartupAction("SortScreen.menu", "file", "defaultFileView", defaultFileViewerAction, null);
                }
            }
            catch (NoClassDefFoundError ex) {
                ex.printStackTrace();
            }
            this.addStartupAction("SortScreen.menu", "file", "empty", new EmptyTrashAction(), null);
            this.addStartupAction("SortScreen.menu", "file", "rename", new RenameAction(), Icons.icon(13));
            this.addStartupAction("SortScreen.menu", "file", "exit", new ExitAction(), null);
            this.addStartupAction("SortScreen.menu", "edit", "undo", new UndoAction(), Icons.icon(4));
            this.addStartupAction("SortScreen.menu", "edit", "redo", new RedoAction(), Icons.icon(5));
            this.addStartupAction("SortScreen.menu", "edit", "copy", new CopyAction(), null);
            this.addStartupAction("SortScreen.menu", "edit", "all", new SelectAllAction(), null);
            this.addStartupAction("SortScreen.menu", "view", "reload", new ReloadAction(), Icons.icon(6));
            this.addStartupAction("SortScreen.menu", "view", "back", new BackAction(), Icons.icon(24));
            this.addStartupAction("SortScreen.menu", "view", "forward", new ForwardAction(), Icons.icon(25));
            this.addStartupAction("SortScreen.menu", "help", "help", new HelpAction(), Icons.icon(7));
            this.addStartupAction("SortScreen.menu", "help", "about", new AboutAction(), Icons.icon(9));
            this.addStartupAction("SortScreen.menu", "help", "license", new LicenseAction(), null);
            this.addStartupAction("SortScreen.menu", "help", "info", new InfoAction(), null);
        }
    }
}

