/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textCompare;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import org.gerhardb.jibs.textCompare.TextCompareListItem;
import org.gerhardb.jibs.textCompare.TextComparePanel;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.util.Stoppable;

public class TextCompareWorker
implements Stoppable {
    DefaultListModel myPossibleDuplicates;
    TextComparePanel myPanel;
    File[] myDirectories;
    File[] myFiles;
    String[] myBigSamples;
    boolean iStop = false;
    int maxTextToLookAt = 50000;
    int cutoverFromAllToCompareTo = 1000;
    int compareToStart = 500;
    int compareToStop = this.cutoverFromAllToCompareTo;
    int cutoverSampleA = 200;
    int samplePitchA = 100;
    int cutoverSampleB = 400;
    int samplePitchB = 200;
    int sampleSize = 20;

    public TextCompareWorker(File[] directories, DefaultListModel dups, TextComparePanel panel) {
        this.myDirectories = directories;
        this.myPossibleDuplicates = dups;
        this.myPanel = panel;
    }

    public void run() {
        int i;
        this.myPanel.myStartBtn.setEnabled(false);
        this.myPanel.myStopBtn.setEnabled(true);
        this.myPanel.myCurrentAction.setText("Getting Files");
        Arrays.sort(this.myDirectories);
        ArrayList<File> theList = new ArrayList<File>(5000);
        for (i = 0; i < this.myDirectories.length; ++i) {
            File[] someFiles = this.myDirectories[i].listFiles();
            for (int j = 0; j < someFiles.length; ++j) {
                if (!someFiles[j].isFile()) continue;
                theList.add(someFiles[j]);
            }
        }
        this.myFiles = new File[theList.size()];
        theList.toArray(this.myFiles);
        theList = null;
        Arrays.sort(this.myFiles);
        this.myPanel.myCurrentAction.setText("Getting Samples");
        this.myBigSamples = new String[this.myFiles.length];
        for (i = 0; i < this.myBigSamples.length; ++i) {
            try {
                this.addSample(i);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (!this.iStop) continue;
            this.myPanel.myCurrentAction.setText("Stopped");
            return;
        }
        try {
            this.myPanel.myCurrentAction.setText("Comparing Files");
            this.compareList();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myPanel.myStartBtn.setEnabled(true);
        this.myPanel.myStopBtn.setEnabled(false);
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        System.out.println("                    ALL DONE!");
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
    }

    public void stop() {
        this.iStop = true;
    }

    void addSample(int index) throws Exception {
        File aFile = this.myFiles[index];
        String text = FileUtil.getStringFromFile(aFile);
        if (text.length() > this.maxTextToLookAt) {
            text = text.substring(this.maxTextToLookAt);
        }
        String[] words = text.split("\\W+");
        text = null;
        int start = 0;
        int stop = words.length;
        if (words.length > this.cutoverFromAllToCompareTo) {
            start = this.compareToStart;
            stop = this.compareToStop;
        }
        StringBuffer buff = new StringBuffer(2000);
        for (int i = start; i < stop; ++i) {
            buff.append(words[i]);
            buff.append(" ");
        }
        this.myBigSamples[index] = buff.toString();
    }

    void compareList() throws Exception {
        this.myPanel.myProgressBar.getModel().setMaximum(this.myFiles.length);
        for (int i = 0; i < this.myFiles.length; ++i) {
            if (this.myBigSamples[i] != null) {
                String[] words = this.myBigSamples[i].split("\\W+");
                StringBuffer testBuff = new StringBuffer(10000);
                int maxThrowAway = 0;
                if (words.length > this.cutoverSampleA) {
                    maxThrowAway = this.samplePitchA;
                } else if (words.length > this.cutoverSampleB) {
                    maxThrowAway = this.samplePitchB;
                }
                int upperLimit = maxThrowAway + this.sampleSize;
                if (upperLimit > words.length) {
                    upperLimit = words.length;
                }
                for (int j = maxThrowAway; j < upperLimit; ++j) {
                    testBuff.append(words[j]);
                    testBuff.append(" ");
                }
                String compareSample = testBuff.toString();
                this.findComparables(i, compareSample);
            }
            this.myPanel.myProgressBar.getModel().setValue(i + 1);
            if (!this.iStop) continue;
            this.myPanel.myCurrentAction.setText("Stopped");
            return;
        }
        this.myPanel.myCurrentAction.setText("Done");
    }

    void findComparables(int baseIndex, String compare) throws Exception {
        for (int i = baseIndex + 1; i < this.myFiles.length; ++i) {
            File[] deleteDir;
            TextCompareListItem item;
            String testSample = this.myBigSamples[i];
            if (testSample != null && testSample.indexOf(compare) > -1 && !(item = new TextCompareListItem(this.myFiles[baseIndex], this.myFiles[i])).autoRemoved(deleteDir = new File[0])) {
                this.myPossibleDuplicates.addElement(item);
            }
            if (!this.iStop) continue;
            this.myPanel.myCurrentAction.setText("Stopped");
            return;
        }
    }
}

