/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.producer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gerhardb.jibs.producer.Audio;
import org.gerhardb.jibs.producer.Play;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxPlayListParser
extends DefaultHandler {
    List myPlayList = new ArrayList();
    private Play currentPlay;

    SaxPlayListParser() {
    }

    private void parseDocument(File file) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(file, (DefaultHandler)this);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    private void printData() {
        System.out.println("No of Play Items: '" + this.myPlayList.size() + "'." + "\n");
        Iterator it = this.myPlayList.iterator();
        while (it.hasNext()) {
            System.out.println(it.next().toString());
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("play")) {
            Play play;
            this.currentPlay = play = new Play();
            play.setImageFile(attributes.getValue("image"));
            play.setCaption(attributes.getValue("caption"));
            play.setMinSeconds(attributes.getValue("minTime"));
            this.myPlayList.add(play);
        }
        if (qName.equalsIgnoreCase("audio")) {
            Audio audio = new Audio();
            audio.setFile(attributes.getValue("file"));
            this.currentPlay.addAudio(audio);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public static void main(String[] args) {
        try {
            File playFile = new File("/dev/workspaces/JIBS/src/test/java/org/gerhardb/jibs6/producer/playList-01.xml");
            if (playFile.exists()) {
                System.out.println("Found sample file");
            } else {
                System.out.println("Could not find sample file");
                System.exit(99);
            }
            SaxPlayListParser parser = new SaxPlayListParser();
            parser.parseDocument(playFile);
            System.out.println("=======================");
            parser.printData();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

