/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.producer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.gerhardb.lib.image.ImageChangeUtil;

public class PicturePanel
extends JPanel {
    private static final Color OK_COLOR = Color.black;
    private static final Color RESIZE_COLOR = Color.black;
    private static final Color NFG_COLOR = Color.green;
    private BufferedImage myCurrentImage;

    public void showPicture(BufferedImage image) {
        this.myCurrentImage = image;
        this.repaint();
    }

    protected void showNoPicture(Graphics g) {
        super.setBackground(NFG_COLOR);
        super.paintComponent(g);
    }

    public void paint(Graphics g) {
        int centerHeight;
        Color backgroundColor = OK_COLOR;
        BufferedImage showMe = this.myCurrentImage;
        if (showMe == null) {
            this.showNoPicture(g);
            return;
        }
        BufferedImage originalImage = showMe;
        showMe = ImageChangeUtil.fitAspectDown(showMe, super.getWidth(), super.getHeight());
        if (originalImage.getWidth() > showMe.getWidth() || originalImage.getHeight() > showMe.getHeight()) {
            backgroundColor = RESIZE_COLOR;
        }
        super.setBackground(backgroundColor);
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int centerWidth = (super.getWidth() - showMe.getWidth()) / 2;
        if (centerWidth < 0) {
            centerWidth = 0;
        }
        if ((centerHeight = (super.getHeight() - showMe.getHeight()) / 2) < 0) {
            centerHeight = 0;
        }
        g2.drawImage(showMe, null, centerWidth, centerHeight);
    }
}

