/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.dirtools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.gerhardb.jibs.dirtools.DirCopyPanel;
import org.gerhardb.lib.io.DirListController;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

public class DirectoryCopy
extends JFrame {
    public static String APP_NAME = "DirectoryCopy";
    boolean iExitOnClose;
    DirListController myIncludeList = new DirListController("Include", "DirToolsInclude", true, APP_NAME);
    DirListController myExcludeList = new DirListController("Exclude", "DirToolsExclude", true, APP_NAME);

    public DirectoryCopy(boolean exitOnClose) {
        this.init(exitOnClose);
    }

    void init(boolean exitOnClose) {
        this.iExitOnClose = exitOnClose;
        this.setTitle("JIBS Directory Copy");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DirectoryCopy.this.exit();
            }
        });
        this.enableEvents(64L);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*** Unkonwn abnormal termination ***");
            System.exit(99);
        }
        this.setIconImage(Icons.icon(26).getImage());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DirectoryCopy.this.validate();
                DirectoryCopy.this.pack();
                SwingUtils.centerOnScreen(DirectoryCopy.this);
                DirectoryCopy.this.setVisible(true);
            }
        });
    }

    private void layoutComponents() throws Exception {
        JTabbedPane jTabbed = new JTabbedPane();
        jTabbed.addTab("Include", this.myIncludeList.getPanel());
        jTabbed.addTab("Exclude", this.myExcludeList.getPanel());
        jTabbed.addTab("Directory Copy", new DirCopyPanel(this));
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)jTabbed, "Center");
        this.setContentPane(new JScrollPane(thePanel));
    }

    private void exit() {
        if (this.iExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        new DirectoryCopy(true);
    }
}

