/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.camera;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.camera.CameraPanel;
import org.gerhardb.jibs.camera.CameraPreferences;
import org.gerhardb.lib.io.DirListController;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

public class Camera
extends JFrame {
    public static String APP_NAME = "Camera";
    boolean iExitOnClose;
    DirListController myWorkingList = new DirListController("Camera", "Camera", false, APP_NAME);

    public Camera(boolean exitOnClose) {
        this.init(exitOnClose);
    }

    void init(boolean exitOnClose) {
        this.iExitOnClose = exitOnClose;
        this.setTitle(Jibs.getString("Camera.2"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Camera.this.exit();
            }
        });
        this.enableEvents(64L);
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*** Unkonwn abnormal termination ***");
            System.exit(99);
        }
        this.setIconImage(Icons.icon(26).getImage());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Camera.this.validate();
                Camera.this.pack();
                SwingUtils.centerOnScreen(Camera.this);
                Camera.this.setVisible(true);
            }
        });
    }

    private void layoutComponents() throws Exception {
        JTabbedPane jTabbed = new JTabbedPane();
        jTabbed.addTab(Jibs.getString("Camera.4"), this.myWorkingList.getPanel());
        jTabbed.addTab(Jibs.getString("Camera.5"), new CameraPanel(this));
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)jTabbed, "Center");
        this.setContentPane(new JScrollPane(thePanel));
    }

    private void exit() {
        CameraPreferences.flush();
        if (this.iExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        new Camera(true);
    }
}

