/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.util.UtilException;

public class QTByteObject
implements PrimitivesLib,
Serializable {
    private static Object linkage;
    protected transient byte[] bytes;
    static /* synthetic */ Class class$quicktime$util$QTByteObject;

    public static QTByteObject fromArray(byte[] byArray) {
        QTByteObject qTByteObject = new QTByteObject();
        qTByteObject.bytes = byArray;
        return qTByteObject;
    }

    private QTByteObject() {
    }

    protected QTByteObject(int n) {
        if (n > 0) {
            this.bytes = new byte[n];
        }
    }

    protected QTByteObject(byte[] byArray) {
        this(byArray.length);
        System.arraycopy(byArray, 0, this.bytes, 0, byArray.length);
    }

    protected final void setBytesAt(int n, int n2, byte[] byArray, int n3) {
        System.arraycopy(byArray, n3, this.bytes, n, n2);
    }

    protected final void getBytesAt(int n, int n2, byte[] byArray, int n3) {
        System.arraycopy(this.bytes, n, byArray, n3, n2);
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public int getSize() {
        return this.bytes.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof QTByteObject) {
            byte[] byArray = ((QTByteObject)object).bytes;
            if (byArray.length != this.bytes.length) {
                return false;
            }
            for (int i = 0; i < this.bytes.length; ++i) {
                if (this.bytes[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected final byte getByteAt(int n) {
        return this.bytes[n];
    }

    protected final short getShortAt(int n) {
        return QTByteObject.getShortFromArray(this.bytes, n);
    }

    protected final int getIntAt(int n) {
        return QTByteObject.getIntFromArray(this.bytes, n);
    }

    protected final long getLongAt(int n) {
        return QTByteObject.getLongFromArray(this.bytes, n);
    }

    protected final float getFloatAt(int n) {
        return QTByteObject.getFloatFromArray(this.bytes, n);
    }

    protected final double getDoubleAt(int n) {
        return QTByteObject.getDoubleFromArray(this.bytes, n);
    }

    protected final void setByteAt(int n, byte by) {
        this.bytes[n] = by;
    }

    protected final void setShortAt(int n, short s) {
        QTByteObject.setShortInArray(this.bytes, n, s);
    }

    protected final void setIntAt(int n, int n2) {
        QTByteObject.setIntInArray(this.bytes, n, n2);
    }

    protected final void setLongAt(int n, long l) {
        QTByteObject.setLongInArray(this.bytes, n, l);
    }

    protected final void setFloatAt(int n, float f) {
        QTByteObject.setFloatInArray(this.bytes, n, f);
    }

    protected final void setDoubleAt(int n, double d) {
        QTByteObject.setDoubleInArray(this.bytes, n, d);
    }

    protected int strlen(int n) {
        int n2 = 0;
        while (this.getByteAt(n++) != 0) {
            ++n2;
        }
        return n2;
    }

    protected String getCStringAt(int n) throws UtilException {
        int n2 = this.strlen(n);
        if (n2 > this.getSize()) {
            throw new UtilException(-50);
        }
        byte[] byArray = new byte[n2];
        this.getBytesAt(n, n2, byArray, 0);
        return new String(byArray);
    }

    protected void setCStringAt(int n, int n2, String string) throws UtilException {
        if ((n2 = Math.min(n2, string.length())) + n > this.getSize()) {
            throw new UtilException(-50);
        }
        byte[] byArray = string.getBytes();
        this.setBytesAt(n, n2, byArray, 0);
        this.setByteAt(n + n2, (byte)0);
    }

    protected String getPStringAt(int n) throws UtilException {
        byte by;
        if ((by = this.getByteAt(n++)) > this.getSize()) {
            throw new UtilException(-50);
        }
        byte[] byArray = new byte[by];
        this.getBytesAt(n, by, byArray, 0);
        return new String(byArray);
    }

    protected void setPStringAt(int n, int n2, String string) throws UtilException {
        if ((n2 = Math.min(Math.min(n2, string.length()), 255)) + n > this.getSize()) {
            throw new UtilException(-50);
        }
        this.setByteAt(n++, (byte)n2);
        byte[] byArray = string.getBytes();
        this.setBytesAt(n, n2, byArray, 0);
    }

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native long getLongFromArray(byte[] var0, int var1);

    private static native float getFloatFromArray(byte[] var0, int var1);

    private static native double getDoubleFromArray(byte[] var0, int var1);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native void setLongInArray(byte[] var0, int var1, long var2);

    private static native void setFloatInArray(byte[] var0, int var1, float var2);

    private static native void setDoubleInArray(byte[] var0, int var1, double var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$util$QTByteObject == null ? (class$quicktime$util$QTByteObject = QTByteObject.class$("quicktime.util.QTByteObject")) : class$quicktime$util$QTByteObject);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

