/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.orf;

import it.tidalwave.imageio.orf.ImageProcessing;
import it.tidalwave.imageio.orf.OlympusMakerNote;
import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.util.Logger;
import javax.annotation.Nonnull;

public class ORFWhiteBalanceOperation
extends OperationSupport {
    private static final String CLASS = ORFWhiteBalanceOperation.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public ORFWhiteBalanceOperation() {
        super(Source.Type.RAW);
    }

    public void process(@Nonnull PipelineArtifact artifact) {
        logger.fine("process(%s)", artifact);
        OlympusMakerNote makerNote = (OlympusMakerNote)artifact.getRAWMetadata().getMakerNote();
        if (makerNote != null) {
            if (makerNote.isRedBalanceAvailable() && makerNote.isBlueBalanceAvailable()) {
                logger.finest(">>>> RB from makerNote.{red,blue}Balance", new Object[0]);
                artifact.multiplyRedCoefficient((double)makerNote.getRedBalance()[0] / 256.0);
                artifact.multiplyBlueCoefficient((double)makerNote.getBlueBalance()[0] / 256.0);
            } else if (makerNote.isImageProcessingAvailable()) {
                logger.finest(">>>> RB from makerNote.imageProcessing", new Object[0]);
                ImageProcessing imageProcessing = makerNote.getOlympusImageProcessing();
                if (imageProcessing != null && imageProcessing.isRBCoefficientsAvailable()) {
                    int[] rbCoefficients = imageProcessing.getRBCoefficients();
                    artifact.multiplyRedCoefficient((double)rbCoefficients[0] / 256.0);
                    artifact.multiplyBlueCoefficient((double)rbCoefficients[1] / 256.0);
                }
            }
        }
    }
}

