/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.cr2;

import it.tidalwave.imageio.cr2.CanonCR2MakerNote;
import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.util.Logger;
import javax.annotation.Nonnull;

public class CR2WhiteBalanceOperation
extends OperationSupport {
    private static final Logger logger = CR2WhiteBalanceOperation.getLogger(CR2WhiteBalanceOperation.class);

    public CR2WhiteBalanceOperation() {
        super(Source.Type.RAW);
    }

    public void process(@Nonnull PipelineArtifact artifact) {
        logger.fine("process(%s)", artifact);
        CanonCR2MakerNote cr2Makernote = (CanonCR2MakerNote)artifact.getRAWMetadata().getMakerNote();
        short[] coefficients = cr2Makernote.getWhiteBalanceCoefficients();
        double scale = 9.765625E-4;
        artifact.multiplyRedCoefficient(9.765625E-4 * (double)coefficients[0]);
        artifact.multiplyGreenCoefficient(9.765625E-4 * (double)coefficients[1]);
        artifact.multiplyBlueCoefficient(9.765625E-4 * (double)coefficients[3]);
    }
}

