/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import it.tidalwave.imageio.raw.RAWImageReader;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class Source
implements Serializable {
    private static final String CLASS = Source.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    @Nonnull
    public static final Source PROCESSED_IMAGE = new Source(){

        @Nonnull
        protected Dimension getDimension(@Nonnull RAWImageReader ir) throws IOException {
            return new Dimension(ir.getWidth(0), ir.getHeight(0));
        }

        @Nonnull
        protected BufferedImage readImage(@Nonnull RAWImageReader ir) throws IOException {
            return ((RAWImageReaderSupport)ir).loadImage(0);
        }

        protected int getImageCount(@Nonnull RAWImageReader ir) {
            return 1;
        }

        protected boolean needsPostProcessor() {
            return true;
        }

        @Nonnull
        public Type getType() {
            return Type.RAW;
        }

        @Nonnull
        public String toString() {
            return "PROCESSED_IMAGE";
        }
    };
    @Nonnull
    public static final Source RAW_IMAGE = new Source(){

        @Nonnull
        protected Dimension getDimension(@Nonnull RAWImageReader ir) throws IOException {
            return new Dimension(ir.getWidth(0), ir.getHeight(0));
        }

        @Nonnull
        protected BufferedImage readImage(@Nonnull RAWImageReader ir) throws IOException {
            return ((RAWImageReaderSupport)ir).loadImage(0);
        }

        protected boolean needsPostProcessor() {
            return false;
        }

        protected int getImageCount(@Nonnull RAWImageReader ir) {
            return 1;
        }

        @Nonnull
        public Type getType() {
            return Type.RAW;
        }

        @Nonnull
        public String toString() {
            return "RAW_IMAGE";
        }
    };
    @Nonnull
    public static final Source FULL_SIZE_PREVIEW = new Source(){

        @Nonnull
        protected Dimension getDimension(@Nonnull RAWImageReader ir) throws IOException {
            int t = this.findFullSizeThumbnailIndex(ir);
            return new Dimension(ir.getThumbnailWidth(0, t), ir.getThumbnailHeight(0, t));
        }

        @Nonnull
        protected BufferedImage readImage(@Nonnull RAWImageReader ir) throws IOException {
            int t = this.findFullSizeThumbnailIndex(ir);
            return ir.readThumbnail(0, t);
        }

        protected boolean needsPostProcessor() {
            return true;
        }

        @Nonnull
        public Type getType() {
            return Type.NORMAL;
        }

        protected int getImageCount(@Nonnull RAWImageReader ir) {
            try {
                this.findFullSizeThumbnailIndex(ir);
                return 1;
            }
            catch (IOException e) {
                return 0;
            }
        }

        @Nonnull
        public String toString() {
            return "FULL_SIZE_PREVIEW";
        }

        private int findFullSizeThumbnailIndex(@Nonnull RAWImageReader ir) throws IOException {
            ir.getImageMetadata(0);
            int imageWidth = ir.getWidth(0);
            int imageHeight = ir.getHeight(0);
            for (int t = 0; t < ir.getNumThumbnails(0); ++t) {
                int thumbnailWidth = ir.getThumbnailWidth(0, t);
                int thumbnailHeight = ir.getThumbnailHeight(0, t);
                logger.finest(">>>> expected: %d x %d, probing: %d x %d", imageWidth, imageHeight, thumbnailWidth, thumbnailHeight);
                if ((imageWidth != thumbnailWidth || imageHeight != thumbnailHeight) && (imageWidth != thumbnailHeight || imageHeight != thumbnailWidth)) continue;
                return t;
            }
            throw new IOException("Can't find full-size preview in this image");
        }
    };
    private static final Map<String, Source> DEFAULT_MAP = new HashMap<String, Source>();
    public static final String PROP_DEFAULT_SOURCE = "it.tidalwave.imageio.raw.defaultSource";
    public static final String DEFAULT_SOURCE_FULL_SIZE_PREVIEW = "fullSizePreview";
    public static final String DEFAULT_SOURCE_PROCESSED_IMAGE = "image";
    public static final String DEFAULT_SOURCE_RAW_IMAGE = "rawImage";

    protected Source() {
    }

    @Nonnull
    public static Source getDefault() {
        String value = System.getProperty(PROP_DEFAULT_SOURCE, "");
        Source defaultSource = DEFAULT_MAP.get(value);
        if (defaultSource == null) {
            throw new IllegalArgumentException(String.format("Invalid value for %s: %s", PROP_DEFAULT_SOURCE, value));
        }
        return defaultSource;
    }

    @Nonnull
    protected abstract Dimension getDimension(@Nonnull RAWImageReader var1) throws IOException;

    @Nonnull
    protected abstract BufferedImage readImage(@Nonnull RAWImageReader var1) throws IOException;

    protected abstract int getImageCount(@Nonnull RAWImageReader var1);

    protected abstract boolean needsPostProcessor();

    public abstract Type getType();

    static {
        DEFAULT_MAP.put("", PROCESSED_IMAGE);
        DEFAULT_MAP.put(DEFAULT_SOURCE_PROCESSED_IMAGE, PROCESSED_IMAGE);
        DEFAULT_MAP.put(DEFAULT_SOURCE_RAW_IMAGE, RAW_IMAGE);
        DEFAULT_MAP.put(DEFAULT_SOURCE_FULL_SIZE_PREVIEW, FULL_SIZE_PREVIEW);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NORMAL,
        RAW;

    }
}

