/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;

public abstract class RAWMetadataSupport
extends IIOMetadata {
    private static final String CLASS = RAWMetadataSupport.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    @Nonnull
    protected final Directory realPrimaryIFD;
    @CheckForNull
    protected final HeaderProcessor headerProcessor;
    @Nonnull
    private final String nativeFormatName;
    @CheckForNull
    private Dimension overriddenImageSize;

    public RAWMetadataSupport(@Nonnull Directory primaryDirectory, @Nonnull String nativeFormatName, @CheckForNull HeaderProcessor headerProcessor) {
        this.nativeFormatName = nativeFormatName;
        this.realPrimaryIFD = primaryDirectory;
        this.headerProcessor = headerProcessor;
    }

    @CheckForNull
    public HeaderProcessor getHeaderProcessor() {
        return this.headerProcessor;
    }

    @Nonnull
    public Node getAsTree(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException("Null formatName");
        }
        if (this.nativeFormatName.equals(formatName)) {
            return this.getNativeTree(formatName);
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    public abstract Directory getMakerNote();

    protected abstract Node getNativeTree(String var1);

    public boolean isStandardMetadataFormatSupported() {
        return true;
    }

    @Nonnull
    public String getNativeMetadataFormatName() {
        return this.nativeFormatName;
    }

    @Nonnull
    public String[] getExtraMetadataFormatNames() {
        return new String[0];
    }

    public boolean isReadOnly() {
        return true;
    }

    public void mergeTree(String formatName, Node root) {
        throw new UnsupportedOperationException("RAWMetadata.mergeTree()");
    }

    public void reset() {
        throw new UnsupportedOperationException("RAWMetadata.reset()");
    }

    @Nonnegative
    public final int getWidth() {
        return (this.overriddenImageSize != null ? this.overriddenImageSize : this.getImageSize()).width;
    }

    @Nonnegative
    public final int getHeight() {
        return (this.overriddenImageSize != null ? this.overriddenImageSize : this.getImageSize()).height;
    }

    @Nonnull
    protected abstract Dimension getImageSize();

    public void setOverriddenImageSize(@Nonnull Dimension overriddenSize) {
        logger.fine("setOverriddenImageSize(%s)", overriddenSize);
        this.overriddenImageSize = overriddenSize;
    }

    @Nonnull
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName() + "[");
        buffer.append("\n****primaryDirectory: " + this.realPrimaryIFD);
        return buffer.toString();
    }
}

